/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.distributions;

import org.apache.commons.math.special.Beta;
import org.renjin.primitives.MathExt;
import org.renjin.stats.internals.distributions.SignRank;

public class Utils {
    public static double brcmp1_result = 0.0;

    public static double Rf_d1mach(int i) {
        switch (i) {
            case 1: {
                return Double.MIN_VALUE;
            }
            case 2: {
                return Double.MAX_VALUE;
            }
            case 3: {
                return 0.5 * SignRank.DBL_EPSILON;
            }
            case 4: {
                return SignRank.DBL_EPSILON;
            }
            case 5: {
                return Math.log10(2.0);
            }
        }
        return 0.0;
    }

    public static void L100(double[] w, double[] w1, double a0, double b0, double x0, double eps, boolean log_p, boolean do_swap) {
        w[0] = Utils.bpser(a0, b0, x0, eps, log_p);
        w1[0] = log_p ? SignRank.R_Log1_Exp(w[0], true, log_p) : 0.5 - w[0] + 0.5;
        Utils.L_end_after_log(w, w1, do_swap);
    }

    public static void L110(double[] w, double[] w1, double a0, double b0, double y0, double eps, boolean log_p, boolean do_swap) {
        w1[0] = Utils.bpser(b0, a0, y0, eps, log_p);
        w[0] = log_p ? SignRank.R_Log1_Exp(w1[0], true, log_p) : 0.5 - w1[0] + 0.5;
        Utils.L_end_after_log(w, w1, do_swap);
    }

    public static void L120(double[] w, double[] w1, double a0, double b0, double x0, double y0, double lambda, double eps, boolean log_p, boolean do_swap) {
        w[0] = Utils.bfrac(a0, b0, x0, y0, lambda, eps * 15.0, log_p);
        w1[0] = log_p ? SignRank.R_Log1_Exp(w[0], true, log_p) : 0.5 - w[0] + 0.5;
        Utils.L_end_after_log(w, w1, do_swap);
    }

    public static void L131(double[] w, double[] w1, double a0, double b0, double x0, double y0, double eps, int[] ierr1, boolean log_p) {
        Utils.bgrat(b0, a0, y0, x0, w1, 15.0 * eps, ierr1);
        Utils.L_end_from_w1(w, w1, log_p);
    }

    public static void L140(double[] w, double[] w1, int[] ierr1, double a0, double b0, double x0, double y0, double eps, boolean log_p, boolean do_swap) {
        int n;
        if ((b0 -= (double)(n = (int)b0)) == 0.0) {
            --n;
            b0 = 1.0;
        }
        w[0] = Utils.bup(b0, a0, y0, x0, n, eps);
        if (w[0] < Double.MIN_VALUE && log_p) {
            Utils.L100(w, w1, a0, b0 += (double)n, x0, eps, log_p, do_swap);
            return;
        }
        if (x0 <= 0.7) {
            w[0] = w[0] + Utils.bpser(a0, b0, x0, eps, false);
            Utils.L_end_from_w(w, w1, log_p, do_swap);
        }
        if (a0 <= 15.0) {
            n = 20;
            w[0] = w[0] + Utils.bup(a0, b0, x0, y0, n, eps);
            a0 += (double)n;
        }
        Utils.bgrat(a0, b0, x0, y0, w, 15.0 * eps, ierr1);
        Utils.L_end_from_w(w, w1, log_p, do_swap);
    }

    public static void L200(int[] ierr, double a) {
        if (a == 0.0) {
            ierr[0] = 6;
        }
    }

    public static void L201(double[] w, double[] w1, boolean log_p) {
        w[0] = SignRank.R_D__0(true, log_p);
        w1[0] = SignRank.R_D__1(true, log_p);
    }

    public static void L210(int[] ierr, double b) {
        if (b == 0.0) {
            ierr[0] = 7;
        }
    }

    public static void L211(double[] w, double[] w1, boolean log_p) {
        w[0] = SignRank.R_D__1(true, log_p);
        w1[0] = SignRank.R_D__0(true, log_p);
    }

    public static void L_end_from_w(double[] w, double[] w1, boolean log_p, boolean do_swap) {
        if (log_p) {
            w1[0] = Math.log1p(-w[0]);
            w[0] = Math.log(w[0]);
        } else {
            w1[0] = 0.5 - w[0] + 0.5;
        }
        Utils.L_end_after_log(w, w1, do_swap);
    }

    public static void L_end_from_w1(double[] w, double[] w1, boolean log_p) {
        if (log_p) {
            w[0] = Math.log1p(-w1[0]);
            w1[0] = Math.log(w1[0]);
        } else {
            w[0] = 0.5 - w1[0] + 0.5;
        }
        Utils.L_end_after_log(w, w1, log_p);
    }

    public static void L_end_after_log(double[] w, double[] w1, boolean do_swap) {
        if (do_swap) {
            double t2 = w[0];
            w[0] = w1[0];
            w1[0] = t2;
        }
    }

    public static double algdiv(double a, double b) {
        double d;
        double x;
        double c2;
        double c0 = 0.0833333333333333;
        double c1 = -0.00277777777760991;
        double c22 = 7.9365066682539E-4;
        double c3 = -5.9520293135187E-4;
        double c4 = 8.37308034031215E-4;
        double c5 = -0.00165322962780713;
        if (a > b) {
            double h = b / a;
            c2 = 1.0 / (h + 1.0);
            x = h / (h + 1.0);
            d = a + (b - 0.5);
        } else {
            double h = a / b;
            c2 = h / (h + 1.0);
            x = 1.0 / (h + 1.0);
            d = b + (a - 0.5);
        }
        double x2 = x * x;
        double s3 = x + x2 + 1.0;
        double s5 = x + x2 * s3 + 1.0;
        double s7 = x + x2 * s5 + 1.0;
        double s9 = x + x2 * s7 + 1.0;
        double s11 = x + x2 * s9 + 1.0;
        double t2 = 1.0 / (b * b);
        double w = ((((-0.00165322962780713 * s11 * t2 + 8.37308034031215E-4 * s9) * t2 + -5.9520293135187E-4 * s7) * t2 + 7.9365066682539E-4 * s5) * t2 + -0.00277777777760991 * s3) * t2 + 0.0833333333333333;
        w *= c2 / b;
        double u = d * Utils.alnrel(a / b);
        double v = a * (Math.log(b) - 1.0);
        if (u > v) {
            return w - v - u;
        }
        return w - u - v;
    }

    public static double gam1(double a) {
        double t2 = a;
        double d = a - 0.5;
        if (d > 0.0) {
            t2 = d - 0.5;
        }
        if (t2 < 0.0) {
            double[] r = new double[]{-0.422784335098468, -0.771330383816272, -0.244757765222226, 0.118378989872749, 9.30357293360349E-4, -0.0118290993445146, 0.00223047661158249, 2.66505979058923E-4, -1.32674909766242E-4};
            double s1 = 0.273076135303957;
            double s2 = 0.0559398236957378;
            double top = (((((((r[8] * t2 + r[7]) * t2 + r[6]) * t2 + r[5]) * t2 + r[4]) * t2 + r[3]) * t2 + r[2]) * t2 + r[1]) * t2 + r[0];
            double bot = (s2 * t2 + s1) * t2 + 1.0;
            double w = top / bot;
            if (d > 0.0) {
                return t2 * w / a;
            }
            return a * (w + 0.5 + 0.5);
        }
        if (t2 == 0.0) {
            return 0.0;
        }
        double[] p = new double[]{0.577215664901533, -0.409078193005776, -0.230975380857675, 0.0597275330452234, 0.0076696818164949, -0.00514889771323592, 5.89597428611429E-4};
        double[] q = new double[]{1.0, 0.427569613095214, 0.158451672430138, 0.0261132021441447, 0.00423244297896961};
        double top = (((((p[6] * t2 + p[5]) * t2 + p[4]) * t2 + p[3]) * t2 + p[2]) * t2 + p[1]) * t2 + p[0];
        double bot = (((q[4] * t2 + q[3]) * t2 + q[2]) * t2 + q[1]) * t2 + 1.0;
        double w = top / bot;
        if (d > 0.0) {
            return t2 / a * (w - 0.5 - 0.5);
        }
        return a * w;
    }

    static double gamln1(double a) {
        if (a < 0.6) {
            double p0 = 0.577215664901533;
            double p1 = 0.844203922187225;
            double p2 = -0.168860593646662;
            double p3 = -0.780427615533591;
            double p4 = -0.402055799310489;
            double p5 = -0.0673562214325671;
            double p6 = -0.00271935708322958;
            double q1 = 2.88743195473681;
            double q2 = 3.12755088914843;
            double q3 = 1.56875193295039;
            double q4 = 0.361951990101499;
            double q5 = 0.0325038868253937;
            double q6 = 6.67465618796164E-4;
            double w = ((((((-0.00271935708322958 * a + -0.0673562214325671) * a + -0.402055799310489) * a + -0.780427615533591) * a + -0.168860593646662) * a + 0.844203922187225) * a + 0.577215664901533) / ((((((6.67465618796164E-4 * a + 0.0325038868253937) * a + 0.361951990101499) * a + 1.56875193295039) * a + 3.12755088914843) * a + 2.88743195473681) * a + 1.0);
            return -a * w;
        }
        double r0 = 0.422784335098467;
        double r1 = 0.848044614534529;
        double r2 = 0.565221050691933;
        double r3 = 0.156513060486551;
        double r4 = 0.017050248402265;
        double r5 = 4.97958207639485E-4;
        double s1 = 1.24313399877507;
        double s2 = 0.548042109832463;
        double s3 = 0.10155218743983;
        double s4 = 0.00713309612391;
        double s5 = 1.16165475989616E-4;
        double x = a - 0.5 - 0.5;
        double w = (((((4.97958207639485E-4 * x + 0.017050248402265) * x + 0.156513060486551) * x + 0.565221050691933) * x + 0.848044614534529) * x + 0.422784335098467) / (((((1.16165475989616E-4 * x + 0.00713309612391) * x + 0.10155218743983) * x + 0.548042109832463) * x + 1.24313399877507) * x + 1.0);
        return x * w;
    }

    public static double alnrel(double a) {
        double p1 = -1.29418923021993;
        double p2 = 0.405303492862024;
        double p3 = -0.0178874546012214;
        double q1 = -1.62752256355323;
        double q2 = 0.747811014037616;
        double q3 = -0.0845104217945565;
        if (Math.abs(a) <= 0.375) {
            double t2 = a / (a + 2.0);
            double t22 = t2 * t2;
            double w = (((-0.0178874546012214 * t22 + 0.405303492862024) * t22 + -1.29418923021993) * t22 + 1.0) / (((-0.0845104217945565 * t22 + 0.747811014037616) * t22 + -1.62752256355323) * t22 + 1.0);
            return t2 * 2.0 * w;
        }
        double x = a + 1.0;
        return Math.log(x);
    }

    public static void bgrat(double a, double b, double x, double y, double[] w, double eps, int[] ierr) {
        double j;
        double[] c2 = new double[30];
        double[] d = new double[30];
        double[] p = new double[1];
        double[] q = new double[1];
        double bm1 = b - 0.5 - 0.5;
        double nu = a + bm1 * 0.5;
        double lnx = y > 0.375 ? Math.log(x) : Utils.alnrel(-y);
        double z = -nu * lnx;
        if (b * z == 0.0) {
            ierr[0] = 1;
            return;
        }
        double r = b * (Utils.gam1(b) + 1.0) * Math.exp(b * Math.log(z));
        r = r * Math.exp(a * lnx) * Math.exp(bm1 * 0.5 * lnx);
        double u = Utils.algdiv(b, a) + b * Math.log(nu);
        if ((u = r * Math.exp(-u)) == 0.0) {
            ierr[0] = 1;
            return;
        }
        Utils.grat1(b, z, r, p, q, eps);
        double v = 0.25 / (nu * nu);
        double t2 = lnx * 0.25 * lnx;
        double l = w[0] / u;
        double sum2 = j = q[0] / r;
        double t3 = 1.0;
        double cn = 1.0;
        double n2 = 0.0;
        for (int n = 1; n <= 30; ++n) {
            double bp2n = b + n2;
            j = (bp2n * (bp2n + 1.0) * j + (z + bp2n + 1.0) * t3) * v;
            t3 *= t2;
            int nm1 = n - 1;
            c2[nm1] = cn /= (n2 += 2.0) * (n2 + 1.0);
            double s = 0.0;
            if (n > 1) {
                double coef = b - (double)n;
                for (int i = 1; i <= nm1; ++i) {
                    s += coef * c2[i - 1] * d[nm1 - i];
                    coef += b;
                }
            }
            d[nm1] = bm1 * cn + s / (double)n;
            double dj = d[nm1] * j;
            if ((sum2 += dj) <= 0.0) {
                ierr[0] = 1;
                return;
            }
            if (Math.abs(dj) <= eps * (sum2 + l)) break;
        }
        ierr[0] = 0;
        w[0] = w[0] + u * sum2;
    }

    public static double erf__(double x) {
        double c2 = 0.564189583547756;
        double[] a = new double[]{7.7105849500132E-5, -0.00133733772997339, 0.0323076579225834, 0.0479137145607681, 0.128379167095513};
        double[] b = new double[]{0.00301048631703895, 0.0538971687740286, 0.375795757275549};
        double[] p = new double[]{-1.36864857382717E-7, 0.564195517478974, 7.21175825088309, 43.1622272220567, 152.98928504694, 339.320816734344, 451.918953711873, 300.459261020162};
        double[] q = new double[]{1.0, 12.7827273196294, 77.0001529352295, 277.585444743988, 638.980264465631, 931.35409485061, 790.950925327898, 300.459260956983};
        double[] r = new double[]{2.10144126479064, 26.2370141675169, 21.3688200555087, 4.6580782871847, 0.282094791773523};
        double[] s = new double[]{94.153775055546, 187.11481179959, 99.0191814623914, 18.0124575948747};
        double ax = Math.abs(x);
        if (ax <= 0.5) {
            double t2 = x * x;
            double top = (((a[0] * t2 + a[1]) * t2 + a[2]) * t2 + a[3]) * t2 + a[4] + 1.0;
            double bot = ((b[0] * t2 + b[1]) * t2 + b[2]) * t2 + 1.0;
            return x * (top / bot);
        }
        if (ax <= 4.0) {
            double top = ((((((p[0] * ax + p[1]) * ax + p[2]) * ax + p[3]) * ax + p[4]) * ax + p[5]) * ax + p[6]) * ax + p[7];
            double bot = ((((((q[0] * ax + q[1]) * ax + q[2]) * ax + q[3]) * ax + q[4]) * ax + q[5]) * ax + q[6]) * ax + q[7];
            double ret_val = 0.5 - Math.exp(-x * x) * top / bot + 0.5;
            if (x < 0.0) {
                ret_val = -ret_val;
            }
            return ret_val;
        }
        if (ax >= 5.8) {
            return x > 0.0 ? 1.0 : -1.0;
        }
        double x2 = x * x;
        double t3 = 1.0 / x2;
        double top = (((r[0] * t3 + r[1]) * t3 + r[2]) * t3 + r[3]) * t3 + r[4];
        double bot = (((s[0] * t3 + s[1]) * t3 + s[2]) * t3 + s[3]) * t3 + 1.0;
        t3 = (0.564189583547756 - top / (x2 * bot)) / ax;
        double ret_val = 0.5 - Math.exp(-x2) * t3 + 0.5;
        if (x < 0.0) {
            ret_val = -ret_val;
        }
        return ret_val;
    }

    public static double rexpm1(double x) {
        double p1 = 9.14041914819518E-10;
        double p2 = 0.0238082361044469;
        double q1 = -0.499999999085958;
        double q2 = 0.107141568980644;
        double q3 = -0.0119041179760821;
        double q4 = 5.95130811860248E-4;
        if (Math.abs(x) <= 0.15) {
            return x * (((0.0238082361044469 * x + 9.14041914819518E-10) * x + 1.0) / ((((5.95130811860248E-4 * x + -0.0119041179760821) * x + 0.107141568980644) * x + -0.499999999085958) * x + 1.0));
        }
        double w = Math.exp(x);
        if (x > 0.0) {
            return w * (0.5 - 1.0 / w + 0.5);
        }
        return w - 0.5 - 0.5;
    }

    public static void grat1(double a, double x, double r, double[] p, double[] q, double eps) {
        double am0;
        double cma;
        double an0;
        if (a * x == 0.0) {
            if (x <= a) {
                p[0] = 0.0;
                q[0] = 1.0;
                return;
            }
            p[0] = 1.0;
            q[0] = 0.0;
            return;
        }
        if (a == 0.5) {
            if (x < 0.25) {
                p[0] = Utils.erf__(Math.sqrt(x));
                q[0] = 0.5 - p[0] + 0.5;
            } else {
                q[0] = Utils.erfc1(0, Math.sqrt(x));
                p[0] = 0.5 - q[0] + 0.5;
            }
            return;
        }
        if (x < 1.1) {
            double t2;
            double an = 3.0;
            double c2 = x;
            double sum2 = x / (a + 3.0);
            double tol = eps * 0.1 / (a + 1.0);
            do {
                c2 = -c2 * (x / (an += 1.0));
                t2 = c2 / (a + an);
                sum2 += t2;
            } while (Math.abs(t2) > tol);
            double j = a * x * ((sum2 / 6.0 - 0.5 / (a + 2.0)) * x + 1.0 / (a + 1.0));
            double z = a * Math.log(x);
            double h = Utils.gam1(a);
            double g = h + 1.0;
            if (x >= 0.25) {
                if (a < x / 2.59) {
                    double l = Utils.rexpm1(z);
                    double w = l + 0.5 + 0.5;
                    q[0] = (w * j - l) * g - h;
                    if (q[0] < 0.0) {
                        p[0] = 1.0;
                        q[0] = 0.0;
                        return;
                    }
                    p[0] = 0.5 - q[0] + 0.5;
                    return;
                }
            } else if (z > -0.13394) {
                double l = Utils.rexpm1(z);
                double w = l + 0.5 + 0.5;
                q[0] = (w * j - l) * g - h;
                if (q[0] < 0.0) {
                    p[0] = 1.0;
                    q[0] = 0.0;
                    return;
                }
                p[0] = 0.5 - q[0] + 0.5;
                return;
            }
            double w = Math.exp(z);
            p[0] = w * g * (0.5 - j + 0.5);
            q[0] = 0.5 - p[0] + 0.5;
            return;
        }
        double a2nm1 = 1.0;
        double a2n = 1.0;
        double b2nm1 = x;
        double b2n = x + (1.0 - a);
        double c3 = 1.0;
        while (Math.abs((an0 = (a2n = (a2nm1 = x * a2n + c3 * a2nm1) + (cma = (c3 += 1.0) - a) * a2n) / (b2n = (b2nm1 = x * b2n + c3 * b2nm1) + cma * b2n)) - (am0 = a2nm1 / b2nm1)) >= eps * an0) {
        }
        q[0] = r * an0;
        p[0] = 0.5 - q[0] + 0.5;
    }

    public static double brcomp(double a, double b, double x, double y, boolean log_p) {
        double t2;
        double lny;
        double lnx;
        double const__ = 0.398942280401433;
        if (x == 0.0 || y == 0.0) {
            return SignRank.R_D__0(true, log_p);
        }
        double a0 = Math.min(a, b);
        if (a0 >= 8.0) {
            double lambda;
            double y0;
            double x0;
            if (a <= b) {
                double h = a / b;
                x0 = h / (h + 1.0);
                y0 = 1.0 / (h + 1.0);
                lambda = a - (a + b) * x;
            } else {
                double h = b / a;
                x0 = 1.0 / (h + 1.0);
                y0 = h / (h + 1.0);
                lambda = (a + b) * y - b;
            }
            double e = -lambda / a;
            double u = Math.abs(e) > 0.6 ? e - Math.log(x / x0) : Utils.rlog1(e);
            e = lambda / b;
            double v = Math.abs(e) <= 0.6 ? Utils.rlog1(e) : e - Math.log(y / y0);
            double z = log_p ? -(a * u + b * v) : Math.exp(-(a * u + b * v));
            return log_p ? -Math.log(Math.sqrt(Math.PI * 2)) + 0.5 * Math.log(b * x0) + z - Utils.bcorr(a, b) : 0.398942280401433 * Math.sqrt(b * x0) * z * Math.exp(-Utils.bcorr(a, b));
        }
        if (x <= 0.375) {
            lnx = Math.log(x);
            lny = Utils.alnrel(-x);
        } else if (y > 0.375) {
            lnx = Math.log(x);
            lny = Math.log(y);
        } else {
            lnx = Utils.alnrel(-y);
            lny = Math.log(y);
        }
        double z = a * lnx + b * lny;
        if (a0 >= 1.0) {
            return SignRank.R_D_exp(z -= Beta.logBeta((double)a, (double)b), true, log_p);
        }
        double b0 = Math.max(a, b);
        if (b0 >= 8.0) {
            double u = Utils.gamln1(a0) + Utils.algdiv(a0, b0);
            return log_p ? Math.log(a0) + (z - u) : a0 * Math.exp(z - u);
        }
        if (b0 <= 1.0) {
            double e_z = SignRank.R_D_exp(z, true, log_p);
            if (!log_p && e_z == 0.0) {
                return 0.0;
            }
            double apb = a + b;
            if (apb > 1.0) {
                double u = a + b - 1.0;
                z = (Utils.gam1(u) + 1.0) / apb;
            } else {
                z = Utils.gam1(apb) + 1.0;
            }
            double c2 = (Utils.gam1(a) + 1.0) * (Utils.gam1(b) + 1.0) / z;
            return log_p ? e_z + Math.log(a0 * c2) - Math.log1p(a0 / b0) : e_z * (a0 * c2) / (a0 / b0 + 1.0);
        }
        double u = Utils.gamln1(a0);
        int n = (int)(b0 - 1.0);
        if (n >= 1) {
            double c3 = 1.0;
            for (int i = 1; i <= n; ++i) {
                c3 *= (b0 += -1.0) / (a0 + b0);
            }
            u = Math.log(c3) + u;
        }
        z -= u;
        double apb = a0 + (b0 += -1.0);
        if (apb > 1.0) {
            u = a0 + b0 - 1.0;
            t2 = (Utils.gam1(u) + 1.0) / apb;
        } else {
            t2 = Utils.gam1(apb) + 1.0;
        }
        return log_p ? Math.log(a0) + z + Math.log1p(Utils.gam1(b0)) - Math.log(t2) : a0 * Math.exp(z) * (Utils.gam1(b0) + 1.0) / t2;
    }

    public static double bfrac(double a, double b, double x, double y, double lambda, double eps, boolean log_p) {
        double brc = Utils.brcomp(a, b, x, y, log_p);
        if (!log_p && brc == 0.0) {
            return 0.0;
        }
        double c2 = lambda + 1.0;
        double c0 = b / a;
        double c1 = 1.0 / a + 1.0;
        double yp1 = y + 1.0;
        double n = 0.0;
        double p = 1.0;
        double s = a + 1.0;
        double an = 0.0;
        double bn = 1.0;
        double anp1 = 1.0;
        double bnp1 = c2 / c1;
        double r = c1 / c2;
        while (true) {
            double t2 = (n += 1.0) / a;
            double w = n * (b - n) * x;
            double e = a / s;
            double alpha = p * (p + c0) * e * e * (w * x);
            e = (t2 + 1.0) / (c1 + t2 + t2);
            double beta2 = n + w / s + e * (c2 + n * yp1);
            p = t2 + 1.0;
            s += 2.0;
            t2 = alpha * an + beta2 * anp1;
            an = anp1;
            anp1 = t2;
            t2 = alpha * bn + beta2 * bnp1;
            bn = bnp1;
            bnp1 = t2;
            r = anp1 / bnp1;
            double r0 = r;
            if (Math.abs(r - r0) <= eps * r) break;
            an /= bnp1;
            bn /= bnp1;
            anp1 = r;
            bnp1 = 1.0;
        }
        return log_p ? brc + Math.log(r) : brc * r;
    }

    public static double bpser(double a, double b, double x, double eps, boolean log_p) {
        double w;
        double c2;
        double ans;
        double z;
        if (x == 0.0) {
            return SignRank.R_D__0(true, log_p);
        }
        double a0 = Math.min(a, b);
        if (a0 >= 1.0) {
            z = a * Math.log(x) - Beta.logBeta((double)a, (double)b);
            ans = log_p ? z - Math.log(a) : Math.exp(z) / a;
        } else {
            double u;
            double b0 = Math.max(a, b);
            if (b0 < 8.0) {
                double apb;
                if (b0 <= 1.0) {
                    if (log_p) {
                        ans = a * Math.log(x);
                    } else {
                        ans = Math.pow(x, a);
                        if (ans == 0.0) {
                            return ans;
                        }
                    }
                    apb = a + b;
                    if (apb > 1.0) {
                        u = a + b - 1.0;
                        z = (Utils.gam1(u) + 1.0) / apb;
                    } else {
                        z = Utils.gam1(apb) + 1.0;
                    }
                    c2 = (Utils.gam1(a) + 1.0) * (Utils.gam1(b) + 1.0) / z;
                    ans = log_p ? (ans += Math.log(c2 * (b / apb))) : (ans *= c2 * (b / apb));
                } else {
                    double t2;
                    u = Utils.gamln1(a0);
                    int m = (int)(b0 - 1.0);
                    if (m >= 1) {
                        c2 = 1.0;
                        for (int i = 1; i <= m; ++i) {
                            c2 *= (b0 += -1.0) / (a0 + b0);
                        }
                        u += Math.log(c2);
                    }
                    z = a * Math.log(x) - u;
                    apb = a0 + (b0 += -1.0);
                    if (apb > 1.0) {
                        u = a0 + b0 - 1.0;
                        t2 = (Utils.gam1(u) + 1.0) / apb;
                    } else {
                        t2 = Utils.gam1(apb) + 1.0;
                    }
                    ans = log_p ? z + Math.log(a0 / a) + Math.log1p(Utils.gam1(b0)) - Math.log(t2) : Math.exp(z) * (a0 / a) * (Utils.gam1(b0) + 1.0) / t2;
                }
            } else {
                u = Utils.gamln1(a0) + Utils.algdiv(a0, b0);
                z = a * Math.log(x) - u;
                ans = log_p ? z + Math.log(a0 / a) : a0 / a * Math.exp(z);
            }
        }
        if (!log_p && (ans == 0.0 || a <= eps * 0.1)) {
            return ans;
        }
        double sum2 = 0.0;
        double n = 0.0;
        c2 = 1.0;
        double tol = eps / a;
        do {
            w = (c2 *= (0.5 - b / (n += 1.0) + 0.5) * x) / (a + n);
            sum2 += w;
        } while (Math.abs(w) > tol);
        ans = log_p ? (ans += Math.log1p(a * sum2)) : (ans *= a * sum2 + 1.0);
        return ans;
    }

    public static double bcorr(double a0, double b0) {
        double c0 = 0.0833333333333333;
        double c1 = -0.00277777777760991;
        double c2 = 7.9365066682539E-4;
        double c3 = -5.9520293135187E-4;
        double c4 = 8.37308034031215E-4;
        double c5 = -0.00165322962780713;
        double a = Math.min(a0, b0);
        double b = Math.max(a0, b0);
        double h = a / b;
        double c6 = h / (h + 1.0);
        double x = 1.0 / (h + 1.0);
        double x2 = x * x;
        double s3 = x + x2 + 1.0;
        double s5 = x + x2 * s3 + 1.0;
        double s7 = x + x2 * s5 + 1.0;
        double s9 = x + x2 * s7 + 1.0;
        double s11 = x + x2 * s9 + 1.0;
        double r1 = 1.0 / b;
        double t2 = r1 * r1;
        double w = ((((-0.00165322962780713 * s11 * t2 + 8.37308034031215E-4 * s9) * t2 + -5.9520293135187E-4 * s7) * t2 + 7.9365066682539E-4 * s5) * t2 + -0.00277777777760991 * s3) * t2 + 0.0833333333333333;
        r1 = 1.0 / a;
        t2 = r1 * r1;
        double ret_val = (((((-0.00165322962780713 * t2 + 8.37308034031215E-4) * t2 + -5.9520293135187E-4) * t2 + 7.9365066682539E-4) * t2 + -0.00277777777760991) * t2 + 0.0833333333333333) / a + (w *= c6 / b);
        return ret_val;
    }

    public static double exparg(int l) {
        double lnb = 0.69314718055995;
        if (l == 0) {
            int m = 1023;
            return (double)m * 0.69314718055995 * 0.99999;
        }
        int m = -1022;
        return (double)m * 0.69314718055995 * 0.99999;
    }

    public static double fpser(double a, double b, double x, double eps, boolean log_p) {
        double c2;
        double t2;
        double ans;
        if (log_p) {
            ans = a * Math.log(x);
        } else if (a > eps * 0.001) {
            t2 = a * Math.log(x);
            if (t2 < Utils.exparg(1)) {
                return 0.0;
            }
            ans = Math.exp(t2);
        } else {
            ans = 1.0;
        }
        ans = log_p ? (ans += Math.log(b) - Math.log(a)) : (ans *= b / a);
        double tol = eps / a;
        double an = a + 1.0;
        t2 = x;
        double s = t2 / an;
        do {
            t2 = x * t2;
            c2 = t2 / (an += 1.0);
            s += c2;
        } while (Math.abs(c2) > tol);
        ans = log_p ? (ans += Math.log1p(a * s)) : (ans *= a * s + 1.0);
        return ans;
    }

    public static double psi(double x) {
        double w;
        double piov4 = 0.785398163397448;
        double dx0 = 1.4616321449683622;
        double[] p1 = new double[]{0.0089538502298197, 4.77762828042627, 142.441585084029, 1186.45200713425, 3633.51846806499, 4138.10161269013, 1305.60269827897};
        double[] q1 = new double[]{44.8452573429826, 520.752771467162, 2210.0079924783, 3641.27349079381, 1908.310765963, 6.91091682714533E-6};
        double[] p2 = new double[]{-2.12940445131011, -7.01677227766759, -4.48616543918019, -0.648157123766197};
        double[] q2 = new double[]{32.2703493791143, 89.2920700481861, 54.6117738103215, 7.77788548522962};
        double xmax1 = 2.147483647E9;
        double d2 = 0.5 / Utils.Rf_d1mach(3);
        if (xmax1 > d2) {
            xmax1 = d2;
        }
        double xsmall = 1.0E-9;
        double aug = 0.0;
        if (x < 0.5) {
            if (Math.abs(x) <= xsmall) {
                if (x == 0.0) {
                    return 0.0;
                }
                aug = -1.0 / x;
            } else {
                w = -x;
                double sgn = 0.785398163397448;
                if (w <= 0.0) {
                    w = -w;
                    sgn = -sgn;
                }
                if (w >= xmax1) {
                    return 0.0;
                }
                int nq = (int)w;
                w -= (double)nq;
                nq = (int)(w * 4.0);
                w = (w - (double)nq * 0.25) * 4.0;
                int n = nq / 2;
                if (n + n != nq) {
                    w = 1.0 - w;
                }
                double z = 0.785398163397448 * w;
                int m = n / 2;
                if (m + m != n) {
                    sgn = -sgn;
                }
                n = (nq + 1) / 2;
                m = n / 2;
                if ((m += m) == n) {
                    if (z == 0.0) {
                        return 0.0;
                    }
                    aug = sgn * (Math.cos(z) / Math.sin(z) * 4.0);
                } else {
                    aug = sgn * (Math.sin(z) / Math.cos(z) * 4.0);
                }
            }
            x = 1.0 - x;
        }
        if (x <= 3.0) {
            double den = x;
            double upper = p1[0] * x;
            for (int i = 1; i <= 5; ++i) {
                den = (den + q1[i - 1]) * x;
                upper = (upper + p1[i]) * x;
            }
            den = (upper + p1[6]) / (den + q1[5]);
            double xmx0 = x - 1.4616321449683622;
            return den * xmx0 + aug;
        }
        if (x < xmax1) {
            double den = w = 1.0 / (x * x);
            double upper = p2[0] * w;
            for (int i = 1; i <= 3; ++i) {
                den = (den + q2[i - 1]) * w;
                upper = (upper + p2[i]) * w;
            }
            aug = upper / (den + q2[3]) - 0.5 / x + aug;
        }
        return aug + Math.log(x);
    }

    static double apser(double a, double b, double x, double eps) {
        double aj;
        double g = 0.577215664901533;
        double bx = b * x;
        double t2 = x - bx;
        double c2 = b * eps <= 0.02 ? Math.log(x) + Utils.psi(b) + 0.577215664901533 + t2 : Math.log(bx) + 0.577215664901533 + t2;
        double tol = eps * 5.0 * Math.abs(c2);
        double j = 1.0;
        double s = 0.0;
        do {
            aj = (t2 *= x - bx / (j += 1.0)) / j;
            s += aj;
        } while (Math.abs(aj) > tol);
        return -a * (c2 + s);
    }

    public static double esum(int mu, double x) {
        double w;
        if (x > 0.0) {
            if (mu > 0) {
                double w2 = mu;
                return Math.exp(w2) * Math.exp(x);
            }
            w = (double)mu + x;
            if (w < 0.0) {
                w = mu;
                return Math.exp(w) * Math.exp(x);
            }
        } else {
            if (mu < 0) {
                double w3 = mu;
                return Math.exp(w3) * Math.exp(x);
            }
            w = (double)mu + x;
            if (w > 0.0) {
                w = mu;
                return Math.exp(w) * Math.exp(x);
            }
        }
        return Math.exp(w);
    }

    public static double brcmp1(int mu, double a, double b, double x, double y) {
        return Math.exp(mu) * (Math.pow(x, a) * Math.pow(y, b) / MathExt.beta(a, b));
    }

    public static double bup(double a, double b, double x, double y, int n, double eps) {
        double l;
        int i;
        double d;
        double t2;
        int k;
        int mu;
        double apb = a + b;
        double ap1 = a + 1.0;
        if (n > 1 && a >= 1.0 && apb >= ap1 * 1.1) {
            mu = (int)Math.abs(Utils.exparg(1));
            k = (int)Utils.exparg(0);
            if (k < mu) {
                mu = k;
            }
            t2 = mu;
            d = Math.exp(-t2);
        } else {
            mu = 0;
            d = 1.0;
        }
        double ret_val = Utils.brcmp1(mu, a, b, x, y) / a;
        if (n == 1 || ret_val == 0.0) {
            return ret_val;
        }
        int nm1 = n - 1;
        double w = d;
        k = 0;
        if (b <= 1.0) {
            double l2;
            for (int i2 = k + 1; i2 <= nm1 && !((d = (apb + (l2 = (double)(i2 - 1))) / (ap1 + l2) * x * d) <= eps * (w += d)); ++i2) {
            }
            return ret_val *= w;
        }
        if (y > 1.0E-4) {
            double r = (b - 1.0) * x / y - a;
            if (r < 1.0) {
                double l3;
                for (int i3 = k + 1; i3 <= nm1 && !((d = (apb + (l3 = (double)(i3 - 1))) / (ap1 + l3) * x * d) <= eps * (w += d)); ++i3) {
                }
                return ret_val *= w;
            }
            k = nm1;
            t2 = nm1;
            if (r < t2) {
                k = (int)r;
            }
        } else {
            k = nm1;
        }
        for (i = 1; i <= k; ++i) {
            l = i - 1;
            d = (apb + l) / (ap1 + l) * x * d;
            w += d;
        }
        if (k == nm1) {
            return ret_val *= w;
        }
        for (i = k + 1; i <= nm1 && !((d = (apb + (l = (double)(i - 1))) / (ap1 + l) * x * d) <= eps * (w += d)); ++i) {
        }
        return ret_val *= w;
    }

    public static double rlog1(double x) {
        double w1;
        double h;
        double a = 0.0566749439387324;
        double b = 0.0456512608815524;
        double p0 = 0.333333333333333;
        double p1 = -0.224696413112536;
        double p2 = 0.00620886815375787;
        double q1 = -1.27408923933623;
        double q2 = 0.354508718369557;
        if (x < -0.39 || x > 0.57) {
            double w = x + 0.5 + 0.5;
            return x - Math.log(w);
        }
        if (x < -0.18) {
            h = x + 0.3;
            w1 = 0.0566749439387324 - (h /= 0.7) * 0.3;
        } else if (x > 0.18) {
            h = x * 0.75 - 0.25;
            w1 = 0.0456512608815524 + h / 3.0;
        } else {
            h = x;
            w1 = 0.0;
        }
        double r = h / (h + 2.0);
        double t2 = r * r;
        double w = ((0.00620886815375787 * t2 + -0.224696413112536) * t2 + 0.333333333333333) / ((0.354508718369557 * t2 + -1.27408923933623) * t2 + 1.0);
        return t2 * 2.0 * (1.0 / (1.0 - r) - r * w) + w1;
    }

    public static double erfc1(int ind, double x) {
        double c2 = 0.564189583547756;
        double[] a = new double[]{7.7105849500132E-5, -0.00133733772997339, 0.0323076579225834, 0.0479137145607681, 0.128379167095513};
        double[] b = new double[]{0.00301048631703895, 0.0538971687740286, 0.375795757275549};
        double[] p = new double[]{-1.36864857382717E-7, 0.564195517478974, 7.21175825088309, 43.1622272220567, 152.98928504694, 339.320816734344, 451.918953711873, 300.459261020162};
        double[] q = new double[]{1.0, 12.7827273196294, 77.0001529352295, 277.585444743988, 638.980264465631, 931.35409485061, 790.950925327898, 300.459260956983};
        double[] r = new double[]{2.10144126479064, 26.2370141675169, 21.3688200555087, 4.6580782871847, 0.282094791773523};
        double[] s = new double[]{94.153775055546, 187.11481179959, 99.0191814623914, 18.0124575948747};
        double ax = Math.abs(x);
        if (ax > 0.5) {
            if (ax > 4.0) {
                if (x <= -5.6) {
                    double ret_val = 2.0;
                    if (ind != 0) {
                        ret_val = Math.exp(x * x) * 2.0;
                    }
                    return ret_val;
                }
                if (ind != 0) {
                    double d1 = 1.0 / x;
                    double t2 = d1 * d1;
                    double top = (((r[0] * t2 + r[1]) * t2 + r[2]) * t2 + r[3]) * t2 + r[4];
                    double bot = (((s[0] * t2 + s[1]) * t2 + s[2]) * t2 + s[3]) * t2 + 1.0;
                    double ret_val = (0.564189583547756 - t2 * top / bot) / ax;
                    if (ind == 0) {
                        double w;
                        t2 = w = x * x;
                        double e = w - t2;
                        ret_val = (0.5 - e + 0.5) * Math.exp(-t2) * ret_val;
                        if (x < 0.0) {
                            ret_val = 2.0 - ret_val;
                        }
                        return ret_val;
                    }
                    if (x < 0.0) {
                        ret_val = Math.exp(x * x) * 2.0 - ret_val;
                    }
                    return ret_val;
                }
                if (x > 100.0) {
                    double ret_val = 0.0;
                    return ret_val;
                }
                if (x * x > -Utils.exparg(1)) {
                    double ret_val = 0.0;
                    return ret_val;
                }
                double d1 = 1.0 / x;
                double t3 = d1 * d1;
                double top = (((r[0] * t3 + r[1]) * t3 + r[2]) * t3 + r[3]) * t3 + r[4];
                double bot = (((s[0] * t3 + s[1]) * t3 + s[2]) * t3 + s[3]) * t3 + 1.0;
                double ret_val = (0.564189583547756 - t3 * top / bot) / ax;
                if (ind == 0) {
                    double w;
                    t3 = w = x * x;
                    double e = w - t3;
                    ret_val = (0.5 - e + 0.5) * Math.exp(-t3) * ret_val;
                    if (x < 0.0) {
                        ret_val = 2.0 - ret_val;
                    }
                    return ret_val;
                }
                if (x < 0.0) {
                    ret_val = Math.exp(x * x) * 2.0 - ret_val;
                }
                return ret_val;
            }
            double top = ((((((p[0] * ax + p[1]) * ax + p[2]) * ax + p[3]) * ax + p[4]) * ax + p[5]) * ax + p[6]) * ax + p[7];
            double bot = ((((((q[0] * ax + q[1]) * ax + q[2]) * ax + q[3]) * ax + q[4]) * ax + q[5]) * ax + q[6]) * ax + q[7];
            double ret_val = top / bot;
            if (ind == 0) {
                double w;
                double t4 = w = x * x;
                double e = w - t4;
                ret_val = (0.5 - e + 0.5) * Math.exp(-t4) * ret_val;
                if (x < 0.0) {
                    ret_val = 2.0 - ret_val;
                }
                return ret_val;
            }
            if (x < 0.0) {
                ret_val = Math.exp(x * x) * 2.0 - ret_val;
            }
            return ret_val;
        }
        double t5 = x * x;
        double top = (((a[0] * t5 + a[1]) * t5 + a[2]) * t5 + a[3]) * t5 + a[4] + 1.0;
        double bot = ((b[0] * t5 + b[1]) * t5 + b[2]) * t5 + 1.0;
        double ret_val = 0.5 - x * (top / bot) + 0.5;
        if (ind != 0) {
            ret_val = Math.exp(t5) * ret_val;
        }
        return ret_val;
    }

    public static double basym(double a, double b, double lambda, double eps, boolean log_p) {
        double w0;
        double r1;
        double r0;
        double h;
        double t2;
        int num_IT = 20;
        double e0 = 1.12837916709551;
        double e1 = 0.353553390593274;
        double ln_e0 = 0.120782237635245;
        double[] a0 = new double[num_IT + 1];
        double[] b0 = new double[num_IT + 1];
        double[] c2 = new double[num_IT + 1];
        double[] d = new double[num_IT + 1];
        double f = a * Utils.rlog1(-lambda / a) + b * Utils.rlog1(lambda / b);
        if (log_p) {
            t2 = -f;
        } else {
            t2 = Math.exp(-f);
            if (t2 == 0.0) {
                return 0.0;
            }
        }
        double z0 = Math.sqrt(f);
        double z = z0 / 0.353553390593274 * 0.5;
        double z2 = f + f;
        if (a < b) {
            h = a / b;
            r0 = 1.0 / (h + 1.0);
            r1 = (b - a) / b;
            w0 = 1.0 / Math.sqrt(a * (h + 1.0));
        } else {
            h = b / a;
            r0 = 1.0 / (h + 1.0);
            r1 = (b - a) / a;
            w0 = 1.0 / Math.sqrt(b * (h + 1.0));
        }
        a0[0] = r1 * 0.6666666666666666;
        c2[0] = a0[0] * -0.5;
        d[0] = -c2[0];
        double j0 = 0.4431134627263801 * Utils.erfc1(1, z0);
        double j1 = 0.353553390593274;
        double sum2 = j0 + d[0] * w0 * j1;
        double s = 1.0;
        double h2 = h * h;
        double hn = 1.0;
        double w = w0;
        double znm1 = z;
        double zn = z2;
        for (int n = 2; n <= num_IT; n += 2) {
            hn = h2 * hn;
            a0[n - 1] = r0 * 2.0 * (h * hn + 1.0) / ((double)n + 2.0);
            int np1 = n + 1;
            a0[np1 - 1] = r1 * 2.0 * (s += hn) / ((double)n + 3.0);
            for (int i = n; i <= np1; ++i) {
                int j;
                double r = ((double)i + 1.0) * -0.5;
                b0[0] = r * a0[0];
                for (int m = 2; m <= i; ++m) {
                    double bsum = 0.0;
                    int mm1 = m - 1;
                    for (j = 1; j <= mm1; ++j) {
                        int mmj = m - j;
                        bsum += ((double)j * r - (double)mmj) * a0[j - 1] * b0[mmj - 1];
                    }
                    b0[m - 1] = r * a0[m - 1] + bsum / (double)m;
                }
                c2[i - 1] = b0[i - 1] / ((double)i + 1.0);
                double dsum = 0.0;
                int im1 = i - 1;
                for (j = 1; j <= im1; ++j) {
                    int imj = i - j;
                    dsum += d[imj - 1] * c2[j - 1];
                }
                d[i - 1] = -(dsum + c2[i - 1]);
            }
            j0 = 0.353553390593274 * znm1 + ((double)n - 1.0) * j0;
            j1 = 0.353553390593274 * zn + (double)n * j1;
            znm1 = z2 * znm1;
            zn = z2 * zn;
            w = w0 * w;
            double t0 = d[n - 1] * w * j0;
            w = w0 * w;
            double t1 = d[np1 - 1] * w * j1;
            if (Math.abs(t0) + Math.abs(t1) <= eps * (sum2 += t0 + t1)) break;
        }
        if (log_p) {
            return 0.120782237635245 + t2 - Utils.bcorr(a, b) + Math.log(sum2);
        }
        double u = Math.exp(-Utils.bcorr(a, b));
        return 1.12837916709551 * t2 * u * sum2;
    }

    public static void bratio(double a, double b, double x, double y, double[] w, double[] w1, int[] ierr, boolean log_p) {
        double y0;
        double b0;
        double x0;
        double a0;
        boolean do_swap;
        ierr[0] = 0;
        double eps = 2.0 * Utils.Rf_d1mach(3);
        w[0] = SignRank.R_D__0(true, log_p);
        w1[0] = SignRank.R_D__0(true, log_p);
        if (a < 0.0 || b < 0.0) {
            ierr[0] = 1;
            return;
        }
        if (a == 0.0 && b == 0.0) {
            ierr[0] = 2;
            return;
        }
        if (x < 0.0 || x > 1.0) {
            ierr[0] = 3;
            return;
        }
        if (y < 0.0 || y > 1.0) {
            ierr[0] = 4;
            return;
        }
        double z = x + y - 0.5 - 0.5;
        if (Math.abs(z) > eps * 3.0) {
            ierr[0] = 5;
            return;
        }
        ierr[0] = 0;
        if (x == 0.0) {
            Utils.L200(ierr, a);
            w[0] = SignRank.R_D__0(true, log_p);
            w1[0] = SignRank.R_D__1(true, log_p);
            return;
        }
        if (y == 0.0) {
            Utils.L210(ierr, b);
            return;
        }
        if (a == 0.0) {
            Utils.L211(w, w1, log_p);
            return;
        }
        if (b == 0.0) {
            Utils.L201(w, w1, log_p);
            return;
        }
        eps = Math.max(eps, 1.0E-15);
        if (Math.max(a, b) < eps * 0.001) {
            if (log_p) {
                z = Math.log(a + b);
                w[0] = Math.log(b) - z;
                w1[0] = Math.log(a) - z;
            } else {
                w[0] = b / (a + b);
                w1[0] = a / (a + b);
            }
            return;
        }
        if (Math.min(a, b) <= 1.0) {
            double y02;
            double b02;
            double x02;
            double a02;
            boolean do_swap2;
            boolean bl = do_swap2 = x > 0.5;
            if (do_swap2) {
                a02 = b;
                x02 = y;
                b02 = a;
                y02 = x;
            } else {
                a02 = a;
                x02 = x;
                b02 = b;
                y02 = y;
            }
            if (b02 < Math.min(eps, eps * a02)) {
                w[0] = Utils.fpser(a02, b02, x02, eps, log_p);
                w1[0] = log_p ? SignRank.R_Log1_Exp(w[0], true, log_p) : 0.5 - w[0] + 0.5;
                Utils.L_end_after_log(w, w1, do_swap2);
                return;
            }
            if (a02 < Math.min(eps, eps * b02) && b02 * x02 <= 1.0) {
                w1[0] = Utils.apser(a02, b02, x02, eps);
                Utils.L_end_from_w1(w, w1, log_p);
                return;
            }
            if (Math.max(a02, b02) > 1.0) {
                if (b02 <= 1.0) {
                    Utils.L100(w, w1, a02, b02, x02, eps, log_p, do_swap2);
                    return;
                }
                if (x02 >= 0.29) {
                    Utils.L110(w, w1, a02, b02, y02, eps, log_p, do_swap2);
                    return;
                }
                if (x02 < 0.1 && Math.pow(x02 * b02, a02) <= 0.7) {
                    Utils.L100(w, w1, a02, b02, x02, eps, log_p, do_swap2);
                    return;
                }
                if (b02 > 15.0) {
                    w1[0] = 0.0;
                    Utils.L131(w, w1, a02, b02, x02, y02, eps, ierr, log_p);
                    return;
                }
            } else {
                if (a02 >= Math.min(0.2, b02)) {
                    Utils.L100(w, w1, a02, b02, x02, eps, log_p, do_swap2);
                    return;
                }
                if (Math.pow(x02, a02) <= 0.9) {
                    Utils.L100(w, w1, a02, b02, x02, eps, log_p, do_swap2);
                    return;
                }
                if (x02 >= 0.3) {
                    Utils.L110(w, w1, a02, b02, y02, eps, log_p, do_swap2);
                    return;
                }
            }
            int n = 20;
            w1[0] = Utils.bup(b02, a02, y02, x02, n, eps);
            Utils.L131(w, w1, a02, b02 += (double)n, x02, y02, eps, ierr, log_p);
            return;
        }
        double lambda = a > b ? (a + b) * y - b : a - (a + b) * x;
        boolean bl = do_swap = lambda < 0.0;
        if (do_swap) {
            lambda = -lambda;
            a0 = b;
            x0 = y;
            b0 = a;
            y0 = x;
        } else {
            a0 = a;
            x0 = x;
            b0 = b;
            y0 = y;
        }
        if (b0 < 40.0) {
            if (b0 * x0 <= 0.7 || log_p && lambda > 650.0) {
                Utils.L100(w, w1, a0, b0, x0, eps, log_p, do_swap);
                return;
            }
            Utils.L140(w, w1, ierr, a0, b0, x0, y0, eps, log_p, do_swap);
            return;
        }
        if (a0 > b0) {
            if (b0 <= 100.0 || lambda > b0 * 0.03) {
                Utils.L120(w, w1, a0, b0, x0, y0, lambda, eps, log_p, do_swap);
            }
            return;
        }
        if (a0 <= 100.0) {
            Utils.L120(w, w1, a0, b0, x0, y0, lambda, eps, log_p, do_swap);
            return;
        }
        if (lambda > a0 * 0.03) {
            Utils.L120(w, w1, a0, b0, x0, y0, lambda, eps, log_p, do_swap);
            return;
        }
        w[0] = Utils.basym(a0, b0, lambda, eps * 100.0, log_p);
        w1[0] = log_p ? SignRank.R_Log1_Exp(w[0], true, log_p) : 0.5 - w[0] + 0.5;
        Utils.L_end_after_log(w, w1, do_swap);
    }
}

