/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img.converters;

import io.scif.Metadata;
import io.scif.Reader;
import io.scif.config.SCIFIOConfig;
import io.scif.img.ImgUtilityService;
import io.scif.img.converters.AbstractPlaneConverter;
import io.scif.img.converters.PlaneConverter;
import io.scif.util.FormatTools;
import net.imagej.ImgPlus;
import net.imglib2.img.basictypeaccess.PlanarAccess;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.Bytes;

@Plugin(type=PlaneConverter.class, name="PlanarAccess")
public class PlanarAccessConverter
extends AbstractPlaneConverter {
    @Parameter
    private ImgUtilityService imgUtilService;

    @Override
    public <T extends RealType<T>> void populatePlane(Reader reader, int imageIndex, int planeIndex, byte[] plane, ImgPlus<T> planarImg, SCIFIOConfig config) {
        boolean little;
        boolean fp;
        Metadata m = reader.getMetadata();
        PlanarAccess<ArrayDataAccess<?>> planarAccess = this.imgUtilService.getPlanarAccess(planarImg);
        int pixelType = m.get(imageIndex).getPixelType();
        int bpp = FormatTools.getBytesPerPixel(pixelType);
        Object planeArray = Bytes.makeArray((byte[])plane, (int)bpp, (boolean)(fp = FormatTools.isFloatingPoint(pixelType)), (boolean)(little = m.get(imageIndex).isLittleEndian()));
        if (planeArray == plane) {
            byte[] planeCopy = new byte[plane.length];
            System.arraycopy(plane, 0, planeCopy, 0, plane.length);
            planeArray = planeCopy;
        }
        planarAccess.setPlane(planeIndex, this.imgUtilService.makeArray(planeArray));
    }
}

