/*
 * Decompiled with CFR 0.152.
 */
package io.scif.util;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;

public class ImageHash {
    public static String hashImg(IterableInterval img) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException exc) {
            throw new IllegalStateException();
        }
        ByteBuffer buffer = ByteBuffer.allocate(5000);
        Cursor c = img.cursor();
        while (c.hasNext()) {
            if (buffer.remaining() > 8) {
                buffer.putDouble(((RealType)c.next()).getRealDouble());
                continue;
            }
            digest.update(buffer.array());
            buffer.rewind();
        }
        return ImageHash.convertByteArrayToHexString(digest.digest());
    }

    private static String convertByteArrayToHexString(byte[] arrayBytes) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < arrayBytes.length; ++i) {
            builder.append(Integer.toString((arrayBytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return builder.toString();
    }
}

