/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.NewImage;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;

public class Kuwahara_LinearStructure_Filter_v3
implements PlugInFilter {
    protected int imW;
    protected int imH;
    protected int kW;
    protected int kH;
    protected int nAngles;
    protected int size;
    protected int criterionMethod = 1;
    protected boolean showKernels;

    public int setup(String arg, ImagePlus imp) {
        if (imp == null) {
            return 4096;
        }
        return 77;
    }

    public void run(ImageProcessor ipData) {
        if (!this.showDialog()) {
            return;
        }
        this.imW = ipData.getWidth();
        this.imH = ipData.getHeight();
        this.kW = this.size;
        this.kH = this.size;
        ImageStack imsKernels = this.createKernel(this.size, this.nAngles);
        this.filter(ipData, imsKernels);
    }

    ImageStack createKernel(int size, int nAngles) {
        int y1;
        int nB = 3;
        int sizeTemp = size + 2 * nB;
        ImagePlus impLine = NewImage.createShortImage((String)"imLine", (int)sizeTemp, (int)sizeTemp, (int)1, (int)1);
        ImageProcessor ipLine = impLine.getProcessor();
        int x1 = (sizeTemp - 1) / 2;
        for (y1 = 0; y1 < sizeTemp; ++y1) {
            ipLine.putPixel(x1, y1, 1);
        }
        double rotationAngle = 180 / nAngles;
        ImagePlus impLineRotated = NewImage.createShortImage((String)"imLineRot", (int)sizeTemp, (int)sizeTemp, (int)1, (int)1);
        ImageProcessor ipLineRotated = impLineRotated.getProcessor();
        ImageStack imsKernel = new ImageStack(size, size);
        short[][] rotLineStack = new short[nAngles][size * size];
        for (int iAngle = 0; iAngle < nAngles; ++iAngle) {
            ipLineRotated.copyBits(ipLine, 0, 0, 0);
            ipLineRotated.rotate((double)iAngle * rotationAngle);
            int i = 0;
            for (x1 = nB; x1 < sizeTemp - nB; ++x1) {
                for (y1 = nB; y1 < sizeTemp - nB; ++y1) {
                    rotLineStack[iAngle][i] = (short)ipLineRotated.getPixel(x1, y1);
                    ++i;
                }
            }
            imsKernel.addSlice("kernel", (Object)rotLineStack[iAngle]);
        }
        if (this.showKernels) {
            ImagePlus impKernel = new ImagePlus("Kernels", imsKernel);
            impKernel.show();
        }
        return imsKernel;
    }

    public void filter(ImageProcessor ipData, ImageStack imsKernels) {
        int[][] im = new int[this.imW][this.imH];
        int[][] imSquare = new int[this.imW][this.imH];
        ipData.resetMinAndMax();
        int imMin = (int)ipData.getMin();
        for (int x1 = 0; x1 < this.imW; ++x1) {
            for (int y1 = 0; y1 < this.imH; ++y1) {
                im[x1][y1] = ipData.getPixel(x1, y1) - imMin;
                imSquare[x1][y1] = im[x1][y1] * im[x1][y1];
            }
        }
        int[][] imSum = new int[this.imW][this.imH];
        int[][] imSumOfSquares = new int[this.imW][this.imH];
        float[][] value = new float[this.imW][this.imH];
        float[][] criterion = new float[this.imW][this.imH];
        float[][] result = new float[this.imW][this.imH];
        float[][] resultTemp = new float[this.imW][this.imH];
        float[][] resultCriterion = new float[this.imW][this.imH];
        float[][] resultCriterionTemp = new float[this.imW][this.imH];
        this.setFloatArray(result, 0.0f);
        this.setFloatArray(resultCriterion, Float.MAX_VALUE);
        int nKernels = imsKernels.getSize();
        for (int iKernel = 0; iKernel < nKernels; ++iKernel) {
            short[] pixelsKernel = (short[])imsKernels.getPixels(iKernel + 1);
            this.convolve2(im, imSquare, imSum, imSumOfSquares, pixelsKernel);
            int kernelSum = this.kernelSum(pixelsKernel);
            if (this.criterionMethod == 0) {
                this.calculateCriterionVariance(imSum, imSumOfSquares, kernelSum, value, criterion);
            } else if (this.criterionMethod == 1) {
                this.calculateCriterionVarianceDivMean(imSum, imSumOfSquares, kernelSum, value, criterion);
            } else if (this.criterionMethod == 2) {
                this.calculateCriterionVarianceDivMean2(imSum, imSumOfSquares, kernelSum, value, criterion);
            }
            this.KuwaharaGM(value, criterion, pixelsKernel, resultTemp, resultCriterionTemp);
            this.setResultAndCriterion(result, resultTemp, resultCriterion, resultCriterionTemp);
            IJ.showProgress((int)(iKernel + 1), (int)nKernels);
        }
        this.putFloat2Image(ipData, result, imMin);
        ipData.resetMinAndMax();
    }

    void convolve2(int[][] im1, int[][] im2, int[][] im1Conv, int[][] im2Conv, short[] pixelsKernel) {
        int x1min = (this.kW - 1) / 2;
        int x1max = this.imW - (this.kW - 1) / 2 - 1;
        int y1min = (this.kH - 1) / 2;
        int y1max = this.imH - (this.kH - 1) / 2 - 1;
        int sum1 = 0;
        int sum2 = 0;
        boolean n = false;
        int i = 0;
        for (int x1 = x1min; x1 <= x1max; ++x1) {
            for (int y1 = y1min; y1 <= y1max; ++y1) {
                int x2min = x1 - (this.kW - 1) / 2;
                int x2max = x1 + (this.kW - 1) / 2;
                int y2min = y1 - (this.kH - 1) / 2;
                int y2max = y1 + (this.kH - 1) / 2;
                sum1 = 0;
                sum2 = 0;
                n = false;
                i = 0;
                for (int y2 = y2min; y2 <= y2max; ++y2) {
                    for (int x2 = x2min; x2 <= x2max; ++x2) {
                        sum1 += im1[x2][y2] * pixelsKernel[i];
                        sum2 += im2[x2][y2] * pixelsKernel[i];
                        ++i;
                    }
                }
                im1Conv[x1][y1] = sum1;
                im2Conv[x1][y1] = sum2;
            }
        }
    }

    int kernelSum(short[] pixelsKernel) {
        int kernelSum = 0;
        for (int i = 0; i < this.kW * this.kH; ++i) {
            kernelSum += pixelsKernel[i];
        }
        return kernelSum;
    }

    void KuwaharaGM(float[][] value, float[][] criterion, short[] pixelsKernel, float[][] result, float[][] resultCriterion) {
        int x1min = (this.kW - 1) / 2;
        int x1max = this.imW - (this.kW - 1) / 2 - 1;
        int y1min = (this.kH - 1) / 2;
        int y1max = this.imH - (this.kH - 1) / 2 - 1;
        for (int x1 = x1min; x1 <= x1max; ++x1) {
            for (int y1 = y1min; y1 <= y1max; ++y1) {
                int x2min = x1 - (this.kW - 1) / 2;
                int x2max = x1 + (this.kW - 1) / 2;
                int y2min = y1 - (this.kH - 1) / 2;
                int y2max = y1 + (this.kH - 1) / 2;
                int i = 0;
                int n = 0;
                float min = Float.MAX_VALUE;
                int x1minPos = x1;
                int y1minPos = y1;
                for (int y2 = y2min; y2 <= y2max; ++y2) {
                    for (int x2 = x2min; x2 <= x2max; ++x2) {
                        if (pixelsKernel[i++] <= 0 || !(criterion[x2][y2] < min)) continue;
                        min = criterion[x2][y2];
                        x1minPos = x2;
                        y1minPos = y2;
                        ++n;
                    }
                }
                result[x1][y1] = value[x1minPos][y1minPos];
                resultCriterion[x1][y1] = min;
            }
        }
    }

    void setResultAndCriterion(float[][] result, float[][] resultTemp, float[][] resultCriterion, float[][] resultCriterionTemp) {
        for (int x1 = this.kW; x1 < this.imW - this.kW; ++x1) {
            for (int y1 = this.kH; y1 < this.imH - this.kH; ++y1) {
                if (!(resultCriterionTemp[x1][y1] < resultCriterion[x1][y1])) continue;
                resultCriterion[x1][y1] = resultCriterionTemp[x1][y1];
                result[x1][y1] = resultTemp[x1][y1];
            }
        }
    }

    void setFloatArray(float[][] array, float val) {
        for (int x1 = 0; x1 < this.imW; ++x1) {
            for (int y1 = 0; y1 < this.imH; ++y1) {
                array[x1][y1] = val;
            }
        }
    }

    public final void calculateCriterionVariance(int[][] imSum, int[][] imSumOfSquares, int kernelSum, float[][] value, float[][] criterion) {
        for (int x1 = 0; x1 < this.imW; ++x1) {
            for (int y1 = 0; y1 < this.imH; ++y1) {
                value[x1][y1] = (float)imSum[x1][y1] / (float)kernelSum;
                criterion[x1][y1] = (float)(imSumOfSquares[x1][y1] / kernelSum) - value[x1][y1] * value[x1][y1];
            }
        }
    }

    public final void calculateCriterionVarianceDivMean(int[][] imSum, int[][] imSumOfSquares, int kernelSum, float[][] value, float[][] criterion) {
        for (int x1 = 0; x1 < this.imW; ++x1) {
            for (int y1 = 0; y1 < this.imH; ++y1) {
                value[x1][y1] = (float)imSum[x1][y1] / (float)kernelSum;
                criterion[x1][y1] = ((float)(imSumOfSquares[x1][y1] / kernelSum) - value[x1][y1] * value[x1][y1]) / (value[x1][y1] + Float.MIN_VALUE);
            }
        }
    }

    public final void calculateCriterionVarianceDivMean2(int[][] imSum, int[][] imSumOfSquares, int kernelSum, float[][] value, float[][] criterion) {
        for (int x1 = 0; x1 < this.imW; ++x1) {
            for (int y1 = 0; y1 < this.imH; ++y1) {
                value[x1][y1] = (float)imSum[x1][y1] / (float)kernelSum;
                criterion[x1][y1] = ((float)(imSumOfSquares[x1][y1] / kernelSum) - value[x1][y1] * value[x1][y1]) / (value[x1][y1] * value[x1][y1] + Float.MIN_VALUE);
            }
        }
    }

    void putFloat2Image(ImageProcessor ip, float[][] imFloat, int imMin) {
        for (int x1 = 0; x1 < this.imW; ++x1) {
            for (int y1 = 0; y1 < this.imH; ++y1) {
                int x2 = x1;
                int y2 = y1;
                if (x1 < this.kW) {
                    x2 = this.kW;
                }
                if (x1 >= this.imW - this.kW) {
                    x2 = this.imW - this.kW - 1;
                }
                if (y1 < this.kH) {
                    y2 = this.kH;
                }
                if (y1 >= this.imH - this.kH) {
                    y2 = this.imH - this.kH - 1;
                }
                ip.putPixel(x1, y1, (int)((double)imFloat[x2][y2] + 0.5 + (double)imMin));
            }
        }
    }

    boolean showDialog() {
        String[] criteria = new String[]{"Variance", "Variance / Mean", "Variance / Mean^2"};
        GenericDialog gd = new GenericDialog("Kuwahara Filter");
        gd.addNumericField("Number_of_angles", 30.0, 0);
        gd.addNumericField("Line_length", 11.0, 0);
        gd.addChoice("Criterion", criteria, criteria[0]);
        gd.addCheckbox("Show_kernels", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.nAngles = (int)gd.getNextNumber();
        this.size = (int)gd.getNextNumber();
        this.criterionMethod = gd.getNextChoiceIndex();
        this.showKernels = gd.getNextBoolean();
        if (this.size % 2 == 0) {
            IJ.error((String)"Line length must be odd!");
            return false;
        }
        return true;
    }
}

