/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;

public final class GsonUtils {
    private GsonUtils() {
    }

    private static Gson gson() {
        return new Gson();
    }

    public static void write(JsonElement json, String filename) {
        try (FileWriter writer = new FileWriter(filename);){
            GsonUtils.gson().toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonElement read(String filename) {
        try (FileReader reader = new FileReader(filename);){
            JsonElement jsonElement = (JsonElement)GsonUtils.gson().fromJson((Reader)reader, JsonElement.class);
            return jsonElement;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void write(JsonElement json, OutputStream out) {
        try (OutputStreamWriter writer = new OutputStreamWriter(out);){
            GsonUtils.gson().toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonElement read(InputStream in) {
        try (InputStreamReader reader = new InputStreamReader(in);){
            JsonElement jsonElement = (JsonElement)GsonUtils.gson().fromJson((Reader)reader, JsonElement.class);
            return jsonElement;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String toString(JsonElement json) {
        try (StringWriter writer = new StringWriter();){
            GsonUtils.gson().toJson(json, (Appendable)writer);
            String string = ((Object)writer).toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonElement fromString(String text) {
        try (StringReader reader = new StringReader(text);){
            JsonElement jsonElement = (JsonElement)GsonUtils.gson().fromJson((Reader)reader, JsonElement.class);
            return jsonElement;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

