/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.detection;

import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.detection.DetectionUtils;
import fiji.plugin.trackmate.detection.SpotDetector;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.util.Threads;
import ij.gui.Roi;
import ij.plugin.frame.RoiManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.ToDoubleFunction;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.MultiThreaded;
import net.imglib2.algorithm.gradient.HessianMatrix;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.outofbounds.OutOfBoundsBorderFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.parallel.TaskExecutor;
import net.imglib2.parallel.TaskExecutors;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import net.imglib2.view.composite.CompositeIntervalView;
import net.imglib2.view.composite.RealComposite;
import org.scijava.thread.ThreadService;

public class HessianDetector<T extends RealType<T> & NativeType<T>>
implements SpotDetector<T>,
MultiThreaded {
    private static final String BASE_ERROR_MESSAGE = "HessianDetector: ";
    private final RandomAccessible<T> img;
    private final Interval interval;
    private final double[] calibration;
    private final double radiusXY;
    private final double radiusZ;
    private final double threshold;
    private final boolean doSubPixelLocalization;
    private String errorMessage;
    private List<Spot> spots;
    private long processingTime;
    private int nTasks;
    private final boolean normalize;
    private final ExecutorService es;

    public HessianDetector(RandomAccessible<T> img, Interval interval, double[] calibration, double radiusXY, double radiusZ, double threshold, boolean normalize, boolean doSubPixelLocalization) {
        this.img = img;
        this.interval = DetectionUtils.squeeze(interval);
        this.calibration = calibration;
        this.radiusXY = radiusXY;
        this.radiusZ = radiusZ;
        this.threshold = threshold;
        this.normalize = normalize;
        this.doSubPixelLocalization = doSubPixelLocalization;
        this.setNumThreads();
        ThreadService threadService = (ThreadService)TMUtils.getContext().getService(ThreadService.class);
        this.es = threadService == null ? Threads.newCachedThreadPool() : threadService.getExecutorService();
    }

    public boolean checkInput() {
        if (null == this.img) {
            this.errorMessage = "HessianDetector: Image is null.";
            return false;
        }
        if (this.img.numDimensions() > 3 || this.img.numDimensions() < 2) {
            this.errorMessage = "HessianDetector: Image must be 2D or 3D, got " + this.img.numDimensions() + "D.";
            return false;
        }
        return true;
    }

    public boolean process() {
        this.spots = null;
        this.errorMessage = null;
        long start = System.currentTimeMillis();
        RoiManager roiManager = RoiManager.getInstance();
        boolean ok = true;
        if (roiManager == null || roiManager.getCount() == 0) {
            this.spots = this.processInterval(this.interval);
            if (this.spots == null) {
                ok = false;
            }
        } else {
            this.spots = new ArrayList<Spot>();
            for (Roi roi : roiManager.getRoisAsArray()) {
                FinalInterval intervalroi;
                FinalInterval intersect;
                Rectangle bounds = roi.getBounds();
                long[] max = new long[this.img.numDimensions()];
                long[] min = new long[this.img.numDimensions()];
                min[0] = bounds.x;
                max[0] = bounds.x + bounds.width;
                min[1] = bounds.y;
                max[1] = bounds.y + bounds.height;
                if (this.interval.numDimensions() > 2) {
                    min[2] = this.interval.min(2);
                    max[2] = this.interval.max(2);
                }
                if (Intervals.isEmpty((Interval)(intersect = Intervals.intersect((Interval)this.interval, (Interval)(intervalroi = FinalInterval.wrap((long[])min, (long[])max)))))) continue;
                List<Spot> spotsThisRoi = this.processInterval((Interval)intersect);
                if (spotsThisRoi == null) {
                    ok = false;
                    continue;
                }
                ArrayList<Spot> prunedSpots = new ArrayList<Spot>();
                for (Spot spot : spotsThisRoi) {
                    if (!roi.contains((int)Math.round(spot.getFeature("POSITION_X") / this.calibration[0]), (int)Math.round(spot.getFeature("POSITION_Y") / this.calibration[1]))) continue;
                    prunedSpots.add(spot);
                }
                this.spots.addAll(prunedSpots);
            }
        }
        long end = System.currentTimeMillis();
        this.processingTime = end - start;
        return ok;
    }

    private final List<Spot> processInterval(Interval crop) {
        try {
            Img<FloatType> det = this.computeHessianDeterminant(crop, new FloatType());
            if (this.normalize) {
                DetectionUtils.normalize(det);
            }
            long[] minopposite = new long[crop.numDimensions()];
            crop.min(minopposite);
            IntervalView to = Views.translate(det, (long[])minopposite);
            return DetectionUtils.findLocalMaxima(to, this.threshold, this.calibration, this.radiusXY, this.doSubPixelLocalization, this.nTasks);
        }
        catch (InterruptedException | ExecutionException | IncompatibleTypeException e) {
            this.errorMessage = BASE_ERROR_MESSAGE + e.getMessage();
            e.printStackTrace();
            return null;
        }
    }

    private final <R extends RealType<R> & NativeType<R>> Img<R> computeHessianDeterminant(Interval crop, R type) throws IncompatibleTypeException, InterruptedException, ExecutionException {
        int n = crop.numDimensions();
        double[] radius = new double[]{this.radiusXY, this.radiusXY, this.radiusZ};
        double[] sigmas = new double[n];
        for (int d2 = 0; d2 < n; ++d2) {
            double cal = d2 < this.calibration.length ? this.calibration[d2] : 1.0;
            sigmas[d2] = radius[d2] / cal / Math.sqrt(n);
        }
        long[] gradientDims = new long[n + 1];
        long[] hessianDims = new long[n + 1];
        for (int d3 = 0; d3 < n; ++d3) {
            hessianDims[d3] = crop.dimension(d3);
            gradientDims[d3] = crop.dimension(d3);
        }
        hessianDims[n] = n * (n + 1) / 2;
        gradientDims[n] = n;
        FinalDimensions hessianDimensions = FinalDimensions.wrap((long[])hessianDims);
        FinalDimensions gradientDimensions = FinalDimensions.wrap((long[])gradientDims);
        ImgFactory factory = Util.getArrayOrCellImgFactory((Dimensions)hessianDimensions, (NativeType<R>)type);
        Img hessian = factory.create((Dimensions)hessianDimensions);
        Img gradient = factory.create((Dimensions)gradientDimensions);
        Img gaussian = factory.create((Dimensions)crop);
        IntervalView input = Views.zeroMin((RandomAccessibleInterval)Views.interval(this.img, (Interval)crop));
        HessianMatrix.calculateMatrix((RandomAccessible)input, (RandomAccessibleInterval)gaussian, (RandomAccessibleInterval)gradient, (RandomAccessibleInterval)hessian, (OutOfBoundsFactory)new OutOfBoundsBorderFactory(), (int)this.nTasks, (ExecutorService)this.es, (double[])sigmas);
        IntervalView H = HessianMatrix.scaleHessianMatrix((RandomAccessibleInterval)hessian, (double[])sigmas);
        ToDoubleFunction<RealComposite> detcalc = n == 2 ? c -> {
            double a00 = ((RealType)c.get(0L)).getRealDouble();
            double a01 = ((RealType)c.get(1L)).getRealDouble();
            double a11 = ((RealType)c.get(2L)).getRealDouble();
            double det = a00 * a11 - a01 * a01;
            return det;
        } : c -> {
            double a00 = ((RealType)c.get(0L)).getRealDouble();
            double a01 = ((RealType)c.get(1L)).getRealDouble();
            double a02 = ((RealType)c.get(2L)).getRealDouble();
            double a11 = ((RealType)c.get(3L)).getRealDouble();
            double a12 = ((RealType)c.get(4L)).getRealDouble();
            double a22 = ((RealType)c.get(5L)).getRealDouble();
            double x = a11 * a22 - a12 * a12;
            double y = a01 * a22 - a02 * a12;
            double z = a01 * a12 - a02 * a11;
            double det = a00 * x - a01 * y + a02 * z;
            return -det;
        };
        CompositeIntervalView composite = Views.collapseReal((RandomAccessibleInterval)H);
        Img det = factory.create((Dimensions)crop);
        TaskExecutor taskExecutor = TaskExecutors.forExecutorServiceAndNumTasks((ExecutorService)this.es, (int)this.nTasks);
        LoopBuilder.setImages((RandomAccessibleInterval)composite, (RandomAccessibleInterval)det).multiThreaded(taskExecutor).forEachPixel((c, d) -> d.setReal(detcalc.applyAsDouble((RealComposite)c)));
        return det;
    }

    public List<Spot> getResult() {
        return this.spots;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setNumThreads() {
        this.nTasks = Runtime.getRuntime().availableProcessors() / 2;
    }

    public void setNumThreads(int nTasks) {
        this.nTasks = nTasks;
    }

    public int getNumThreads() {
        return this.nTasks;
    }
}

