/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.features.spot;

import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotRoi;
import fiji.plugin.trackmate.features.spot.AbstractSpotFeatureAnalyzer;
import fiji.plugin.trackmate.features.spot.ConvexHull;
import net.imglib2.type.numeric.RealType;

public class SpotShapeAnalyzer<T extends RealType<T>>
extends AbstractSpotFeatureAnalyzer<T> {
    private final boolean is2D;

    public SpotShapeAnalyzer(boolean is2D) {
        this.is2D = is2D;
    }

    @Override
    public void process(Spot spot) {
        double convexArea;
        double perimeter;
        double area;
        if (this.is2D) {
            SpotRoi roi = spot.getRoi();
            if (roi != null) {
                area = roi.area();
                perimeter = SpotShapeAnalyzer.getLength(roi);
                SpotRoi convexHull = ConvexHull.convexHull(roi);
                convexArea = convexHull.area();
            } else {
                double radius = spot.getFeature("RADIUS");
                convexArea = area = Math.PI * radius * radius;
                perimeter = Math.PI * 2 * radius;
            }
        } else {
            double radius = spot.getFeature("RADIUS");
            convexArea = area = Math.PI * 4 * radius * radius;
            perimeter = Double.NaN;
        }
        double circularity = Math.PI * 4 * (area / (perimeter * perimeter));
        double solidity = area / convexArea;
        double shapeIndex = area <= 0.0 ? Double.NaN : perimeter / Math.sqrt(area);
        spot.putFeature("AREA", area);
        spot.putFeature("PERIMETER", perimeter);
        spot.putFeature("CIRCULARITY", circularity);
        spot.putFeature("SOLIDITY", solidity);
        spot.putFeature("SHAPE_INDEX", shapeIndex);
    }

    private static final double getLength(SpotRoi roi) {
        double[] x = roi.x;
        double[] y = roi.y;
        int npoints = x.length;
        if (npoints < 2) {
            return 0.0;
        }
        double length = 0.0;
        for (int i = 0; i < npoints - 1; ++i) {
            double dx = x[i + 1] - x[i];
            double dy = y[i + 1] - y[i];
            length += Math.sqrt(dx * dx + dy * dy);
        }
        double dx0 = x[0] - x[npoints - 1];
        double dy0 = y[0] - y[npoints - 1];
        return length += Math.sqrt(dx0 * dx0 + dy0 * dy0);
    }
}

