/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.editor.labkit.model;

import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.gui.editor.labkit.model.TMTransformationModel;
import java.util.Collections;
import java.util.Map;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import sc.fiji.labkit.ui.inputimage.ImgPlusViewsOld;
import sc.fiji.labkit.ui.inputimage.InputImage;
import sc.fiji.labkit.ui.labeling.Label;
import sc.fiji.labkit.ui.models.ImageLabelingModel;
import sc.fiji.labkit.ui.models.TransformationModel;

public class TMImageLabelingModel
extends ImageLabelingModel {
    private final TMTransformationModel tmTranslationModel;
    private Map<Label, Spot> initialMapping;
    private RandomAccessibleInterval<UnsignedIntType> initialIndexImg;

    public TMImageLabelingModel(InputImage inputImage) {
        super(inputImage);
        ImgPlus image = inputImage.imageForSegmentation();
        boolean isTimeSeries = ImgPlusViewsOld.hasAxis((ImgPlus)image, (AxisType)Axes.TIME);
        this.tmTranslationModel = new TMTransformationModel(isTimeSeries);
    }

    public TransformationModel transformationModel() {
        return this.tmTranslationModel;
    }

    public Map<Label, Spot> initialMapping() {
        return Collections.unmodifiableMap(this.initialMapping);
    }

    public RandomAccessibleInterval<UnsignedIntType> initialIndexImg() {
        return this.initialIndexImg;
    }

    void setInitialState(Map<Label, Spot> initialMapping, RandomAccessibleInterval<UnsignedIntType> initialIndexImg) {
        this.initialMapping = initialMapping;
        this.initialIndexImg = initialIndexImg;
    }
}

