/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.wizard;

import fiji.plugin.trackmate.gui.wizard.AbstractAnimator;
import fiji.plugin.trackmate.util.ImageHelper;
import java.awt.Component;
import java.awt.image.BufferedImage;

public class TransitionAnimator
extends AbstractAnimator {
    private final BufferedImage combined;
    private final int width;
    private final int height;
    private final Direction direction;

    public TransitionAnimator(Component from, Component to, Direction direction, long duration) {
        super(duration);
        this.direction = direction;
        switch (direction) {
            default: {
                this.combined = ImageHelper.combineImages(ImageHelper.captureComponent(to), ImageHelper.captureComponent(from), 0);
                break;
            }
            case RIGHT: {
                this.combined = ImageHelper.combineImages(ImageHelper.captureComponent(from), ImageHelper.captureComponent(to), 0);
                break;
            }
            case BOTTOM: {
                this.combined = ImageHelper.combineImages(ImageHelper.captureComponent(to), ImageHelper.captureComponent(from), 1);
                break;
            }
            case TOP: {
                this.combined = ImageHelper.combineImages(ImageHelper.captureComponent(from), ImageHelper.captureComponent(to), 1);
            }
        }
        this.width = from.getWidth();
        this.height = from.getHeight();
    }

    public BufferedImage getCurrent(long time) {
        this.setTime(time);
        return this.get(this.ratioComplete());
    }

    public BufferedImage get(double t) {
        int y;
        int x;
        switch (this.direction) {
            default: {
                x = this.width - (int)Math.round(t * (double)this.width);
                y = 0;
                break;
            }
            case RIGHT: {
                x = (int)Math.round(t * (double)this.width);
                y = 0;
                break;
            }
            case BOTTOM: {
                x = 0;
                y = this.height - (int)Math.round(t * (double)this.height);
                break;
            }
            case TOP: {
                x = 0;
                y = (int)Math.round(t * (double)this.height);
            }
        }
        return this.combined.getSubimage(x, y, this.width, this.height);
    }

    public static enum Direction {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

