/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.io;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import java.util.regex.Pattern;
import net.imglib2.algorithm.Benchmark;
import net.imglib2.algorithm.OutputAlgorithm;
import net.imglib2.realtransform.AffineTransform3D;

public class TGMMImporter
implements OutputAlgorithm<Model>,
Benchmark {
    private static final FilenameFilter xmlFilter = new FilenameFilter(){

        @Override
        public boolean accept(File folder, String name) {
            return name.toLowerCase().endsWith(".xml");
        }
    };
    private static final String BASE_ERROR_MSG = "[TGMMImporter] ";
    private static final String XML_DETECTION_NAME = "GaussianMixtureModel";
    private static final String XML_CENTROID = "m";
    private static final String XML_ID = "id";
    private static final String XML_SCORE = "splitScore";
    private static final String XML_NU = "nu";
    private static final String XML_PRECISION_MATRIX = "W";
    private static final String XML_LINEAGE = "lineage";
    private static final String XML_PARENT = "parent";
    private static final Pattern DEFAULT_PATTERN = Pattern.compile(".+_frame(\\d+)\\.xml");
    private final File file;
    private String errorMessage;
    private final Pattern framePattern;
    private Model model;
    private final List<AffineTransform3D> transforms;
    private final Logger logger;
    private long processingTime;

    public TGMMImporter(File file, List<AffineTransform3D> transforms, Pattern framePattern, Logger logger) {
        this.file = file;
        this.framePattern = framePattern;
        this.transforms = transforms;
        this.logger = logger;
    }

    public TGMMImporter(File file, List<AffineTransform3D> transforms, Pattern framePattern) {
        this(file, transforms, framePattern, Logger.VOID_LOGGER);
    }

    public TGMMImporter(File file, List<AffineTransform3D> transforms) {
        this(file, transforms, DEFAULT_PATTERN);
    }

    public TGMMImporter(File file, List<AffineTransform3D> transforms, Logger logger) {
        this(file, transforms, DEFAULT_PATTERN, logger);
    }

    public boolean checkInput() {
        if (!this.file.exists()) {
            this.errorMessage = "[TGMMImporter] Folder " + this.file + " does not exist.\n";
            return false;
        }
        if (!this.file.canRead()) {
            this.errorMessage = "[TGMMImporter] Folder " + this.file + " cannot be read.\n";
            return false;
        }
        if (!this.file.isDirectory()) {
            this.errorMessage = BASE_ERROR_MSG + this.file + " is not a folder.\n";
            return false;
        }
        if (this.file.listFiles(xmlFilter).length == 0) {
            this.errorMessage = "[TGMMImporter] Folder " + this.file + " does not contain XML files.\n";
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    public boolean process() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 19[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Model getResult() {
        return this.model;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }
}

