/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util.cli;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.util.cli.CLIConfigurator;
import fiji.plugin.trackmate.util.cli.CommandBuilder;
import fiji.plugin.trackmate.util.cli.CondaCLIConfigurator;
import ij.IJ;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.TailerListener;
import org.apache.commons.io.input.TailerListenerAdapter;
import org.scijava.prefs.PrefService;

public class CLIUtils {
    public static final String CONDA_PATH_PREF_KEY = "trackmate.conda.path";
    public static final String CONDA_ROOT_PREFIX_KEY = "trackmate.conda.root.prefix";
    private static Map<String, String> envMap;

    public static final Process createProcess(CLIConfigurator cli, File logFile) throws IOException {
        List<String> cmd = CommandBuilder.build(cli);
        ProcessBuilder pb = new ProcessBuilder(cmd);
        if (cli instanceof CondaCLIConfigurator) {
            HashMap<String, String> env = new HashMap<String, String>();
            String condaRootPrefix = CLIUtils.getCondaRootPrefix();
            env.put("MAMBA_ROOT_PREFIX", condaRootPrefix);
            env.put("CONDA_ROOT_PREFIX", condaRootPrefix);
            pb.environment().putAll(env);
        }
        pb.redirectOutput(ProcessBuilder.Redirect.appendTo(logFile));
        pb.redirectError(ProcessBuilder.Redirect.appendTo(logFile));
        return pb.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Process createAndHandleProcess(CLIConfigurator cli, Logger logger, File logFile) {
        String executableName = cli.getClass().getSimpleName();
        try (Tailer tailer = ((Tailer.Builder)Tailer.builder().setFile(logFile)).setTailerListener((TailerListener)new LoggerTailerListener(logger)).setDelayDuration(Duration.ofMillis(200L)).setTailFromEnd(true).get();){
            Process process;
            List<String> cmd = CommandBuilder.build(cli);
            logger.setStatus("Running " + executableName);
            logger.log("Running " + executableName + " with args:\n");
            cmd.forEach(t -> {
                if (t.contains(File.separator)) {
                    logger.log(t + ' ');
                } else {
                    logger.log(t + ' ', Logger.GREEN_COLOR.darker());
                }
            });
            logger.log("\n");
            Process process2 = process = CLIUtils.createProcess(cli, logFile);
            return process2;
        }
        return null;
    }

    public static boolean execute(CLIConfigurator cli, Logger logger, File logFile) {
        Process process = CLIUtils.createAndHandleProcess(cli, logger, logFile);
        if (process == null) {
            return false;
        }
        try {
            int returnValue = process.waitFor();
            return returnValue == 0;
        }
        catch (InterruptedException e) {
            logger.error("Process interrupted: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static String getModuleVersion(String envName, String moduleName) {
        String cmd = "python -c import_" + moduleName + ";print(" + moduleName + ".__version__)";
        List<String> tokens = CLIUtils.preparePythonCommand(envName, cmd);
        if (tokens.isEmpty()) {
            return null;
        }
        ListIterator<String> it = tokens.listIterator();
        while (it.hasNext()) {
            String token = it.next();
            it.set(token.replace("t_", "t "));
        }
        ProcessBuilder pb = new ProcessBuilder(tokens);
        HashMap<String, String> env = new HashMap<String, String>();
        String condaRootPrefix = CLIUtils.getCondaRootPrefix();
        env.put("MAMBA_ROOT_PREFIX", condaRootPrefix);
        env.put("CONDA_ROOT_PREFIX", condaRootPrefix);
        pb.environment().putAll(env);
        pb.redirectErrorStream(true);
        try {
            String line;
            Process process = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String prevLine = null;
            StringBuffer errorMsg = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                prevLine = line;
                errorMsg.append('\n' + line);
            }
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                return prevLine;
            }
            throw new Exception("Error running the command '" + moduleName + "' in environment '" + envName + "'" + errorMsg);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<String> preparePythonCommand(String envName, String cmdName) {
        ArrayList<String> cmd = new ArrayList<String>();
        try {
            String pythonPath = CLIUtils.getEnvMap().get(envName);
            if (pythonPath == null) {
                throw new Exception("Unknown conda environment: " + envName);
            }
            int i = pythonPath.lastIndexOf("python");
            String binPath = pythonPath.substring(0, i);
            String executablePath = binPath + cmdName;
            String[] split = executablePath.split(" ");
            cmd.addAll(Arrays.asList(split));
            return cmd;
        }
        catch (IOException e) {
            System.err.println("Could not find the conda executable or change the conda environment.\nPlease configure the path to your conda executable in Edit > Options > Configure TrackMate Conda path...");
            e.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("Error running the conda executable:");
            e.printStackTrace();
        }
        return cmd;
    }

    public static void clearEnvMap() {
        envMap = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, String> getEnvMap() throws IOException {
        if (envMap != null) return envMap;
        Class<CLIUtils> clazz = CLIUtils.class;
        synchronized (CLIUtils.class) {
            String line;
            String s;
            if (envMap != null) return envMap;
            ProcessBuilder pb = new ProcessBuilder(Arrays.asList(CLIUtils.getCondaPath(), "env", "list"));
            HashMap<String, String> env = new HashMap<String, String>();
            String condaRootPrefix = CLIUtils.getCondaRootPrefix();
            env.put("MAMBA_ROOT_PREFIX", condaRootPrefix);
            env.put("CONDA_ROOT_PREFIX", condaRootPrefix);
            pb.environment().putAll(env);
            Process process = pb.start();
            BufferedReader stdOutput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String errorOutput = "";
            while ((s = stdError.readLine()) != null) {
                errorOutput = errorOutput + s + '\n';
            }
            if (!errorOutput.isEmpty()) {
                throw new IOException("Could not retrieve environment map properly:\n" + errorOutput);
            }
            envMap = new HashMap<String, String>();
            while ((line = stdOutput.readLine()) != null) {
                String envRoot;
                line = line.trim();
                if ((line = line.replaceAll("\\*", "")).isEmpty() || line.startsWith("#") || line.startsWith("Name") || line.startsWith("\u2500\u2500\u2500\u2500\u2500\u2500")) continue;
                String[] parts = line.split("\\s+");
                if (parts.length >= 2) {
                    String envName = parts[0];
                    String envPath = parts[1] + "/bin/python";
                    envMap.put(envName, envPath);
                    continue;
                }
                if (parts.length != 1 || !CLIUtils.isValidPath(envRoot = parts[0])) continue;
                Path path = Paths.get(envRoot, new String[0]);
                String envName = path.getFileName().toString();
                String envPath = envRoot + "/bin/python";
                envMap.put(envName, envPath);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return envMap;
        }
    }

    public static List<String> getEnvList() throws IOException {
        ArrayList<String> l = new ArrayList<String>(CLIUtils.getEnvMap().keySet());
        l.sort(null);
        return l;
    }

    public static String getCondaPath() {
        String findPath;
        PrefService prefs = (PrefService)TMUtils.getContext().getService(PrefService.class);
        try {
            findPath = CLIUtils.findDefaultCondaPath();
        }
        catch (IllegalArgumentException e) {
            findPath = "/usr/local/opt/micromamba/bin/micromamba";
        }
        return prefs.get(CLIUtils.class, CONDA_PATH_PREF_KEY, findPath);
    }

    public static String getCondaRootPrefix() {
        PrefService prefs = (PrefService)TMUtils.getContext().getService(PrefService.class);
        String findPath = "/usr/local/opt/micromamba";
        return prefs.get(CLIUtils.class, CONDA_ROOT_PREFIX_KEY, "/usr/local/opt/micromamba");
    }

    public static String findDefaultCondaPath() throws IllegalArgumentException {
        String[] toTest;
        String username = System.getProperty("user.name");
        String prefix = IJ.isMacOSX() ? "/Users/" : "/home/";
        String anaconda1 = prefix + username + "/anaconda3/bin/conda";
        String anaconda2 = "/opt/anaconda3/bin/conda";
        String miniconda1 = prefix + username + "/miniconda3/bin/conda";
        String miniconda2 = "/opt/miniconda3/bin/conda";
        String mamba1 = prefix + username + "/mamba/bin/mamba";
        String mamba2 = "/opt/mamba/bin/mamba";
        String micromamba1 = prefix + username + (IJ.isMacOSX() ? "/Library/micromamba/bin/micromamba" : "/.local/share/micromamba/bin/micromamba");
        String micromamba2 = "/usr/local/micromamba/bin/micromamba";
        String micromamba3 = "/usr/local/opt/micromamba/bin/micromamba";
        String micromamba4 = "/opt/micromamba/bin/micromamba";
        String micromamba5 = prefix + username + "/mambaforge/condabin/mamba";
        for (String str : toTest = new String[]{anaconda1, "/opt/anaconda3/bin/conda", miniconda1, "/opt/miniconda3/bin/conda", mamba1, "/opt/mamba/bin/mamba", micromamba1, "/usr/local/micromamba/bin/micromamba", "/usr/local/opt/micromamba/bin/micromamba", "/opt/micromamba/bin/micromamba", micromamba5}) {
            Path path = Paths.get(str, new String[0]);
            if (!Files.isExecutable(path)) continue;
            return str;
        }
        throw new IllegalArgumentException("Could not find a conda executable I know of, within: " + Arrays.asList(toTest));
    }

    public static void recursiveDeleteOnShutdownHook(final Path path) {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                            if (e == null) {
                                Files.delete(dir);
                                return FileVisitResult.CONTINUE;
                            }
                            throw e;
                        }
                    });
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to delete " + path, e);
                }
            }
        }));
    }

    public static boolean isValidPath(String pathString) {
        try {
            Pattern illegalCharsPattern;
            Path path = Paths.get(pathString, new String[0]);
            if (!pathString.contains("/") && !pathString.contains("\\")) {
                return false;
            }
            if (System.getProperty("os.name").toLowerCase().contains("win") && (illegalCharsPattern = Pattern.compile("[<>:*?\"|]")).matcher(pathString).find()) {
                return false;
            }
            return Files.exists(path, new LinkOption[0]);
        }
        catch (InvalidPathException e) {
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Conda path: " + CLIUtils.getCondaPath());
        System.out.println("Known environments: " + CLIUtils.getEnvList());
        System.out.println("Paths:");
        CLIUtils.getEnvMap().forEach((k, v) -> System.out.println(k + " -> " + v));
        System.out.println();
        System.out.println("Testing versions");
        System.out.println("1 - " + CLIUtils.getModuleVersion("trackastra", "trackastra"));
        System.out.println("2 - " + CLIUtils.getModuleVersion("cellpose", "cellpose"));
        System.out.println("3 - " + CLIUtils.getModuleVersion("cellpose", "cellposebloat"));
        System.out.println("4 - " + CLIUtils.getModuleVersion("cellposebarf", "cellpose"));
    }

    public static class LoggerTailerListener
    extends TailerListenerAdapter {
        protected final Logger logger;
        public Color COLOR = Logger.BLUE_COLOR.darker();
        private static final Pattern PERCENTAGE_PATTERN = Pattern.compile(".+\\D(\\d+(?:\\.\\d+)?)%.+");
        private static final Pattern INFO_PATTERN = Pattern.compile("(.+\\[INFO\\]\\s+(.+)|^INFO:.*$)");

        public LoggerTailerListener(Logger logger) {
            this.logger = logger;
        }

        public void handle(String rawLine) {
            String line = this.cleanLine(rawLine);
            Matcher matcher = PERCENTAGE_PATTERN.matcher(line);
            if (matcher.matches()) {
                String percent = matcher.group(1);
                this.logger.setProgress(Double.valueOf(percent) / 100.0);
            } else {
                Matcher matcher2 = INFO_PATTERN.matcher(line);
                if (matcher2.matches()) {
                    String str = matcher2.group(1).trim();
                    if (str.length() > 2) {
                        this.logger.setStatus(str.replaceAll("\\[INFO\\]", "").replaceAll("INFO:", "").replaceAll("INFO", ""));
                    }
                } else if (!line.trim().isEmpty()) {
                    this.logger.log(" - " + line + '\n', this.COLOR);
                }
            }
        }

        protected String cleanLine(String line) {
            String cleaned = line.replaceAll("\u001b\\[[;\\d]*[A-Za-z]", "");
            cleaned = cleaned.replaceAll("[\r\n\t]", " ");
            cleaned = cleaned.replaceAll("[^\\x20-\\x7E]", "");
            cleaned = cleaned.replaceAll("\\s+", " ");
            return cleaned.trim();
        }
    }
}

