/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import org.jhotdraw.color.ColorUtil;

public class ColorListCellRenderer
extends DefaultListCellRenderer {
    private ColorIcon icon = new ColorIcon();

    public ColorListCellRenderer() {
        this.setIcon(this.icon);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value instanceof Color) {
            Color c = (Color)value;
            this.icon.setColor(c);
            this.setToolTipText(ColorUtil.toToolTipText(c));
            this.setText("");
        } else {
            this.icon.setColor(null);
            this.setText("");
        }
        this.setIcon(this.icon);
        return this;
    }

    private static class ColorIcon
    implements Icon {
        @Nullable
        private Color color;

        private ColorIcon() {
        }

        public void setColor(@Nullable Color newValue) {
            this.color = newValue;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.color != null) {
                g.setColor(new Color(0x333333));
                g.drawRect(x, y, this.getIconWidth() - 1, this.getIconHeight() - 1);
                g.setColor(Color.WHITE);
                g.drawRect(x + 1, y + 1, this.getIconWidth() - 3, this.getIconHeight() - 3);
                g.setColor(this.color);
                g.fillRect(x + 2, y + 2, this.getIconWidth() - 4, this.getIconHeight() - 4);
            }
        }

        @Override
        public int getIconWidth() {
            return 24;
        }

        @Override
        public int getIconHeight() {
            return 18;
        }
    }
}

