/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.features.haralick;

import net.imagej.ops.Ops;
import net.imagej.ops.features.haralick.AbstractHaralickFeature;
import net.imagej.ops.features.haralick.helper.CoocPXMinusY;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Haralick.DifferenceVariance.class, label="Haralick: Difference Variance")
public class DefaultDifferenceVariance<T extends RealType<T>>
extends AbstractHaralickFeature<T>
implements Ops.Haralick.DifferenceVariance {
    private UnaryFunctionOp<double[][], double[]> coocPXMinusYFunc;

    @Override
    public void initialize() {
        super.initialize();
        this.coocPXMinusYFunc = Functions.unary(this.ops(), CoocPXMinusY.class, double[].class, double[][].class, new Object[0]);
    }

    @Override
    public void compute(IterableInterval<T> input, DoubleType output) {
        double[][] matrix = this.getCooccurrenceMatrix(input);
        double[] pxminusy = this.coocPXMinusYFunc.calculate(matrix);
        double mu = 0.0;
        for (int i = 0; i < this.numGreyLevels; ++i) {
            mu += (double)i * pxminusy[i];
        }
        double sum = 0.0;
        for (int k = 0; k < this.numGreyLevels; ++k) {
            sum += Math.pow((double)k - mu, 2.0) * pxminusy[k];
        }
        output.set(sum);
    }
}

