/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter.pad;

import net.imagej.ops.Ops;
import net.imagej.ops.special.function.AbstractBinaryFunctionOp;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.ComplexType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Filter.PaddingIntervalOrigin.class, name="filter.paddingIntervalOrigin", priority=100.0)
public class PaddingIntervalOrigin<T extends ComplexType<T>, I extends RandomAccessibleInterval<T>, O extends Interval>
extends AbstractBinaryFunctionOp<I, Interval, O>
implements Ops.Filter.PaddingIntervalOrigin {
    @Override
    public O calculate(I input, Interval centeredInterval) {
        int numDimensions = input.numDimensions();
        long[] min = new long[numDimensions];
        long[] max = new long[numDimensions];
        for (int d = 0; d < numDimensions; ++d) {
            min[d] = input.min(d) + input.dimension(d) / 2L;
            max[d] = min[d] + centeredInterval.dimension(d) - 1L;
        }
        return (O)new FinalInterval(min, max);
    }
}

