/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter.tubeness;

import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import net.imagej.ops.Ops;
import net.imagej.ops.special.computer.AbstractUnaryComputerOp;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gradient.HessianMatrix;
import net.imglib2.algorithm.linalg.eigen.TensorEigenValues;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.outofbounds.OutOfBoundsBorderFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.Views;
import org.scijava.Cancelable;
import org.scijava.app.StatusService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.thread.ThreadService;

@Plugin(type=Ops.Filter.Tubeness.class)
public class DefaultTubeness<T extends RealType<T>>
extends AbstractUnaryHybridCF<RandomAccessibleInterval<T>, IterableInterval<DoubleType>>
implements Cancelable,
Ops.Filter.Tubeness {
    @Parameter
    private ThreadService threadService;
    @Parameter
    private StatusService statusService;
    @Parameter
    private double sigma;
    @Parameter
    private double[] calibration;
    private String cancelReason;

    @Override
    public Img<DoubleType> createOutput(RandomAccessibleInterval<T> input) {
        Img<DoubleType> tubeness = this.ops().create().img((Dimensions)input, new DoubleType());
        return tubeness;
    }

    @Override
    public void compute(RandomAccessibleInterval<T> input, IterableInterval<DoubleType> tubeness) {
        this.cancelReason = null;
        int numDimensions = input.numDimensions();
        double[] sigmas = new double[numDimensions];
        for (int d = 0; d < sigmas.length; ++d) {
            double cal = d < this.calibration.length ? this.calibration[d] : 1.0;
            sigmas[d] = this.sigma / cal;
        }
        long[] gradientDims = new long[numDimensions + 1];
        long[] hessianDims = new long[numDimensions + 1];
        for (int d = 0; d < numDimensions; ++d) {
            hessianDims[d] = input.dimension(d);
            gradientDims[d] = input.dimension(d);
        }
        hessianDims[numDimensions] = numDimensions * (numDimensions + 1) / 2;
        gradientDims[numDimensions] = numDimensions;
        FinalDimensions hessianDimensions = FinalDimensions.wrap((long[])hessianDims);
        FinalDimensions gradientDimensions = FinalDimensions.wrap((long[])gradientDims);
        ImgFactory factory = this.ops().create().imgFactory((Dimensions)hessianDimensions);
        Img hessian = factory.create((Dimensions)hessianDimensions, (Object)new DoubleType());
        Img gradient = factory.create((Dimensions)gradientDimensions, (Object)new DoubleType());
        Img gaussian = factory.create(input, (Object)new DoubleType());
        int nThreads = this.ops().getMaxThreads();
        ExecutorService es = this.threadService.getExecutorService();
        try {
            AbstractUnaryComputerOp method;
            HessianMatrix.calculateMatrix((RandomAccessible)Views.extendBorder(input), (RandomAccessibleInterval)gaussian, (RandomAccessibleInterval)gradient, (RandomAccessibleInterval)hessian, (OutOfBoundsFactory)new OutOfBoundsBorderFactory(), (int)nThreads, (ExecutorService)es, (double[])new double[]{this.sigma});
            this.statusService.showProgress(1, 3);
            if (this.isCanceled()) {
                return;
            }
            RandomAccessibleInterval evs = TensorEigenValues.calculateEigenValuesSymmetric((RandomAccessibleInterval)hessian, (RandomAccessibleInterval)TensorEigenValues.createAppropriateResultImg((RandomAccessibleInterval)hessian, factory, (RealType)new DoubleType()), (int)nThreads, (ExecutorService)es);
            this.statusService.showProgress(2, 3);
            if (this.isCanceled()) {
                return;
            }
            switch (numDimensions) {
                case 2: {
                    method = new Tubeness2D(this.sigma);
                    break;
                }
                case 3: {
                    method = new Tubeness3D(this.sigma);
                    break;
                }
                default: {
                    System.err.println("Cannot compute tubeness for " + numDimensions + "D images.");
                    return;
                }
            }
            this.ops().transform().project(tubeness, evs, method, numDimensions);
            this.statusService.showProgress(3, 3);
            return;
        }
        catch (InterruptedException | ExecutionException | IncompatibleTypeException e) {
            e.printStackTrace();
            return;
        }
    }

    public boolean isCanceled() {
        return this.cancelReason != null;
    }

    public void cancel(String reason) {
        this.cancelReason = reason == null ? "" : reason;
    }

    public String getCancelReason() {
        return this.cancelReason;
    }

    private static final class Tubeness3D
    extends AbstractUnaryComputerOp<Iterable<DoubleType>, DoubleType> {
        private final double sigma;

        public Tubeness3D(double sigma) {
            this.sigma = sigma;
        }

        @Override
        public void compute(Iterable<DoubleType> input, DoubleType output) {
            Iterator<DoubleType> it = input.iterator();
            it.next();
            double val1 = it.next().get();
            double val2 = it.next().get();
            if (val1 >= 0.0 || val2 >= 0.0) {
                output.setZero();
            } else {
                output.set(this.sigma * this.sigma * Math.sqrt(val1 * val2));
            }
        }
    }

    private static final class Tubeness2D
    extends AbstractUnaryComputerOp<Iterable<DoubleType>, DoubleType> {
        private final double sigma;

        public Tubeness2D(double sigma) {
            this.sigma = sigma;
        }

        @Override
        public void compute(Iterable<DoubleType> input, DoubleType output) {
            Iterator<DoubleType> it = input.iterator();
            it.next();
            double val = it.next().get();
            if (val >= 0.0) {
                output.setZero();
            } else {
                output.set(this.sigma * this.sigma * Math.abs(val));
            }
        }
    }
}

