/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.stats;

import net.imagej.ops.Ops;
import net.imagej.ops.special.chain.RTs;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.stats.AbstractStatsOp;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Stats.HarmonicMean.class, label="Statistics: Harmonic Mean")
public class DefaultHarmonicMean<I extends RealType<I>, O extends RealType<O>>
extends AbstractStatsOp<Iterable<I>, O>
implements Ops.Stats.HarmonicMean {
    private UnaryFunctionOp<Iterable<I>, O> sizeFunc;
    private UnaryFunctionOp<Iterable<I>, O> sumOfInversesFunc;

    @Override
    public void initialize() {
        this.sumOfInversesFunc = RTs.function(this.ops(), Ops.Stats.SumOfInverses.class, this.in(), new Object[0]);
        this.sizeFunc = RTs.function(this.ops(), Ops.Stats.Size.class, this.in(), new Object[0]);
    }

    @Override
    public void compute(Iterable<I> input, O output) {
        double area = ((RealType)this.sizeFunc.calculate(input)).getRealDouble();
        double sumOfInverses = ((RealType)this.sumOfInversesFunc.calculate(input)).getRealDouble();
        if (sumOfInverses != 0.0) {
            output.setReal(area / sumOfInverses);
        } else {
            output.setReal(0.0f);
        }
    }
}

