/*
 * Decompiled with CFR 0.152.
 */
package levelsets.algorithm;

import levelsets.algorithm.LevelSetImplementation;
import levelsets.ij.ImageContainer;
import levelsets.ij.ImageProgressContainer;
import levelsets.ij.StateContainer;

public class ActiveContours
extends LevelSetImplementation {
    protected double[][][] gradients = null;
    protected final double ADVECTION_FORCE;
    protected final double CURVATURE_EPSILON;
    protected final double GREY_TOLERANCE;

    public ActiveContours(ImageContainer image, ImageProgressContainer img_progress, StateContainer init_state, double convergence, double advection, double curvature, double grey_tol) {
        super(image, img_progress, init_state, convergence);
        this.ADVECTION_FORCE = advection;
        this.CURVATURE_EPSILON = curvature;
        this.GREY_TOLERANCE = grey_tol;
    }

    @Override
    protected final void init() {
        super.init();
        this.gradients = this.img.calculateGradients();
    }

    @Override
    protected final void cleanup() {
        super.cleanup();
        this.gradients = null;
    }

    @Override
    protected void updateDeltaT() {
        this.DELTA_T = 0.16666666666666666 / (this.CURVATURE_EPSILON * this.ADVECTION_FORCE);
    }

    @Override
    protected final double getDeltaPhi(int x, int y, int z) {
        double image_term = this.getImageTerm(x, y, z);
        double curvature = this.getCurvatureTerm(x, y, z);
        double advection = this.getAdvectionTerm(x, y, z);
        double delta_phi = -this.DELTA_T * image_term * (advection * this.ADVECTION_FORCE + curvature * this.CURVATURE_EPSILON);
        return delta_phi;
    }

    private final double getImageTerm(int x, int y, int z) {
        int greyval = this.img.getPixel(x, y, z);
        int greyval_penalty = Math.abs(greyval - this.seed_greyvalue);
        if ((double)greyval_penalty < this.GREY_TOLERANCE) {
            greyval_penalty = 0;
        }
        return 1.0 / (1.0 + (this.gradients[x][y][z] + (double)greyval_penalty) * 2.0);
    }

    protected final double getAdvectionTerm(int x, int y, int z) {
        double xB = x > 0 ? this.phi.get(x - 1, y, z) : Double.MAX_VALUE;
        double xF = x + 1 < this.phi.getXLength() ? this.phi.get(x + 1, y, z) : Double.MAX_VALUE;
        double yB = y > 0 ? this.phi.get(x, y - 1, z) : Double.MAX_VALUE;
        double yF = y + 1 < this.phi.getYLength() ? this.phi.get(x, y + 1, z) : Double.MAX_VALUE;
        double zB = z > 0 ? this.phi.get(x, y, z - 1) : Double.MAX_VALUE;
        double zF = z + 1 < this.phi.getZLength() ? this.phi.get(x, y, z + 1) : Double.MAX_VALUE;
        double cell_phi = this.phi.get(x, y, z);
        double xBdiff = Math.max(cell_phi - xB, 0.0);
        double xFdiff = Math.min(xF - cell_phi, 0.0);
        double yBdiff = Math.max(cell_phi - yB, 0.0);
        double yFdiff = Math.min(yF - cell_phi, 0.0);
        double zBdiff = Math.max((cell_phi - zB) / this.zScale, 0.0);
        double zFdiff = Math.min((zF - cell_phi) / this.zScale, 0.0);
        return Math.sqrt(xBdiff * xBdiff + xFdiff * xFdiff + yBdiff * yBdiff + yFdiff * yFdiff + zBdiff * zBdiff + zFdiff * zFdiff);
    }

    protected final double getCurvatureTerm(int x, int y, int z) {
        if (x == 0 || x >= this.phi.getXLength() - 1) {
            return 0.0;
        }
        if (y == 0 || y >= this.phi.getYLength() - 1) {
            return 0.0;
        }
        boolean curvature_3d = false;
        double cell_phi = this.phi.get(x, y, z);
        double phiXB = this.phi.get(x - 1, y, z);
        double phiXF = this.phi.get(x + 1, y, z);
        double phiYB = this.phi.get(x, y - 1, z);
        double phiYF = this.phi.get(x, y + 1, z);
        double phiX = (phiXF - phiXB) / 2.0;
        double phiY = (phiYF - phiYB) / 2.0;
        double phiXX = phiXF + phiXB - 2.0 * cell_phi;
        double phiYY = phiYF + phiYB - 2.0 * cell_phi;
        double phiXY = (this.phi.get(x + 1, y + 1, z) - this.phi.get(x + 1, y - 1, z) - this.phi.get(x - 1, y + 1, z) + this.phi.get(x - 1, y - 1, z)) / 4.0;
        double phiZ = 0.0;
        double phiZZ = 0.0;
        double phiXZ = 0.0;
        double phiYZ = 0.0;
        if (curvature_3d) {
            double phiZB = this.phi.get(x, y, z - 1);
            double phiZF = this.phi.get(x, y, z + 1);
            phiZ = (phiZF - phiZB) / 2.0;
            phiZZ = phiZF + phiZB - 2.0 * cell_phi;
            phiXZ = (this.phi.get(x + 1, y, z + 1) - this.phi.get(x + 1, y, z - 1) - this.phi.get(x - 1, y, z + 1) + this.phi.get(x - 1, y, z - 1)) / 4.0;
            phiYZ = (this.phi.get(x, y + 1, z + 1) - this.phi.get(x, y + 1, z - 1) - this.phi.get(x, y - 1, z + 1) + this.phi.get(x, y - 1, z - 1)) / 4.0;
        }
        if (phiX == 0.0 || phiY == 0.0) {
            return 0.0;
        }
        if (curvature_3d && phiZ == 0.0) {
            return 0.0;
        }
        double curvature = 0.0;
        double deltaPhi = 0.0;
        if (curvature_3d) {
            deltaPhi = Math.sqrt(phiX * phiX + phiY * phiY + phiZ * phiZ);
            curvature = -1.0 * (phiXX * (phiY * phiY + phiZ * phiZ) + phiYY * (phiX * phiX + phiZ * phiZ) + phiZZ * (phiX * phiX + phiY * phiY) - 2.0 * phiX * phiY * phiXY - 2.0 * phiX * phiZ * phiXZ - 2.0 * phiY * phiZ * phiYZ) / Math.pow(phiX * phiX + phiY * phiY + phiZ * phiZ, 1.0);
        } else {
            deltaPhi = Math.sqrt(phiX * phiX + phiY * phiY);
            curvature = -1.0 * (phiXX * phiY * phiY + phiYY * phiX * phiX - 2.0 * phiX * phiY * phiXY) / Math.pow(phiX * phiX + phiY * phiY, 1.0);
        }
        return curvature * deltaPhi;
    }
}

