/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripteditor.jython;

import java.util.ArrayList;
import java.util.List;
import org.scijava.plugins.scripteditor.jython.DefVarDotAutocompletions;
import org.scijava.plugins.scripteditor.jython.DotAutocompletions;
import org.scijava.plugins.scripteditor.jython.JythonDev;
import org.scijava.plugins.scripteditor.jython.Scope;
import org.scijava.ui.swing.script.autocompletion.CompletionText;

public class ClassDotAutocompletions
extends DefVarDotAutocompletions {
    final List<String> superclassNames;
    final List<CompletionText> dotAutocompletions;

    public ClassDotAutocompletions(String fnName, List<String> superclassNames, List<String> argumentNames, List<CompletionText> dotAutocompletions, Scope class_scope) {
        super(fnName, null, argumentNames, class_scope);
        this.superclassNames = superclassNames;
        this.dotAutocompletions = dotAutocompletions;
    }

    @Override
    public List<CompletionText> get() {
        ArrayList<CompletionText> ac = new ArrayList<CompletionText>(this.dotAutocompletions);
        for (String className : this.superclassNames) {
            List<CompletionText> fm = DotAutocompletions.getPublicFieldsAndMethods(className);
            if (fm.isEmpty()) {
                JythonDev.print("Don't know yet how to handle class " + className);
            }
            ac.addAll(fm);
        }
        return ac;
    }

    public void put(CompletionText entry) {
        if (this.dotAutocompletions.contains(entry)) {
            return;
        }
        this.dotAutocompletions.add(entry);
    }

    public void mutateIntoPlus(ClassDotAutocompletions cda) {
        this.className = cda.className;
        this.fnName = cda.fnName;
        this.superclassNames.clear();
        this.superclassNames.addAll(cda.superclassNames);
        this.dotAutocompletions.addAll(cda.dotAutocompletions);
        this.argumentNames.clear();
        this.argumentNames.addAll(cda.argumentNames);
        this.scope = cda.scope;
    }

    @Override
    public String toString() {
        return "ClassDotAutocompletions: " + this.fnName + "(" + String.join((CharSequence)", ", this.argumentNames) + ") -- " + String.join((CharSequence)", ", this.get().toString());
    }
}

