/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.Map;
import org.knowm.xchart.PieSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.PlotContent_;
import org.knowm.xchart.style.PieStyler;
import org.knowm.xchart.style.Styler;

public class PlotContent_Pie<ST extends PieStyler, S extends PieSeries>
extends PlotContent_<ST, S> {
    private final ST pieStyler;
    private final DecimalFormat df = new DecimalFormat("#.0");

    PlotContent_Pie(Chart<ST, S> chart) {
        super(chart);
        this.pieStyler = (PieStyler)chart.getStyler();
    }

    public static Shape getDonutSliceShape(Rectangle2D pieBounds, double thickness, double start, double extent) {
        thickness /= 2.0;
        GeneralPath generalPath = new GeneralPath();
        GeneralPath dummy = new GeneralPath();
        double x = pieBounds.getX();
        double y = pieBounds.getY();
        double width = pieBounds.getWidth();
        double height = pieBounds.getHeight();
        Arc2D.Double outer = new Arc2D.Double(x, y, width, height, start, extent, 0);
        double wt = width * thickness;
        double ht = height * thickness;
        Arc2D.Double inner = new Arc2D.Double(x + wt, y + ht, width - 2.0 * wt, height - 2.0 * ht, start + extent, -extent, 0);
        generalPath.append(outer, false);
        dummy.append(new Arc2D.Double(x + wt, y + ht, width - 2.0 * wt, height - 2.0 * ht, start, extent, 0), false);
        Point2D point = dummy.getCurrentPoint();
        if (point != null) {
            generalPath.lineTo(point.getX(), point.getY());
        }
        generalPath.append(inner, false);
        dummy.append(new Arc2D.Double(x, y, width, height, start + extent, -extent, 0), false);
        point = dummy.getCurrentPoint();
        if (point != null) {
            generalPath.lineTo(point.getX(), point.getY());
        }
        return generalPath;
    }

    @Override
    public void doPaint(Graphics2D g) {
        double pieFillPercentage = ((Styler)this.pieStyler).getPlotContentSize();
        double halfBorderPercentage = (1.0 - pieFillPercentage) / 2.0;
        double width = ((PieStyler)this.pieStyler).isCircular() ? Math.min(this.getBounds().getWidth(), this.getBounds().getHeight()) : this.getBounds().getWidth();
        double height = ((PieStyler)this.pieStyler).isCircular() ? Math.min(this.getBounds().getWidth(), this.getBounds().getHeight()) : this.getBounds().getHeight();
        Rectangle2D.Double pieBounds = new Rectangle2D.Double(this.getBounds().getX() + this.getBounds().getWidth() / 2.0 - width / 2.0 + halfBorderPercentage * width, this.getBounds().getY() + this.getBounds().getHeight() / 2.0 - height / 2.0 + halfBorderPercentage * height, width * pieFillPercentage, height * pieFillPercentage);
        double total = 0.0;
        Map map = this.chart.getSeriesMap();
        for (PieSeries series : map.values()) {
            if (!series.isEnabled()) continue;
            total += series.getValue().doubleValue();
        }
        double startAngle = ((PieStyler)this.pieStyler).getStartAngleInDegrees() + 90.0;
        this.paintSlices(g, pieBounds, total, startAngle);
        this.paintAnnotations(g, pieBounds, total, startAngle);
        this.paintSum(g, pieBounds, total);
    }

    private void paintSlices(Graphics2D g, Rectangle2D pieBounds, double total, double startAngle) {
        boolean toolTipsEnabled = ((PieStyler)this.chart.getStyler()).isToolTipsEnabled();
        Map map = this.chart.getSeriesMap();
        for (PieSeries series : map.values()) {
            Shape labelShape;
            if (!series.isEnabled()) continue;
            Number y = series.getValue();
            double arcAngle = y.doubleValue() * 360.0 / total;
            g.setColor(series.getFillColor());
            if (PieSeries.PieSeriesRenderStyle.Pie == series.getChartPieSeriesRenderStyle()) {
                Arc2D.Double pieShape = new Arc2D.Double(pieBounds.getX(), pieBounds.getY(), pieBounds.getWidth(), pieBounds.getHeight(), startAngle, arcAngle, 2);
                g.fill(pieShape);
                g.setColor(((Styler)this.pieStyler).getPlotBackgroundColor());
                g.draw(pieShape);
                labelShape = pieShape;
            } else {
                Shape donutSlice = PlotContent_Pie.getDonutSliceShape(pieBounds, ((PieStyler)this.pieStyler).getDonutThickness(), startAngle, arcAngle);
                g.fill(donutSlice);
                g.setColor(((Styler)this.pieStyler).getPlotBackgroundColor());
                g.draw(donutSlice);
                labelShape = donutSlice;
            }
            String annotation = series.getName() + " (" + this.df.format(y) + ")";
            double xCenter = pieBounds.getX() + pieBounds.getWidth() / 2.0;
            double yCenter = pieBounds.getY() + pieBounds.getHeight() / 2.0;
            double angle = arcAngle + startAngle - arcAngle / 2.0;
            double xOffset = xCenter + Math.cos(Math.toRadians(angle)) * (pieBounds.getWidth() / 2.0 * ((PieStyler)this.pieStyler).getAnnotationDistance());
            double yOffset = yCenter - Math.sin(Math.toRadians(angle)) * (pieBounds.getHeight() / 2.0 * ((PieStyler)this.pieStyler).getAnnotationDistance());
            if (toolTipsEnabled) {
                String tt = series.getToolTip();
                if (tt != null) {
                    this.chart.toolTips.addData(labelShape, xOffset, yOffset + 10.0, 0.0, tt);
                } else {
                    this.chart.toolTips.addData(labelShape, xOffset, yOffset + 10.0, 0.0, annotation);
                }
            }
            startAngle += arcAngle;
        }
    }

    private void paintAnnotations(Graphics2D g, Rectangle2D pieBounds, double total, double startAngle) {
        Map map = this.chart.getSeriesMap();
        for (PieSeries series : map.values()) {
            if (!series.isEnabled()) continue;
            Number y = series.getValue();
            double arcAngle = y.doubleValue() * 360.0 / total;
            if (((Styler)this.pieStyler).hasAnnotations().booleanValue()) {
                DecimalFormat df;
                String annotation = "";
                if (((PieStyler)this.pieStyler).getAnnotationType() == PieStyler.AnnotationType.Value) {
                    if (((Styler)this.pieStyler).getDecimalPattern() != null) {
                        df = new DecimalFormat(((Styler)this.pieStyler).getDecimalPattern());
                        annotation = df.format(y);
                    } else {
                        annotation = y.toString();
                    }
                } else if (((PieStyler)this.pieStyler).getAnnotationType() == PieStyler.AnnotationType.Label) {
                    annotation = series.getName();
                } else if (((PieStyler)this.pieStyler).getAnnotationType() == PieStyler.AnnotationType.LabelAndPercentage) {
                    double percentage = y.doubleValue() / total * 100.0;
                    annotation = series.getName() + " (" + this.df.format(percentage) + "%)";
                } else if (((PieStyler)this.pieStyler).getAnnotationType() == PieStyler.AnnotationType.Percentage) {
                    double percentage = y.doubleValue() / total * 100.0;
                    annotation = this.df.format(percentage) + "%";
                } else if (((PieStyler)this.pieStyler).getAnnotationType() == PieStyler.AnnotationType.LabelAndValue) {
                    if (((Styler)this.pieStyler).getDecimalPattern() != null) {
                        df = new DecimalFormat(((Styler)this.pieStyler).getDecimalPattern());
                        annotation = series.getName() + " (" + df.format(y) + ")";
                    } else {
                        annotation = series.getName() + " (" + y.toString() + ")";
                    }
                }
                TextLayout textLayout = new TextLayout(annotation, ((Styler)this.pieStyler).getAnnotationsFont(), new FontRenderContext(null, true, false));
                Rectangle2D annotationRectangle = textLayout.getBounds();
                double xCenter = pieBounds.getX() + pieBounds.getWidth() / 2.0 - annotationRectangle.getWidth() / 2.0;
                double yCenter = pieBounds.getY() + pieBounds.getHeight() / 2.0 + annotationRectangle.getHeight() / 2.0;
                double angle = arcAngle + startAngle - arcAngle / 2.0;
                double xOffset = xCenter + Math.cos(Math.toRadians(angle)) * (pieBounds.getWidth() / 2.0 * ((PieStyler)this.pieStyler).getAnnotationDistance());
                double yOffset = yCenter - Math.sin(Math.toRadians(angle)) * (pieBounds.getHeight() / 2.0 * ((PieStyler)this.pieStyler).getAnnotationDistance());
                Shape shape = textLayout.getOutline(null);
                Rectangle2D annotationBounds = shape.getBounds2D();
                double annotationWidth = annotationBounds.getWidth();
                double annotationHeight = annotationBounds.getHeight();
                double xOffset1 = xCenter + Math.cos(Math.toRadians(startAngle)) * (pieBounds.getWidth() / 2.0 * ((PieStyler)this.pieStyler).getAnnotationDistance());
                double yOffset1 = yCenter - Math.sin(Math.toRadians(startAngle)) * (pieBounds.getHeight() / 2.0 * ((PieStyler)this.pieStyler).getAnnotationDistance());
                double xOffset2 = xCenter + Math.cos(Math.toRadians(arcAngle + startAngle)) * (pieBounds.getWidth() / 2.0 * ((PieStyler)this.pieStyler).getAnnotationDistance());
                double yOffset2 = yCenter - Math.sin(Math.toRadians(arcAngle + startAngle)) * (pieBounds.getHeight() / 2.0 * ((PieStyler)this.pieStyler).getAnnotationDistance());
                double xDiff = Math.abs(xOffset1 - xOffset2);
                double yDiff = Math.abs(yOffset1 - yOffset2);
                boolean annotationWillFit = false;
                if (xDiff >= yDiff) {
                    if (annotationWidth < xDiff) {
                        annotationWillFit = true;
                    }
                } else if (xDiff <= yDiff && annotationHeight < yDiff) {
                    annotationWillFit = true;
                }
                if (((PieStyler)this.pieStyler).isDrawAllAnnotations() || annotationWillFit) {
                    g.setColor(((Styler)this.pieStyler).getChartFontColor());
                    g.setFont(((Styler)this.pieStyler).getAnnotationsFont());
                    AffineTransform orig = g.getTransform();
                    AffineTransform at = new AffineTransform();
                    if (((PieStyler)this.pieStyler).getAnnotationDistance() <= 1.0) {
                        at.translate(xOffset, yOffset);
                    } else {
                        xCenter = pieBounds.getX() + pieBounds.getWidth() / 2.0;
                        yCenter = pieBounds.getY() + pieBounds.getHeight() / 2.0;
                        double endPoint = 3.0 - ((PieStyler)this.pieStyler).getAnnotationDistance();
                        double xOffsetStart = xCenter + Math.cos(Math.toRadians(angle)) * (pieBounds.getWidth() / 2.01);
                        double xOffsetEnd = xCenter + Math.cos(Math.toRadians(angle)) * (pieBounds.getWidth() / endPoint);
                        double yOffsetStart = yCenter - Math.sin(Math.toRadians(angle)) * (pieBounds.getHeight() / 2.01);
                        double yOffsetEnd = yCenter - Math.sin(Math.toRadians(angle)) * (pieBounds.getHeight() / endPoint);
                        g.setStroke(new BasicStroke(2.0f, 0, 0));
                        Line2D.Double line = new Line2D.Double(xOffsetStart, yOffsetStart, xOffsetEnd, yOffsetEnd);
                        g.draw(line);
                        at.translate(xOffset - Math.sin(Math.toRadians(angle - 90.0)) * annotationWidth / 2.0 + 3.0, yOffset);
                    }
                    g.transform(at);
                    g.fill(shape);
                    g.setTransform(orig);
                }
            }
            startAngle += arcAngle;
        }
    }

    private void paintSum(Graphics2D g, Rectangle2D pieBounds, double total) {
        if (((PieStyler)this.pieStyler).isSumVisible()) {
            DecimalFormat totalDf = ((Styler)this.pieStyler).getDecimalPattern() == null ? this.df : new DecimalFormat(((Styler)this.pieStyler).getDecimalPattern());
            String annotation = totalDf.format(total);
            TextLayout textLayout = new TextLayout(annotation, ((PieStyler)this.pieStyler).getSumFont(), new FontRenderContext(null, true, false));
            Shape shape = textLayout.getOutline(null);
            g.setColor(((Styler)this.pieStyler).getChartFontColor());
            Rectangle2D annotationRectangle = textLayout.getBounds();
            double xCenter = pieBounds.getX() + pieBounds.getWidth() / 2.0 - annotationRectangle.getWidth() / 2.0;
            double yCenter = pieBounds.getY() + pieBounds.getHeight() / 2.0 + annotationRectangle.getHeight() / 2.0;
            AffineTransform orig = g.getTransform();
            AffineTransform at = new AffineTransform();
            at.translate(xCenter, yCenter);
            g.transform(at);
            g.fill(shape);
            g.setTransform(orig);
        }
    }
}

