/*
 * Decompiled with CFR 0.152.
 */
import ij.gui.GenericDialog;
import java.awt.Color;
import mpicbg.ij.InteractiveMapping;
import mpicbg.ij.TransformMeshMapping;
import mpicbg.models.AbstractModel;
import mpicbg.models.AffineModel2D;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.InvertibleCoordinateTransform;
import mpicbg.models.MovingLeastSquaresMesh;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.RigidModel2D;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.TranslationModel2D;

public class Transform_MovingLeastSquaresMesh
extends InteractiveMapping {
    public static final String NL = System.getProperty("line.separator");
    public static final String man = "Add some control points with your mouse" + NL + "and drag them to deform the image." + NL + " " + NL + "ENTER - Apply the deformation." + NL + "ESC - Return to the original image." + NL + "U - Toggle mesh display.";
    private static int numX = 32;
    private static float alpha = 1.0f;
    private static final String[] methods = new String[]{"Translation", "Rigid", "Similarity", "Affine"};
    private static int method = 1;
    protected MovingLeastSquaresMesh<? extends AbstractModel<?>> mesh;

    protected final void createMapping() {
        this.mapping = new TransformMeshMapping(this.mesh);
    }

    protected final void updateMapping() throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        this.mesh.updateModels();
        this.mesh.updateAffines();
        this.updateIllustration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addHandle(int x, int y) {
        double[] l = new double[]{x, y};
        MovingLeastSquaresMesh<? extends AbstractModel<?>> movingLeastSquaresMesh = this.mesh;
        synchronized (movingLeastSquaresMesh) {
            InvertibleCoordinateTransform ict = (InvertibleCoordinateTransform)this.mesh.findClosest(l).getModel();
            try {
                ict.applyInverseInPlace(l);
                Point here = new Point(l);
                Point there = new Point(l);
                this.hooks.add(here);
                here.apply((CoordinateTransform)ict);
                this.mesh.addMatchWeightedByDistance(new PointMatch(there, here, 10.0), (double)alpha);
            }
            catch (NoninvertibleModelException e) {
                e.printStackTrace();
            }
        }
    }

    protected final void updateHandles(int x, int y) {
        double[] l = ((Point)this.hooks.get(this.targetIndex)).getW();
        l[0] = x;
        l[1] = y;
    }

    public final void init() {
        GenericDialog gd = new GenericDialog("Moving Least Squares Transform");
        gd.addNumericField("Vertices_per_row :", (double)numX, 0);
        gd.addNumericField("Alpha :", (double)alpha, 2);
        gd.addChoice("Local_transformation :", methods, methods[method]);
        gd.addCheckbox("_Interactive_preview", showPreview);
        gd.addMessage(man);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        numX = (int)gd.getNextNumber();
        alpha = (float)gd.getNextNumber();
        method = gd.getNextChoiceIndex();
        showPreview = gd.getNextBoolean();
        switch (method) {
            case 0: {
                this.mesh = new MovingLeastSquaresMesh(TranslationModel2D.class, numX, (double)this.imp.getWidth(), (double)this.imp.getHeight());
                break;
            }
            case 1: {
                this.mesh = new MovingLeastSquaresMesh(RigidModel2D.class, numX, (double)this.imp.getWidth(), (double)this.imp.getHeight());
                break;
            }
            case 2: {
                this.mesh = new MovingLeastSquaresMesh(SimilarityModel2D.class, numX, (double)this.imp.getWidth(), (double)this.imp.getHeight());
                break;
            }
            case 3: {
                this.mesh = new MovingLeastSquaresMesh(AffineModel2D.class, numX, (double)this.imp.getWidth(), (double)this.imp.getHeight());
                break;
            }
            default: {
                return;
            }
        }
    }

    protected final void updateIllustration() {
        if (showIllustration) {
            this.imp.setOverlay(this.mesh.illustrateMesh(), Color.white, null);
        } else {
            this.imp.setOverlay(null);
        }
    }
}

