/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.util;

import edu.utexas.clm.archipelago.util.EasyLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicBoolean;

public class InputStreamLogger
extends Thread {
    public InputStream inputStream = null;
    public final AtomicBoolean running;
    public EasyLogger logger;

    public InputStreamLogger(EasyLogger el) {
        this.logger = el;
        this.running = new AtomicBoolean(true);
    }

    public void setStream(InputStream is) {
        this.inputStream = is;
    }

    @Override
    public void run() {
        if (this.inputStream != null) {
            BufferedReader bufferedIn = new BufferedReader(new InputStreamReader(this.inputStream));
            while (this.running.get()) {
                try {
                    this.logger.log(bufferedIn.readLine());
                }
                catch (IOException ioe) {
                    this.logger.log("Got IOException while reading stream: " + ioe);
                }
            }
        } else {
            this.logger.log("Tried to run stream logger against null stream");
        }
    }

    public void close() {
        this.running.set(false);
    }
}

