/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.omevisual.gui.view;

import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import loci.formats.ome.OMEXMLMetadata;
import net.imagej.axis.AxisType;
import net.imagej.display.ImageDisplay;
import org.scijava.Context;
import org.scijava.convert.ConvertService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import sc.fiji.omevisual.OMEUtils;
import sc.fiji.omevisual.gui.model.GenericModel;
import sc.fiji.omevisual.gui.model.ImageModel;
import sc.fiji.omevisual.gui.model.TiffDataModel;

public class RootLayoutController
implements Initializable {
    @Parameter
    private LogService log;
    @Parameter
    private ConvertService convert;
    @FXML
    private TreeView testTree;
    @FXML
    private CheckBox syncWithImageBox;
    @FXML
    private TableView<List<String>> imageTable;
    @FXML
    private TableColumn<List<String>, String> imageNameColumn;
    @FXML
    private TableColumn<List<String>, String> imageValueColumn;
    @FXML
    private TableView<List<String>> tiffDataTable;
    @FXML
    private TableColumn<List<String>, String> tiffDataNameColumn;
    @FXML
    private TableColumn<List<String>, String> tiffDataValueColumn;
    private ImageDisplay image;

    public void initialize(URL location, ResourceBundle resources) {
    }

    public void setContext(Context context) {
        context.inject((Object)this);
    }

    public void setImage(ImageDisplay image) {
        this.image = image;
    }

    public void fill(OMEXMLMetadata md) {
        TreeItem root = new TreeItem();
        this.testTree.setRoot(root);
        this.testTree.setShowRoot(false);
        for (int i = 0; i < md.getImageCount(); ++i) {
            ImageModel imageModel = new ImageModel(i, md);
            TreeItem imageItem = new TreeItem((Object)imageModel);
            root.getChildren().add((Object)imageItem);
            for (int j = 0; j < md.getTiffDataCount(i); ++j) {
                TiffDataModel dataModel = new TiffDataModel(i, j, md, imageModel);
                TreeItem dataItem = new TreeItem((Object)dataModel);
                imageItem.getChildren().add((Object)dataItem);
            }
        }
        this.testTree.getSelectionModel().selectedItemProperty().addListener((obs, oldValue, newValue) -> {
            TreeItem selectedItem = (TreeItem)newValue;
            GenericModel model = (GenericModel)selectedItem.getValue();
            if (model instanceof TiffDataModel) {
                this.populateTiffDataInformations((TiffDataModel)model);
            }
            if (model instanceof ImageModel) {
                this.tiffDataTable.getItems().clear();
                this.populateImageInformations((ImageModel)model);
            }
            if (this.syncWithImageBox.isSelected() && model instanceof TiffDataModel) {
                Map<AxisType, Long> positions = ((TiffDataModel)model).getPosition();
                OMEUtils.setPosition(this.image, positions, this.convert);
            }
        });
    }

    private void populateImageInformations(ImageModel model) {
        this.imageTable.getItems().clear();
        this.imageNameColumn.setCellValueFactory(data -> new ReadOnlyStringWrapper((String)((List)data.getValue()).get(0)));
        this.imageValueColumn.setCellValueFactory(data -> new ReadOnlyStringWrapper((String)((List)data.getValue()).get(1)));
        for (List<String> row : model.getInformationsRow()) {
            this.imageTable.getItems().add(row);
        }
    }

    private void populateTiffDataInformations(TiffDataModel model) {
        ImageModel imageModel = model.getImageModel();
        this.populateImageInformations(imageModel);
        this.tiffDataTable.getItems().clear();
        this.tiffDataNameColumn.setCellValueFactory(data -> new ReadOnlyStringWrapper((String)((List)data.getValue()).get(0)));
        this.tiffDataValueColumn.setCellValueFactory(data -> new ReadOnlyStringWrapper((String)((List)data.getValue()).get(1)));
        for (List<String> row : model.getInformationsRow()) {
            this.tiffDataTable.getItems().add(row);
        }
    }
}

