/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.blocks;

import java.util.Iterator;
import java.util.List;
import net.imglib2.RandomAccess;
import net.imglib2.blocks.MemCopy;
import net.imglib2.blocks.RangeCopier;
import net.imglib2.blocks.Ranges;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.cell.AbstractCellImg;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;

class CellImgRangeCopier<S, T>
implements RangeCopier<T> {
    private final int n;
    private final CellGrid cellGrid;
    private final RandomAccess<? extends Cell<?>> cellAccess;
    private final long[] srcDims;
    private final Ranges findRanges;
    private final MemCopy<S, T> memCopy;
    private final S oob;
    private final List<Ranges.Range>[] rangesPerDimension;
    private final Ranges.Range[] ranges;
    private final int[] dsteps;
    private final int[] doffsets;
    private final int[] cdims;
    private final int[] csteps;
    private final int[] lengths;

    public CellImgRangeCopier(AbstractCellImg<?, ?, ?, ?> cellImg, Ranges findRanges, MemCopy<S, T> memCopy, S oob) {
        this.n = cellImg.numDimensions();
        this.cellGrid = cellImg.getCellGrid();
        this.cellAccess = cellImg.getCells().randomAccess();
        this.srcDims = cellImg.dimensionsAsLongArray();
        this.findRanges = findRanges;
        this.memCopy = memCopy;
        this.oob = oob;
        this.rangesPerDimension = new List[this.n];
        this.ranges = new Ranges.Range[this.n];
        this.dsteps = new int[this.n];
        this.doffsets = new int[this.n + 1];
        this.cdims = new int[this.n];
        this.csteps = new int[this.n];
        this.lengths = new int[this.n];
    }

    private CellImgRangeCopier(CellImgRangeCopier<S, T> copier) {
        this.n = copier.n;
        this.cellGrid = copier.cellGrid;
        this.cellAccess = copier.cellAccess.copy();
        this.srcDims = (long[])copier.srcDims.clone();
        this.findRanges = copier.findRanges;
        this.memCopy = copier.memCopy;
        this.oob = copier.oob;
        this.rangesPerDimension = new List[this.n];
        this.ranges = new Ranges.Range[this.n];
        this.dsteps = new int[this.n];
        this.doffsets = new int[this.n + 1];
        this.cdims = new int[this.n];
        this.csteps = new int[this.n];
        this.lengths = new int[this.n];
    }

    public CellImgRangeCopier<S, T> newInstance() {
        return new CellImgRangeCopier<S, T>(this);
    }

    @Override
    public void copy(long[] srcPos, T dest, int[] size) {
        for (int d = 0; d < this.n; ++d) {
            this.rangesPerDimension[d] = this.findRanges.findRanges(srcPos[d], size[d], this.srcDims[d], this.cellGrid.cellDimension(d));
        }
        this.setupDestSize(size);
        this.copy(dest, this.n - 1);
    }

    private void copy(T dest, int d) {
        Iterator<Ranges.Range> iterator = this.rangesPerDimension[d].iterator();
        while (iterator.hasNext()) {
            Ranges.Range range;
            this.ranges[d] = range = iterator.next();
            this.updateRange(d);
            if (range.dir == Ranges.Direction.CONSTANT) {
                this.fillRanges(dest, d);
                continue;
            }
            if (d > 0) {
                this.copy(dest, d - 1);
                continue;
            }
            this.copyRanges(dest);
        }
    }

    private void setupDestSize(int[] size) {
        this.dsteps[0] = 1;
        for (int d = 0; d < this.n - 1; ++d) {
            this.dsteps[d + 1] = this.dsteps[d] * size[d];
        }
    }

    private void updateRange(int d) {
        Ranges.Range r = this.ranges[d];
        this.cellAccess.setPosition(r.gridx, d);
        this.lengths[d] = r.w;
        this.doffsets[d] = this.doffsets[d + 1] + this.dsteps[d] * r.x;
        this.cdims[d] = this.cellGrid.getCellDimension(d, r.gridx);
    }

    private void copyRanges(T dest) {
        this.csteps[0] = 1;
        for (int d = 0; d < this.n - 1; ++d) {
            this.csteps[d + 1] = this.csteps[d] * this.cdims[d];
        }
        int sOffset = 0;
        block5: for (int d = 0; d < this.n; ++d) {
            Ranges.Range r = this.ranges[d];
            sOffset += this.csteps[d] * r.cellx;
            switch (r.dir) {
                case BACKWARD: {
                    this.csteps[d] = -this.csteps[d];
                    continue block5;
                }
                case STAY: {
                    this.csteps[d] = 0;
                }
            }
        }
        int dOffset = this.doffsets[0];
        Object src = ((ArrayDataAccess)((Cell)this.cellAccess.get()).getData()).getCurrentStorageArray();
        if (this.n > 1) {
            this.copyRangesRecursively(src, sOffset, dest, dOffset, this.n - 1);
        } else {
            int l0 = this.lengths[0];
            int cstep0 = this.csteps[0];
            this.memCopy.copyLines(cstep0, l0, 1, src, sOffset, 0, dest, dOffset, 0);
        }
    }

    private void copyRangesRecursively(S src, int srcPos, T dest, int destPos, int d) {
        int length = this.lengths[d];
        int cstep = this.csteps[d];
        int dstep = this.dsteps[d];
        if (d > 1) {
            for (int i = 0; i < length; ++i) {
                this.copyRangesRecursively(src, srcPos + i * cstep, dest, destPos + i * dstep, d - 1);
            }
        } else {
            int l0 = this.lengths[0];
            int cstep0 = this.csteps[0];
            this.memCopy.copyLines(cstep0, l0, length, src, srcPos, cstep, dest, destPos, dstep);
        }
    }

    void fillRanges(T dest, int dConst) {
        int dOffset = this.doffsets[dConst];
        int n = dConst;
        this.lengths[n] = this.lengths[n] * this.dsteps[dConst];
        if (this.n - 1 > dConst) {
            this.fillRangesRecursively(dest, dOffset, this.n - 1, dConst);
        } else {
            this.memCopy.copyValue(this.oob, 0, dest, dOffset, this.lengths[dConst]);
        }
    }

    private void fillRangesRecursively(T dest, int destPos, int d, int dConst) {
        int length = this.lengths[d];
        int dstep = this.dsteps[d];
        if (d > dConst + 1) {
            for (int i = 0; i < length; ++i) {
                this.fillRangesRecursively(dest, destPos + i * dstep, d - 1, dConst);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                this.memCopy.copyValue(this.oob, 0, dest, destPos + i * dstep, this.lengths[dConst]);
            }
        }
    }
}

