/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.blocks;

import net.imglib2.blocks.MemCopy;
import net.imglib2.transform.integer.MixedTransform;

class PermuteInvert {
    private final MemCopy memCopy;
    private final int n;
    private final int[] scomp;
    private final boolean[] sinv;
    private final int[] ssize;
    private final int[] ssteps;
    private final int[] tsteps;
    private final int[] csteps;
    private int cstart;

    public PermuteInvert(MemCopy memCopy, MixedTransform transform) {
        this.memCopy = memCopy;
        this.n = transform.numSourceDimensions();
        this.scomp = new int[this.n];
        this.sinv = new boolean[this.n];
        transform.getComponentMapping(this.scomp);
        transform.getComponentInversion(this.sinv);
        this.ssize = new int[this.n];
        this.ssteps = new int[this.n];
        this.tsteps = new int[this.n];
        this.csteps = new int[this.n];
    }

    public void permuteAndInvert(Object src, Object dest, int[] destSize) {
        int d;
        int[] tsize = destSize;
        for (d = 0; d < this.n; ++d) {
            this.ssize[d] = tsize[this.scomp[d]];
        }
        this.ssteps[0] = 1;
        for (d = 0; d < this.n - 1; ++d) {
            this.ssteps[d + 1] = this.ssteps[d] * this.ssize[d];
        }
        this.tsteps[0] = 1;
        for (d = 0; d < this.n - 1; ++d) {
            this.tsteps[d + 1] = this.tsteps[d] * tsize[d];
        }
        this.cstart = 0;
        for (d = 0; d < this.n; ++d) {
            int c = this.scomp[d];
            this.csteps[d] = this.sinv[d] ? -this.tsteps[c] : this.tsteps[c];
            this.cstart += this.sinv[d] ? (tsize[c] - 1) * this.tsteps[c] : 0;
        }
        this.copyRecursively(src, 0, dest, this.cstart, this.n - 1);
    }

    private void copyRecursively(Object src, int srcPos, Object dest, int destPos, int d) {
        if (d == 0) {
            int length = this.ssize[d];
            int stride = this.csteps[d];
            this.memCopy.copyStrided(src, srcPos, dest, destPos, stride, length);
        } else {
            int length = this.ssize[d];
            int srcStride = this.ssteps[d];
            int destStride = this.csteps[d];
            for (int i = 0; i < length; ++i) {
                this.copyRecursively(src, srcPos + i * srcStride, dest, destPos + i * destStride, d - 1);
            }
        }
    }

    private PermuteInvert(PermuteInvert copier) {
        this.memCopy = copier.memCopy;
        this.n = copier.n;
        this.scomp = copier.scomp;
        this.sinv = copier.sinv;
        this.ssize = new int[this.n];
        this.ssteps = new int[this.n];
        this.tsteps = new int[this.n];
        this.csteps = new int[this.n];
    }

    PermuteInvert newInstance() {
        return new PermuteInvert(this);
    }
}

