/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.planar;

import java.util.function.Consumer;
import net.imglib2.Positionable;
import net.imglib2.RealPositionable;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.stream.LocalizableSpliterator;
import net.imglib2.type.Index;
import net.imglib2.type.NativeType;

class PlanarSpliterator<T extends NativeType<T>>
implements LocalizableSpliterator<T>,
PlanarImg.PlanarContainerSampler {
    private final PlanarImg<T, ?> img;
    private final T type;
    private final long elementsPerSlice;
    private final int lastSlice;
    private final int lastIndexInSlice;
    private final int lastIndexInLastSlice;
    private int slice;
    private final Index index;
    private final int[] tmp;

    PlanarSpliterator(PlanarImg<T, ?> img, long origin, long fence) {
        this.img = img;
        this.type = img.createLinkedType();
        this.elementsPerSlice = img.elementsPerSlice;
        long last = fence - 1L;
        this.lastSlice = (int)(last / this.elementsPerSlice);
        this.lastIndexInSlice = img.elementsPerSlice - 1;
        this.lastIndexInLastSlice = (int)(last - (long)this.lastSlice * this.elementsPerSlice);
        this.index = this.type.index();
        this.slice = (int)(origin / this.elementsPerSlice);
        this.index.set((int)(origin - (long)this.slice * this.elementsPerSlice));
        this.index.dec();
        this.type.updateContainer(this);
        this.tmp = new int[img.numDimensions()];
    }

    private PlanarSpliterator(PlanarSpliterator<T> o) {
        this.img = o.img;
        this.type = this.img.createLinkedType();
        this.elementsPerSlice = o.elementsPerSlice;
        this.lastSlice = o.lastSlice;
        this.lastIndexInSlice = o.lastIndexInSlice;
        this.lastIndexInLastSlice = o.lastIndexInLastSlice;
        this.slice = o.slice;
        this.index = this.type.index();
        this.index.set(o.index.get());
        this.type.updateContainer(this);
        this.tmp = new int[this.img.numDimensions()];
    }

    @Override
    public int getCurrentSliceIndex() {
        return this.slice;
    }

    @Override
    public int numDimensions() {
        return this.img.numDimensions();
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.slice >= this.lastSlice && this.index.get() >= this.lastIndexInLastSlice) {
            return false;
        }
        if (this.index.get() < this.lastIndexInSlice) {
            this.index.inc();
        } else {
            this.index.set(0);
            ++this.slice;
            this.type.updateContainer(this);
        }
        action.accept(this.type);
        return true;
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        while (this.slice < this.lastSlice) {
            this.forEachRemainingInSlice(action);
            this.index.set(-1);
            ++this.slice;
            this.type.updateContainer(this);
        }
        this.forEachRemainingInSlice(action);
    }

    private void forEachRemainingInSlice(Consumer<? super T> action) {
        int len = (this.slice == this.lastSlice ? this.lastIndexInLastSlice : this.lastIndexInSlice) - this.index.get();
        for (int i = 0; i < len; ++i) {
            this.index.inc();
            action.accept(this.type);
        }
    }

    private long globalIndex(int slice, int index) {
        return (long)slice * this.elementsPerSlice + (long)index;
    }

    @Override
    public PlanarSpliterator<T> trySplit() {
        long mid;
        long lo = this.globalIndex(this.slice, this.index.get()) + 1L;
        if (lo >= (mid = lo + this.globalIndex(this.lastSlice, this.lastIndexInLastSlice) + 1L >>> 1)) {
            return null;
        }
        PlanarSpliterator<T> prefix = new PlanarSpliterator<T>(this.img, lo, mid);
        this.slice = (int)(mid / this.elementsPerSlice);
        this.index.set((int)(mid - 1L - (long)this.slice * this.elementsPerSlice));
        this.type.updateContainer(this);
        return prefix;
    }

    @Override
    public long estimateSize() {
        return (long)(this.lastSlice - this.slice) * this.elementsPerSlice + (long)this.lastIndexInLastSlice - (long)this.index.get();
    }

    @Override
    public int characteristics() {
        return 17744;
    }

    @Override
    public PlanarSpliterator<T> copy() {
        return new PlanarSpliterator<T>(this);
    }

    @Override
    public T get() {
        return this.type;
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public void localize(int[] pos) {
        this.img.indexToGlobalPosition(this.slice, this.index.get(), pos);
    }

    @Override
    public int getIntPosition(int d) {
        return this.img.indexToGlobalPosition(this.slice, this.index.get(), d);
    }

    @Override
    public void localize(float[] pos) {
        this.localize(this.tmp);
        for (int d = 0; d < this.tmp.length; ++d) {
            pos[d] = this.tmp[d];
        }
    }

    @Override
    public void localize(double[] pos) {
        this.localize(this.tmp);
        for (int d = 0; d < this.tmp.length; ++d) {
            pos[d] = this.tmp[d];
        }
    }

    @Override
    public void localize(Positionable position) {
        this.localize(this.tmp);
        position.setPosition(this.tmp);
    }

    @Override
    public void localize(RealPositionable position) {
        this.localize(this.tmp);
        position.setPosition(this.tmp);
    }

    @Override
    public void localize(long[] pos) {
        this.localize(this.tmp);
        for (int d = 0; d < this.tmp.length; ++d) {
            pos[d] = this.tmp[d];
        }
    }

    @Override
    public float getFloatPosition(int d) {
        return this.getIntPosition(d);
    }

    @Override
    public double getDoublePosition(int d) {
        return this.getIntPosition(d);
    }

    @Override
    public long getLongPosition(int d) {
        return this.getIntPosition(d);
    }
}

