/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.pointdescriptor;

import java.util.ArrayList;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.pointdescriptor.AbstractPointDescriptor;
import mpicbg.pointdescriptor.exception.NoSuitablePointsException;
import mpicbg.pointdescriptor.matcher.Matcher;
import mpicbg.pointdescriptor.model.TranslationInvariantModel;
import mpicbg.pointdescriptor.similarity.SimilarityMeasure;

public class ModelPointDescriptor<P extends Point>
extends AbstractPointDescriptor<P, ModelPointDescriptor<P>> {
    final TranslationInvariantModel<?> model;

    public ModelPointDescriptor(P basisPoint, ArrayList<P> orderedNearestNeighboringPoints, TranslationInvariantModel<?> model, SimilarityMeasure similarityMeasure, Matcher matcher) throws NoSuitablePointsException {
        super(basisPoint, orderedNearestNeighboringPoints, similarityMeasure, matcher);
        if (!model.canDoNumDimension(this.numDimensions)) {
            throw new NoSuitablePointsException(((Object)model).getClass().getName() + " does not support dim = " + this.numDimensions);
        }
        if (this.numNeighbors() < model.getMinNumMatches()) {
            throw new NoSuitablePointsException("At least " + model.getMinNumMatches() + " nearest neighbors are required for a " + ((Object)model).getClass().getName() + " : num neighbors=" + this.numNeighbors());
        }
        this.model = (TranslationInvariantModel)model.copy();
    }

    public TranslationInvariantModel<?> fitMatches(ArrayList<PointMatch> matches) {
        try {
            this.model.fit(matches);
        }
        catch (NotEnoughDataPointsException e) {
            e.printStackTrace();
        }
        catch (IllDefinedDataPointsException e) {
            e.printStackTrace();
        }
        for (PointMatch match : matches) {
            match.getP1().apply(this.model);
        }
        return this.model;
    }

    @Override
    public boolean resetWorldCoordinatesAfterMatching() {
        return true;
    }

    @Override
    public boolean useWorldCoordinatesForDescriptorBuildUp() {
        return false;
    }
}

