/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.pointdescriptor.matcher;

import java.util.ArrayList;
import mpicbg.models.PointMatch;
import mpicbg.models.RigidModel3D;
import mpicbg.pointdescriptor.matcher.SimpleMatcher;
import mpicbg.pointdescriptor.model.TranslationInvariantRigidModel3D;
import mpicbg.util.TransformUtils;
import spim.vecmath.Matrix3d;
import spim.vecmath.Point3d;
import spim.vecmath.Quat4d;
import spim.vecmath.Quat4f;
import spim.vecmath.Vector3f;

public class ModelPriorMatcher
extends SimpleMatcher {
    final RigidModel3D model;
    final Point3d referenceAxis;
    final double angle;
    final Matrix3d referenceMatrix;
    final Matrix3d invertedReferenceMatrix;

    public ModelPriorMatcher(int numNeighbors, RigidModel3D model) {
        super(numNeighbors);
        this.model = model;
        this.referenceMatrix = new Matrix3d();
        TransformUtils.getTransform3D(model).get(this.referenceMatrix);
        this.invertedReferenceMatrix = new Matrix3d(this.referenceMatrix);
        this.invertedReferenceMatrix.invert();
        Quat4f quaternion = new Quat4f();
        quaternion.set(this.referenceMatrix);
        this.angle = (float)Math.toDegrees(Math.acos(quaternion.getW()) * 2.0);
        Vector3f axis = new Vector3f(quaternion.getX(), quaternion.getY(), quaternion.getZ());
        axis.normalize();
        this.referenceAxis = new Point3d(axis);
    }

    @Override
    public double getNormalizationFactor(ArrayList<PointMatch> matches, Object fitResult) {
        TranslationInvariantRigidModel3D matchModel = (TranslationInvariantRigidModel3D)((Object)fitResult);
        Quat4d quaternion = new Quat4d();
        Matrix3d templateMatrix = new Matrix3d();
        matchModel.getMatrix3d(templateMatrix);
        templateMatrix.mul(this.invertedReferenceMatrix);
        quaternion.set(templateMatrix);
        double angle = Math.max(5.0, Math.toDegrees(Math.acos(quaternion.getW()) * 2.0)) - 5.0;
        double weight = 1.0 + (double)0.03f * angle * angle;
        return weight;
    }
}

