/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin.resave;

import bdv.export.ExportMipmapInfo;
import bdv.export.ExportScalePyramid;
import bdv.export.ProgressWriter;
import bdv.export.ProposeMipmaps;
import bdv.export.SubTaskProgressWriter;
import bdv.export.WriteSequenceToHdf5;
import bdv.img.hdf5.Hdf5ImageLoader;
import bdv.img.hdf5.Partition;
import bdv.spimdata.SequenceDescriptionMinimal;
import bdv.spimdata.SpimDataMinimal;
import bdv.spimdata.XmlIoSpimDataMinimal;
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.awt.AWTEvent;
import java.awt.Checkbox;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.XmlIoAbstractSpimData;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.sequence.ImgLoader;
import spim.Threads;
import spim.fiji.plugin.Toggle_Cluster_Options;
import spim.fiji.plugin.resave.PluginHelper;
import spim.fiji.plugin.resave.ProgressWriterIJ;
import spim.fiji.plugin.util.GUIHelper;

public class Generic_Resave_HDF5
implements PlugIn {
    public static final String[] convertChoices = new String[]{"Use min/max of each image (might flicker over time)", "Use min/max of first image (might saturate intenities over time)", "Manually define min/max"};
    public static int defaultConvertChoice = 1;
    public static double defaultMin = 0.0;
    public static double defaultMax = 5.0;
    static boolean lastSetMipmapManual = false;
    static String lastSubsampling = "{1,1,1}, {2,2,1}, {4,4,2}";
    static String lastChunkSizes = "{16,16,16}, {16,16,16}, {16,16,16}";
    static boolean lastSplit = false;
    static int lastTimepointsPerPartition = 1;
    static int lastSetupsPerPartition = 0;
    static boolean lastDeflate = true;
    static int lastJobIndex = 0;
    public static String lastExportPath = "/Users/pietzsch/Desktop/spimrec2.xml";

    public static void main(String[] args) {
        new Generic_Resave_HDF5().run(null);
    }

    public void run(String arg) {
        SpimDataMinimal spimData;
        File file = Generic_Resave_HDF5.getInputXML();
        if (file == null) {
            return;
        }
        XmlIoSpimDataMinimal io = new XmlIoSpimDataMinimal();
        try {
            spimData = (SpimDataMinimal)io.load(file.getAbsolutePath());
        }
        catch (SpimDataException e) {
            throw new RuntimeException(e);
        }
        Map perSetupExportMipmapInfo = ProposeMipmaps.proposeMipmaps((AbstractSequenceDescription)spimData.getSequenceDescription());
        int firstviewSetupId = ((BasicViewSetup)((SequenceDescriptionMinimal)spimData.getSequenceDescription()).getViewSetupsOrdered().get(0)).getId();
        Parameters params = Generic_Resave_HDF5.getParameters((ExportMipmapInfo)perSetupExportMipmapInfo.get(firstviewSetupId), true, true);
        if (params == null) {
            return;
        }
        ProgressWriterIJ progressWriter = new ProgressWriterIJ();
        progressWriter.out().println("starting export...");
        Generic_Resave_HDF5.writeHDF5(spimData, params, progressWriter);
        try {
            Generic_Resave_HDF5.writeXML(spimData, io, params, progressWriter);
        }
        catch (SpimDataException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<Integer, ExportMipmapInfo> getPerSetupExportMipmapInfo(AbstractSpimData<?> spimData, Parameters params) {
        if (params.setMipmapManual) {
            HashMap<Integer, ExportMipmapInfo> perSetupExportMipmapInfo = new HashMap<Integer, ExportMipmapInfo>();
            ExportMipmapInfo mipmapInfo = new ExportMipmapInfo(params.resolutions, params.subdivisions);
            for (BasicViewSetup setup : spimData.getSequenceDescription().getViewSetupsOrdered()) {
                perSetupExportMipmapInfo.put(setup.getId(), mipmapInfo);
            }
            return perSetupExportMipmapInfo;
        }
        return ProposeMipmaps.proposeMipmaps((AbstractSequenceDescription)spimData.getSequenceDescription());
    }

    public static ArrayList<Partition> getPartitions(AbstractSpimData<?> spimData, Parameters params) {
        AbstractSequenceDescription seq = spimData.getSequenceDescription();
        if (params.split) {
            String xmlFilename = params.seqFile.getAbsolutePath();
            String basename = xmlFilename.endsWith(".xml") ? xmlFilename.substring(0, xmlFilename.length() - 4) : xmlFilename;
            List timepoints = seq.getTimePoints().getTimePointsOrdered();
            List setups = seq.getViewSetupsOrdered();
            return Partition.split((List)timepoints, (List)setups, (int)params.timepointsPerPartition, (int)params.setupsPerPartition, (String)basename);
        }
        return null;
    }

    public static void writeHDF5(AbstractSpimData<?> spimData, Parameters params, ProgressWriter progressWriter) {
        Map<Integer, ExportMipmapInfo> perSetupExportMipmapInfo = Generic_Resave_HDF5.getPerSetupExportMipmapInfo(spimData, params);
        ArrayList<Partition> partitions = Generic_Resave_HDF5.getPartitions(spimData, params);
        AbstractSequenceDescription seq = spimData.getSequenceDescription();
        if (partitions != null) {
            for (int i = 0; i < partitions.size(); ++i) {
                Partition partition = partitions.get(i);
                SubTaskProgressWriter p = new SubTaskProgressWriter(progressWriter, 0.0, 0.95 * (double)i / (double)partitions.size());
                progressWriter.out().printf("proccessing partition %d / %d\n", i + 1, partitions.size());
                if (params.onlyRunSingleJob && params.jobId != i + 1) continue;
                WriteSequenceToHdf5.writeHdf5PartitionFile((AbstractSequenceDescription)seq, perSetupExportMipmapInfo, (boolean)params.deflate, (Partition)partition, (ExportScalePyramid.LoopbackHeuristic)new ExportScalePyramid.DefaultLoopbackHeuristic(), null, (int)Threads.numThreads(), (ProgressWriter)p);
            }
            if (!params.onlyRunSingleJob || params.jobId == 0) {
                WriteSequenceToHdf5.writeHdf5PartitionLinkFile((AbstractSequenceDescription)seq, perSetupExportMipmapInfo, partitions, (File)params.hdf5File);
            }
        } else {
            SubTaskProgressWriter p = new SubTaskProgressWriter(progressWriter, 0.0, 0.95);
            WriteSequenceToHdf5.writeHdf5File((AbstractSequenceDescription)seq, perSetupExportMipmapInfo, (boolean)params.deflate, (File)params.hdf5File, (ExportScalePyramid.LoopbackHeuristic)new ExportScalePyramid.DefaultLoopbackHeuristic(), null, (int)Threads.numThreads(), (ProgressWriter)p);
        }
    }

    public static <T extends AbstractSpimData<A>, A extends AbstractSequenceDescription<?, ?, ? super ImgLoader>> void writeXML(T spimData, XmlIoAbstractSpimData<A, T> io, Parameters params, ProgressWriter progressWriter) throws SpimDataException {
        AbstractSequenceDescription seq = spimData.getSequenceDescription();
        ArrayList<Partition> partitions = Generic_Resave_HDF5.getPartitions(spimData, params);
        Hdf5ImageLoader hdf5Loader = new Hdf5ImageLoader(params.hdf5File, partitions, null, false);
        seq.setImgLoader((BasicImgLoader)hdf5Loader);
        spimData.setBasePath(params.seqFile.getParentFile());
        try {
            if (!params.onlyRunSingleJob || params.jobId == 0) {
                io.save(spimData, params.seqFile.getAbsolutePath());
            }
            progressWriter.setProgress(1.0);
        }
        catch (Exception e) {
            progressWriter.err().println("Failed to write xml file " + params.seqFile);
            e.printStackTrace(progressWriter.err());
        }
        progressWriter.out().println("done");
    }

    public static File getInputXML() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "xml files";
            }

            @Override
            public boolean accept(File f) {
                String s;
                int i;
                if (f.isDirectory()) {
                    return true;
                }
                if (f.isFile() && (i = (s = f.getName()).lastIndexOf(46)) > 0 && i < s.length() - 1) {
                    String ext = s.substring(i + 1).toLowerCase();
                    return ext.equals("xml");
                }
                return false;
            }
        });
        if (fileChooser.showOpenDialog(null) == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    public static Parameters getParameters(ExportMipmapInfo autoMipmapSettings, boolean askForXMLPath, boolean is16bit) {
        return Generic_Resave_HDF5.getParameters(autoMipmapSettings, askForXMLPath, "Export for BigDataViewer", is16bit);
    }

    public static Parameters getParameters(ExportMipmapInfo autoMipmapSettings, final boolean askForXMLPath, String dialogTitle, final boolean is16bit) {
        File hdf5File;
        File seqFile;
        int[][] subdivisions;
        int[][] resolutions;
        boolean displayClusterProcessing;
        block21: {
            block20: {
                String seqFilename;
                displayClusterProcessing = Toggle_Cluster_Options.displayClusterProcessing;
                if (displayClusterProcessing) {
                    lastSplit = true;
                    lastTimepointsPerPartition = 1;
                    lastSetupsPerPartition = 0;
                }
                while (true) {
                    File parent;
                    final GenericDialogPlus gd = new GenericDialogPlus(dialogTitle);
                    gd.addCheckbox("manual_mipmap_setup", lastSetMipmapManual);
                    final Checkbox cManualMipmap = (Checkbox)gd.getCheckboxes().lastElement();
                    gd.addStringField("Subsampling_factors", lastSubsampling, 25);
                    final TextField tfSubsampling = (TextField)gd.getStringFields().lastElement();
                    gd.addStringField("Hdf5_chunk_sizes", lastChunkSizes, 25);
                    final TextField tfChunkSizes = (TextField)gd.getStringFields().lastElement();
                    gd.addMessage("");
                    gd.addCheckbox("split_hdf5", lastSplit);
                    final Checkbox cSplit = (Checkbox)gd.getCheckboxes().lastElement();
                    gd.addNumericField("timepoints_per_partition", (double)lastTimepointsPerPartition, 0, 25, "");
                    final TextField tfSplitTimepoints = (TextField)gd.getNumericFields().lastElement();
                    gd.addNumericField("setups_per_partition", (double)lastSetupsPerPartition, 0, 25, "");
                    final TextField tfSplitSetups = (TextField)gd.getNumericFields().lastElement();
                    if (displayClusterProcessing) {
                        gd.addNumericField("run_only_job_number", (double)lastJobIndex, 0, 25, "");
                    }
                    gd.addMessage("");
                    gd.addCheckbox("use_deflate_compression", lastDeflate);
                    if (askForXMLPath) {
                        gd.addMessage("");
                        PluginHelper.addSaveAsFileField(gd, "Export_path", lastExportPath, 25);
                    }
                    if (!is16bit) {
                        gd.addMessage("");
                        gd.addMessage("Currently, only 16-bit data is supported for HDF5. Please define how to convert to 16bit.", GUIHelper.mediumstatusfont);
                        gd.addChoice("Convert_32bit", convertChoices, convertChoices[defaultConvertChoice]);
                    }
                    final String autoSubsampling = ProposeMipmaps.getArrayString((int[][])autoMipmapSettings.getExportResolutions());
                    final String autoChunkSizes = ProposeMipmaps.getArrayString((int[][])autoMipmapSettings.getSubdivisions());
                    gd.addDialogListener(new DialogListener(){

                        public boolean dialogItemChanged(GenericDialog dialog, AWTEvent e) {
                            gd.getNextBoolean();
                            gd.getNextString();
                            gd.getNextString();
                            gd.getNextBoolean();
                            gd.getNextNumber();
                            gd.getNextNumber();
                            if (displayClusterProcessing) {
                                gd.getNextNumber();
                            }
                            gd.getNextBoolean();
                            if (askForXMLPath) {
                                gd.getNextString();
                            }
                            if (!is16bit) {
                                gd.getNextChoiceIndex();
                            }
                            if (e instanceof ItemEvent && e.getID() == 701 && e.getSource() == cManualMipmap) {
                                boolean useManual = cManualMipmap.getState();
                                tfSubsampling.setEnabled(useManual);
                                tfChunkSizes.setEnabled(useManual);
                                if (!useManual) {
                                    tfSubsampling.setText(autoSubsampling);
                                    tfChunkSizes.setText(autoChunkSizes);
                                }
                            } else if (e instanceof ItemEvent && e.getID() == 701 && e.getSource() == cSplit) {
                                boolean split = cSplit.getState();
                                tfSplitTimepoints.setEnabled(split);
                                tfSplitSetups.setEnabled(split);
                            }
                            return true;
                        }
                    });
                    tfSubsampling.setEnabled(lastSetMipmapManual);
                    tfChunkSizes.setEnabled(lastSetMipmapManual);
                    if (!lastSetMipmapManual) {
                        tfSubsampling.setText(autoSubsampling);
                        tfChunkSizes.setText(autoChunkSizes);
                    }
                    tfSplitTimepoints.setEnabled(lastSplit);
                    tfSplitSetups.setEnabled(lastSplit);
                    if (displayClusterProcessing) {
                        cSplit.setEnabled(false);
                        tfSplitTimepoints.setEnabled(false);
                        tfSplitSetups.setEnabled(false);
                    }
                    gd.showDialog();
                    if (gd.wasCanceled()) {
                        return null;
                    }
                    lastSetMipmapManual = gd.getNextBoolean();
                    lastSubsampling = gd.getNextString();
                    lastChunkSizes = gd.getNextString();
                    lastSplit = gd.getNextBoolean();
                    lastTimepointsPerPartition = (int)gd.getNextNumber();
                    lastSetupsPerPartition = (int)gd.getNextNumber();
                    if (displayClusterProcessing) {
                        lastJobIndex = (int)gd.getNextNumber();
                    }
                    lastDeflate = gd.getNextBoolean();
                    if (askForXMLPath) {
                        lastExportPath = gd.getNextString();
                    }
                    if (!is16bit) {
                        defaultConvertChoice = gd.getNextChoiceIndex();
                    }
                    resolutions = PluginHelper.parseResolutionsString(lastSubsampling);
                    subdivisions = PluginHelper.parseResolutionsString(lastChunkSizes);
                    if (resolutions.length == 0) {
                        IJ.showMessage((String)("Cannot parse subsampling factors " + lastSubsampling));
                        continue;
                    }
                    if (subdivisions.length == 0) {
                        IJ.showMessage((String)("Cannot parse hdf5 chunk sizes " + lastChunkSizes));
                        continue;
                    }
                    if (resolutions.length != subdivisions.length) {
                        IJ.showMessage((String)"subsampling factors and hdf5 chunk sizes must have the same number of elements");
                        continue;
                    }
                    if (!askForXMLPath) break block20;
                    seqFilename = lastExportPath;
                    if (!seqFilename.endsWith(".xml")) {
                        seqFilename = seqFilename + ".xml";
                    }
                    if ((parent = (seqFile = new File(seqFilename)).getParentFile()) != null && parent.exists() && parent.isDirectory()) break;
                    IJ.showMessage((String)("Invalid export filename " + seqFilename));
                }
                String hdf5Filename = seqFilename.substring(0, seqFilename.length() - 4) + ".h5";
                hdf5File = new File(hdf5Filename);
                break block21;
            }
            hdf5File = null;
            seqFile = null;
        }
        if (defaultConvertChoice == 2) {
            if (Double.isNaN(defaultMin)) {
                defaultMin = 0.0;
            }
            if (Double.isNaN(defaultMax)) {
                defaultMax = 5.0;
            }
            GenericDialog gdMinMax = new GenericDialog("Define min/max");
            gdMinMax.addNumericField("Min_Intensity_for_16bit_conversion", defaultMin, 1);
            gdMinMax.addNumericField("Max_Intensity_for_16bit_conversion", defaultMax, 1);
            gdMinMax.addMessage("Note: the typical range for multiview deconvolution is [0 ... 10] & for fusion the same as the input intensities., ", GUIHelper.mediumstatusfont);
            gdMinMax.showDialog();
            if (gdMinMax.wasCanceled()) {
                return null;
            }
            defaultMin = gdMinMax.getNextNumber();
            defaultMax = gdMinMax.getNextNumber();
        } else {
            defaultMax = Double.NaN;
            defaultMin = Double.NaN;
        }
        return new Parameters(lastSetMipmapManual, resolutions, subdivisions, seqFile, hdf5File, lastDeflate, lastSplit, lastTimepointsPerPartition, lastSetupsPerPartition, displayClusterProcessing, lastJobIndex, defaultConvertChoice, defaultMin, defaultMax);
    }

    public static class Parameters {
        boolean setMipmapManual;
        int[][] resolutions;
        int[][] subdivisions;
        File seqFile;
        File hdf5File;
        boolean deflate;
        boolean split;
        int timepointsPerPartition;
        int setupsPerPartition;
        boolean onlyRunSingleJob;
        int jobId;
        int convertChoice = 1;
        double min = Double.NaN;
        double max = Double.NaN;

        public Parameters(boolean setMipmapManual, int[][] resolutions, int[][] subdivisions, File seqFile, File hdf5File, boolean deflate, boolean split, int timepointsPerPartition, int setupsPerPartition, boolean onlyRunSingleJob, int jobId, int convertChoice, double min, double max) {
            this.setMipmapManual = setMipmapManual;
            this.resolutions = resolutions;
            this.subdivisions = subdivisions;
            this.seqFile = seqFile;
            this.hdf5File = hdf5File;
            this.deflate = deflate;
            this.split = split;
            this.timepointsPerPartition = timepointsPerPartition;
            this.setupsPerPartition = setupsPerPartition;
            this.onlyRunSingleJob = onlyRunSingleJob;
            this.jobId = jobId;
            this.convertChoice = convertChoice;
            this.min = min;
            this.max = max;
        }

        public void setSeqFile(File seqFile) {
            this.seqFile = seqFile;
        }

        public void setHDF5File(File hdf5File) {
            this.hdf5File = hdf5File;
        }

        public void setResolutions(int[][] resolutions) {
            this.resolutions = resolutions;
        }

        public void setSubdivisions(int[][] subdivisions) {
            this.subdivisions = subdivisions;
        }

        public void setMipmapManual(boolean setMipmapManual) {
            this.setMipmapManual = setMipmapManual;
        }

        public void setDeflate(boolean deflate) {
            this.deflate = deflate;
        }

        public void setSplit(boolean split) {
            this.split = split;
        }

        public void setTimepointsPerPartition(int timepointsPerPartition) {
            this.timepointsPerPartition = timepointsPerPartition;
        }

        public void setSetupsPerPartition(int setupsPerPartition) {
            this.setupsPerPartition = setupsPerPartition;
        }

        public void setMin(double min) {
            this.min = min;
        }

        public void setMax(double max) {
            this.max = max;
        }

        public File getSeqFile() {
            return this.seqFile;
        }

        public File getHDF5File() {
            return this.hdf5File;
        }

        public int[][] getResolutions() {
            return this.resolutions;
        }

        public int[][] getSubdivisions() {
            return this.subdivisions;
        }

        public boolean getMipmapManual() {
            return this.setMipmapManual;
        }

        public boolean getDeflate() {
            return this.deflate;
        }

        public boolean getSplit() {
            return this.split;
        }

        public int getTimepointsPerPartition() {
            return this.timepointsPerPartition;
        }

        public int getSetupsPerPartition() {
            return this.setupsPerPartition;
        }

        public int getConvertChoice() {
            return this.convertChoice;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }
    }
}

