/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.explorer.popup;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.io.IOFunctions;
import spim.fiji.plugin.Specify_Calibration;
import spim.fiji.spimdata.explorer.ViewSetupExplorerPanel;
import spim.fiji.spimdata.explorer.popup.ViewExplorerSetable;

public class SpecifyCalibrationPopup
extends JMenuItem
implements ViewExplorerSetable {
    private static final long serialVersionUID = 5234649267634013390L;
    public static boolean showWarning = true;
    ViewSetupExplorerPanel<? extends AbstractSpimData<? extends AbstractSequenceDescription<?, ?, ?>>, ?> panel;

    public SpecifyCalibrationPopup() {
        super("Specify Calibration ...");
        this.addActionListener(new MyActionListener());
    }

    @Override
    public JMenuItem setViewExplorer(ViewSetupExplorerPanel<? extends AbstractSpimData<? extends AbstractSequenceDescription<?, ?, ?>>, ?> panel) {
        this.panel = panel;
        return this;
    }

    public class MyActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Specify_Calibration.Cal maxCal;
            if (SpecifyCalibrationPopup.this.panel == null) {
                IOFunctions.println("Panel not set for " + this.getClass().getSimpleName());
                return;
            }
            List<ViewId> viewIds = SpecifyCalibrationPopup.this.panel.selectedRowsViewId();
            ArrayList<Specify_Calibration.Cal> calibrations = Specify_Calibration.findCalibrations(SpecifyCalibrationPopup.this.panel.getSpimData(), viewIds);
            if (!Specify_Calibration.queryNewCal(calibrations, maxCal = Specify_Calibration.mostPresentCal(calibrations))) {
                return;
            }
            if (SpimData.class.isInstance(SpecifyCalibrationPopup.this.panel.getSpimData())) {
                Specify_Calibration.applyCal(maxCal, (SpimData)SpecifyCalibrationPopup.this.panel.getSpimData(), viewIds);
                if (showWarning) {
                    JOptionPane.showMessageDialog(null, "The calibration was set, but this is not reflected in the transformations yet (Click 'Info' Button). If you want to\ndo so, please call 'Apply Transformation' and use the image calibration as basis for transformations.");
                    showWarning = false;
                }
            } else {
                JOptionPane.showMessageDialog(null, "Applying the calibration is not supported for '" + SpecifyCalibrationPopup.this.panel.getSpimData().getClass().getSimpleName() + "', needs to extend SpimData.");
            }
        }
    }
}

