/*
 * Decompiled with CFR 0.152.
 */
package spim.process.cuda;

import com.sun.jna.Library;
import com.sun.jna.Native;
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import mpicbg.spim.io.IOFunctions;
import spim.fiji.plugin.util.GUIHelper;
import spim.process.cuda.CUDAStandardFunctions;
import spim.process.cuda.CUDATools;

public class NativeLibraryTools {
    public static String defaultDirectory = null;

    public static <L extends Library> L loadNativeLibrary(Class<L> library) {
        ArrayList<String> names = new ArrayList<String>();
        return NativeLibraryTools.loadNativeLibrary(names, library);
    }

    public static <L extends Library> L loadNativeLibrary(String potentialName, Class<L> library) {
        ArrayList<String> names = new ArrayList<String>();
        names.add(potentialName);
        return NativeLibraryTools.loadNativeLibrary(names, library);
    }

    public static <L extends Library> L loadNativeLibrary(ArrayList<String> potentialNames, Class<L> library) {
        GenericDialogPlus gd = new GenericDialogPlus("Specify path of native library");
        String directory = defaultDirectory == null ? IJ.getDirectory((String)"ImageJ") : defaultDirectory;
        File dir = directory == null || directory.equals("null/") ? new File("") : new File(directory);
        gd.addDirectoryField("CUDA_Directory", dir.getAbsolutePath(), 80);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        defaultDirectory = gd.getNextString();
        return NativeLibraryTools.loadNativeLibrary(potentialNames, new File(defaultDirectory), library);
    }

    public static <L extends Library> L loadNativeLibrary(ArrayList<String> potentialNames, File dir, Class<L> libraryClass) {
        if (potentialNames == null) {
            potentialNames = new ArrayList();
        }
        try {
            if (System.getProperty("jna.library.path") == null) {
                System.setProperty("jna.library.path", "");
            }
            final ArrayList<String> ext = NativeLibraryTools.getLibraryExtensions();
            String exts = "";
            for (int i = 0; i < ext.size(); ++i) {
                exts = exts + "'" + ext.get(i) + "'";
                if (i == ext.size() - 1) continue;
                exts = exts + ", ";
            }
            IOFunctions.println("Looking for native libraries ending with " + exts + " in directory: '" + dir.getAbsolutePath() + "' ... ");
            String[] libs = dir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    for (String e : ext) {
                        if (!name.toLowerCase().endsWith(e)) continue;
                        return true;
                    }
                    return false;
                }
            });
            if (libs == null || libs.length == 0) {
                IOFunctions.println("No libraries found.");
                return null;
            }
            int index = 0;
            for (int i = 0; i < libs.length; ++i) {
                for (String s : potentialNames) {
                    if (!libs[i].toLowerCase().contains(s.toLowerCase())) continue;
                    index = i;
                }
            }
            GenericDialogPlus gd = new GenericDialogPlus("Select native library");
            gd.addMessage("Native_library_directory: '" + dir.getAbsolutePath() + "'", GUIHelper.mediumstatusfont);
            gd.addChoice("Select_native_library_for_" + libraryClass.getSimpleName(), libs, libs[index]);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return null;
            }
            String fullPath = new File(dir.getAbsolutePath(), gd.getNextChoice()).getAbsolutePath();
            IOFunctions.println("Trying to load following library: " + fullPath);
            return (L)Native.load((String)fullPath, libraryClass);
        }
        catch (UnsatisfiedLinkError e) {
            IOFunctions.println("Cannot load JNA library: " + e);
            return null;
        }
    }

    public static ArrayList<String> getLibraryExtensions() {
        ArrayList<String> libs = new ArrayList<String>();
        if (IJ.isWindows()) {
            libs.add(".dll");
        } else if (IJ.isLinux()) {
            libs.add(".so");
            libs.add(".lib");
        } else if (IJ.isMacOSX() || IJ.isMacintosh()) {
            libs.add(".lib");
            libs.add(".so");
            libs.add(".dylib");
        }
        return libs;
    }

    public static void main(String[] args) {
        CUDAStandardFunctions c = NativeLibraryTools.loadNativeLibrary(CUDAStandardFunctions.class);
        IOFunctions.println("devices: " + c.getNumDevicesCUDA());
        CUDATools.queryCUDADetails(c, false);
        CUDATools.queryCUDADetails(c, true);
    }
}

