/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ini.trakem2.display.Display;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Channel
extends JPanel
implements ItemListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    public static final int HEIGHT = 52;
    private JCheckBox c;
    private Display display;
    public static final int MONO = 1;
    public static final int RED = 2;
    public static final int GREEN = 4;
    public static final int BLUE = 8;
    private int channel;
    private float alpha = 1.0f;

    Channel(Display display, int channel) {
        this.display = display;
        this.channel = channel;
        this.c = new JCheckBox();
        this.c.setSelected(true);
        this.c.addItemListener(this);
        this.c.setBackground(Color.white);
        String t = "mono";
        switch (channel) {
            case 2: {
                t = "red";
                break;
            }
            case 4: {
                t = "green";
                break;
            }
            case 8: {
                t = "blue";
                break;
            }
            default: {
                t = "mono";
            }
        }
        JLabel title = new JLabel("   " + t);
        title.addMouseListener(this);
        this.setBackground(Color.white);
        GridBagLayout gb = new GridBagLayout();
        this.setLayout(gb);
        GridBagConstraints co = new GridBagConstraints();
        co.anchor = 18;
        JPanel emptyTop = new JPanel();
        emptyTop.setBackground(Color.white);
        co.gridx = 0;
        co.gridy = 0;
        co.gridwidth = 2;
        co.weightx = 1.0;
        co.weighty = 1.0;
        co.fill = 1;
        gb.setConstraints(emptyTop, co);
        this.add(emptyTop);
        co.gridx = 0;
        co.gridy = 1;
        co.gridwidth = 1;
        co.weightx = 0.0;
        co.weighty = 0.0;
        co.fill = 0;
        gb.setConstraints(this.c, co);
        this.add(this.c);
        co.gridx = 1;
        co.gridy = 1;
        co.gridwidth = 1;
        co.fill = 2;
        co.weightx = 0.0;
        co.weighty = 0.0;
        gb.setConstraints(title, co);
        this.add(title);
        JPanel padding = new JPanel();
        padding.setBackground(Color.white);
        co.gridx = 2;
        co.gridy = 1;
        co.gridwidth = 1;
        co.fill = 1;
        co.weightx = 1.0;
        co.weighty = 0.0;
        gb.setConstraints(padding, co);
        this.add(padding);
        JPanel emptyBottom = new JPanel();
        emptyBottom.setBackground(Color.white);
        co.gridx = 0;
        co.gridy = 2;
        co.gridwidth = 2;
        co.fill = 1;
        co.weightx = 1.0;
        co.weighty = 1.0;
        gb.setConstraints(emptyBottom, co);
        this.add(emptyBottom);
        this.setMinimumSize(new Dimension(200, 52));
        this.setPreferredSize(new Dimension(248, 52));
        this.addMouseListener(this);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
    }

    public void setAlpha(float alpha, boolean selected) {
        if (alpha != this.alpha && alpha >= 0.0f && alpha <= 1.0f) {
            this.alpha = alpha;
        }
        this.c.setSelected(selected);
    }

    public void setAlpha(float alpha) {
        if (alpha != this.alpha && alpha >= 0.0f && alpha <= 1.0f) {
            this.alpha = alpha;
            this.display.setChannel(this.channel, alpha);
        }
    }

    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        Object source = ie.getSource();
        if (source.equals(this.c)) {
            if (ie.getStateChange() == 1) {
                this.display.setChannel(this.channel, this.alpha);
            } else if (ie.getStateChange() == 2) {
                this.display.setChannel(this.channel, 0.0f);
            }
        }
    }

    public boolean isSelected() {
        return this.c.isSelected();
    }

    public void setActive(boolean active) {
        if (active) {
            this.setBackground(Color.cyan);
        } else {
            this.setBackground(Color.white);
        }
    }

    public boolean isActive() {
        return this.getBackground().equals(Color.cyan);
    }

    public void setSelected(boolean s) {
        this.c.setSelected(s);
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.display.setActiveChannel(this);
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }
}

