/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.imaging.filters;

import ij.IJ;
import ij.gui.GenericDialog;
import ij.gui.YesNoCancelDialog;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Patch;
import ini.trakem2.imaging.filters.CLAHE;
import ini.trakem2.imaging.filters.CorrectBackground;
import ini.trakem2.imaging.filters.DefaultMinAndMax;
import ini.trakem2.imaging.filters.EnhanceContrast;
import ini.trakem2.imaging.filters.EqualizeHistogram;
import ini.trakem2.imaging.filters.GaussianBlur;
import ini.trakem2.imaging.filters.IFilter;
import ini.trakem2.imaging.filters.Invert;
import ini.trakem2.imaging.filters.LUTBlue;
import ini.trakem2.imaging.filters.LUTCustom;
import ini.trakem2.imaging.filters.LUTCyan;
import ini.trakem2.imaging.filters.LUTGreen;
import ini.trakem2.imaging.filters.LUTMagenta;
import ini.trakem2.imaging.filters.LUTOrange;
import ini.trakem2.imaging.filters.LUTRed;
import ini.trakem2.imaging.filters.LUTYellow;
import ini.trakem2.imaging.filters.Normalize;
import ini.trakem2.imaging.filters.NormalizeLocalContrast;
import ini.trakem2.imaging.filters.RankFilter;
import ini.trakem2.imaging.filters.ResetMinAndMax;
import ini.trakem2.imaging.filters.RobustNormalizeLocalContrast;
import ini.trakem2.imaging.filters.SubtractBackground;
import ini.trakem2.imaging.filters.ValueToNoise;
import ini.trakem2.utils.Bureaucrat;
import ini.trakem2.utils.Utils;
import ini.trakem2.utils.Worker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class FilterEditor {
    public static final Class[] available = new Class[]{CLAHE.class, NormalizeLocalContrast.class, EqualizeHistogram.class, EnhanceContrast.class, ResetMinAndMax.class, DefaultMinAndMax.class, GaussianBlur.class, Invert.class, Normalize.class, RankFilter.class, RobustNormalizeLocalContrast.class, ValueToNoise.class, SubtractBackground.class, CorrectBackground.class, LUTRed.class, LUTGreen.class, LUTBlue.class, LUTMagenta.class, LUTCyan.class, LUTYellow.class, LUTOrange.class, LUTCustom.class};

    public static final void GUI(final Collection<Patch> patches, Patch reference) {
        final ArrayList<FilterWrapper> filters = new ArrayList<FilterWrapper>();
        StringBuilder sb = new StringBuilder();
        final Patch ref = null == reference ? patches.iterator().next() : reference;
        IFilter[] refFilters = ref.getFilters();
        if (null != refFilters) {
            for (IFilter f : refFilters) {
                filters.add(new FilterWrapper(f));
            }
        }
        block1: for (Patch p : patches) {
            IFilter[] fs;
            if (ref == p || null == (fs = p.getFilters()) && null == refFilters) continue;
            if (null != refFilters && null == fs || null == refFilters && null != fs || null != refFilters && null != fs && fs.length != refFilters.length) {
                sb.append("WARNING: patch #" + p.getId() + " has a different number of filters than reference patch #" + ref.getId());
                continue;
            }
            for (int i = 0; i < refFilters.length; ++i) {
                if (fs[i].getClass() != refFilters[i].getClass()) {
                    sb.append("WARNING: patch #" + p.getId() + " has a different filters than reference patch #" + ref.getId());
                    continue block1;
                }
                if (filters.get(i).sameParameterValues(new FilterWrapper(fs[i]))) continue;
                sb.append("WARNING: patch #" + p.getId() + " has filter '" + fs[i].getClass().getSimpleName() + "' with different parameters than the reference patch #" + ref.getId());
            }
        }
        if (sb.length() > 0) {
            GenericDialog gd = new GenericDialog("WARNING", (Frame)(null == Display.getFront() ? IJ.getInstance() : Display.getFront().getFrame()));
            gd.addMessage("Filters are not all the same for all images:");
            gd.addTextAreas(sb.toString(), null, 20, 30);
            String[] s = new String[]{"Use the filters of the reference image", "Start from an empty list of filters"};
            gd.addChoice("Do:", s, s[0]);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            if (1 == gd.getNextChoiceIndex()) {
                filters.clear();
            }
        }
        TableChosenFilters tcf = new TableChosenFilters(filters);
        TableParameters tp = new TableParameters(tcf);
        tcf.setupListener(tp);
        TableAvailableFilters taf = new TableAvailableFilters(tcf);
        if (filters.size() > 0) {
            tcf.getSelectionModel().setSelectionInterval(0, 0);
        }
        final JFrame frame = new JFrame("Image filters");
        JButton set = new JButton("Set");
        final JComboBox<String> pulldown = new JComboBox<String>(new String[]{"Selected images (" + patches.size() + ")", "All images in layer " + (ref.getLayer().getParent().indexOf(ref.getLayer()) + 1), "All images in layer range..."});
        final Component[] cs = new Component[]{set, pulldown, tcf, tp, taf};
        set.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FilterEditor.check(frame, filters)) {
                    ArrayList<Patch> ps = new ArrayList<Patch>();
                    switch (pulldown.getSelectedIndex()) {
                        case 0: {
                            ps.addAll(patches);
                            break;
                        }
                        case 1: {
                            for (Displayable d : ref.getLayer().getDisplayables(Patch.class)) {
                                ps.add((Patch)d);
                            }
                            break;
                        }
                        case 2: {
                            GenericDialog gd = new GenericDialog("Apply filters");
                            Utils.addLayerRangeChoices(ref.getLayer(), gd);
                            gd.addStringField("Image title matches:", "", 30);
                            gd.addCheckbox("Visible images only", true);
                            gd.showDialog();
                            if (gd.wasCanceled()) {
                                return;
                            }
                            String regex = gd.getNextString();
                            boolean visible_only = gd.getNextBoolean();
                            Pattern pattern = null;
                            if (0 != regex.length()) {
                                pattern = Pattern.compile(regex);
                            }
                            for (Layer l : ref.getLayer().getParent().getLayers(gd.getNextChoiceIndex(), gd.getNextChoiceIndex())) {
                                for (Displayable d : l.getDisplayables(Patch.class, visible_only)) {
                                    if (null != pattern && !pattern.matcher(d.getTitle()).matches()) continue;
                                    ps.add((Patch)d);
                                }
                            }
                            break;
                        }
                    }
                    FilterEditor.apply(ps, filters, cs, false);
                }
            }
        });
        JPanel buttons = new JPanel();
        JLabel label = new JLabel("Push F1 for help");
        GridBagConstraints c2 = new GridBagConstraints();
        GridBagLayout gb2 = new GridBagLayout();
        buttons.setLayout(gb2);
        c2.anchor = 17;
        c2.gridx = 0;
        gb2.setConstraints(label, c2);
        buttons.add(label);
        c2.gridx = 1;
        c2.weightx = 1.0;
        JPanel empty = new JPanel();
        gb2.setConstraints(empty, c2);
        buttons.add(empty);
        c2.gridx = 2;
        c2.weightx = 0.0;
        c2.anchor = 13;
        JLabel a = new JLabel("Apply to:");
        gb2.setConstraints(a, c2);
        buttons.add(a);
        c2.gridx = 3;
        c2.insets = new Insets(4, 10, 4, 0);
        gb2.setConstraints(pulldown, c2);
        buttons.add(pulldown);
        c2.gridx = 4;
        gb2.setConstraints(set, c2);
        buttons.add(set);
        taf.setPreferredSize(new Dimension(350, 500));
        tcf.setPreferredSize(new Dimension(350, 250));
        tp.setPreferredSize(new Dimension(350, 250));
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel all = new JPanel();
        all.setBackground(Color.white);
        all.setPreferredSize(new Dimension(700, 500));
        all.setLayout(gb);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        c.fill = 1;
        c.gridheight = 2;
        c.weightx = 0.5;
        JScrollPane p1 = new JScrollPane(taf);
        p1.setPreferredSize(taf.getPreferredSize());
        gb.setConstraints(p1, c);
        all.add(p1);
        c.gridx = 1;
        c.gridy = 0;
        c.gridheight = 1;
        c.weighty = 0.7;
        JScrollPane p2 = new JScrollPane(tcf);
        p2.setPreferredSize(tcf.getPreferredSize());
        gb.setConstraints(p2, c);
        all.add(p2);
        c.gridx = 1;
        c.gridy = 1;
        c.weighty = 0.3;
        JScrollPane p3 = new JScrollPane(tp);
        p3.setPreferredSize(tp.getPreferredSize());
        gb.setConstraints(p3, c);
        all.add(p3);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        gb.setConstraints(buttons, c);
        all.add(buttons);
        KeyAdapter help = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 112) {
                    GenericDialog gd = new GenericDialog("Help :: image filters");
                    gd.addMessage("In the table 'Available Filters':\n - double-click a filter to add it to the table of 'Chosen Filters'\n \nIn the table 'Chosen Filters':\n - double-click a filter to remove it.\n - PAGE UP/DOWN keys move the filter up/down in the list.\n - 'Delete' key removes the selected filter.\n \nIn the table of parameter names and values:\n - double-click a value to edit it. Then push enter to set the new value.\n \nWhat you need to know:\n - filters are set and applied in order, so order matters.\n - filters with parameters for which you entered a value of zero\nwill result in a warning message.\n - when applying the filters, if you choose 'Selected images', these are the images\nthat were selected when the filter editor was opened.\n - when applying the filters, if you want to filter for a regular expression pattern\nin the image name, use the 'All images in layer range...' option,\nwhere a range of one single layer is also possible.");
                    gd.hideCancelButton();
                    gd.setModal(false);
                    gd.showDialog();
                }
            }
        };
        taf.addKeyListener(help);
        tcf.addKeyListener(help);
        tp.addKeyListener(help);
        all.addKeyListener(help);
        buttons.addKeyListener(help);
        empty.addKeyListener(help);
        a.addKeyListener(help);
        frame.getContentPane().add(all);
        frame.pack();
        frame.setVisible(true);
    }

    private static boolean check(JFrame frame, List<FilterWrapper> wrappers) {
        if (!wrappers.isEmpty()) {
            String s = FilterEditor.sanityCheck(wrappers);
            return 0 == s.length() || new YesNoCancelDialog((Frame)frame, "WARNING", s + "\nContinue?").yesPressed();
        }
        return true;
    }

    private static String sanityCheck(List<FilterWrapper> wrappers) {
        HashSet unique = new HashSet();
        for (FilterWrapper w : wrappers) {
            unique.add(w.filter.getClass());
        }
        StringBuilder sb = new StringBuilder();
        if (wrappers.size() != unique.size()) {
            sb.append("WARNING: there are repeated filters!\n");
        }
        for (FilterWrapper w : wrappers) {
            for (Field f : w.fields) {
                try {
                    String zero = f.get(w.filter).toString();
                    if (!"0".equals(zero) && !"0.0".equals(zero)) continue;
                    sb.append("WARNING: parameter '" + f.getName() + "' of filter '" + w.filter.getClass().getSimpleName() + "' is zero!\n");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    private static IFilter[] asFilters(List<FilterWrapper> wrappers) {
        if (wrappers.isEmpty()) {
            return null;
        }
        IFilter[] fs = new IFilter[wrappers.size()];
        int next = 0;
        for (FilterWrapper fw : wrappers) {
            fs[next++] = new FilterWrapper((IFilter)fw.filter).filter;
        }
        return fs;
    }

    private static void apply(final Collection<Patch> patches, final List<FilterWrapper> wrappers, final Component[] cs, final boolean append) {
        Bureaucrat.createAndStart((Worker)new Worker.Task("Set filters"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void exec() {
                try {
                    for (Component c : cs) {
                        c.setEnabled(false);
                    }
                    LayerSet ls = ((Patch)patches.iterator().next()).getLayerSet();
                    ls.addDataEditStep(new HashSet(patches));
                    ArrayList fus = new ArrayList();
                    for (Patch p : patches) {
                        IFilter[] fs = FilterEditor.asFilters(wrappers);
                        if (append) {
                            p.appendFilters(fs);
                        } else {
                            p.setFilters(fs);
                        }
                        p.getProject().getLoader().decacheImagePlus(p.getId());
                        fus.add(p.updateMipMaps());
                    }
                    Utils.wait(fus);
                    ls.addDataEditStep(new HashSet(patches));
                }
                finally {
                    for (Component c : cs) {
                        c.setEnabled(true);
                    }
                }
            }
        }, patches.iterator().next().getProject());
    }

    public static final IFilter[] duplicate(IFilter[] fs) {
        if (null == fs) {
            return fs;
        }
        IFilter[] copy = new IFilter[fs.length];
        for (int i = 0; i < fs.length; ++i) {
            copy[i] = new FilterWrapper((IFilter)fs[i]).filter;
        }
        return copy;
    }

    private static class TableParameters
    extends JTable {
        TableParameters(final TableChosenFilters tcf) {
            this.setModel(new AbstractTableModel(){

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    FilterWrapper w = tcf.selected();
                    switch (columnIndex) {
                        case 0: {
                            return w.name(rowIndex);
                        }
                        case 1: {
                            return w.value(rowIndex);
                        }
                    }
                    return null;
                }

                @Override
                public int getRowCount() {
                    return tcf.selected().fields.length;
                }

                @Override
                public int getColumnCount() {
                    return 2;
                }

                @Override
                public String getColumnName(int col) {
                    switch (col) {
                        case 0: {
                            return "Parameter";
                        }
                        case 1: {
                            return "Value";
                        }
                    }
                    return null;
                }

                @Override
                public void setValueAt(Object v, int rowIndex, int columnIndex) {
                    tcf.selected().set(rowIndex, v);
                }

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return 1 == columnIndex;
                }
            });
        }

        void triggerUpdate() {
            ((AbstractTableModel)this.getModel()).fireTableStructureChanged();
        }
    }

    private static class TableChosenFilters
    extends JTable {
        private final ArrayList<FilterWrapper> filters;

        public TableChosenFilters(final ArrayList<FilterWrapper> filters) {
            this.filters = filters;
            this.setModel(new AbstractTableModel(){

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    switch (columnIndex) {
                        case 0: {
                            return rowIndex + 1;
                        }
                        case 1: {
                            return ((FilterWrapper)filters.get((int)rowIndex)).filter.getClass().getSimpleName();
                        }
                    }
                    return null;
                }

                @Override
                public int getRowCount() {
                    return filters.size();
                }

                @Override
                public int getColumnCount() {
                    return 2;
                }

                @Override
                public String getColumnName(int col) {
                    switch (col) {
                        case 0: {
                            return "";
                        }
                        case 1: {
                            return "Chosen Filters";
                        }
                    }
                    return null;
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent me) {
                    if (me.getClickCount() == 2) {
                        int row = this.getSelectedRow();
                        filters.remove(row);
                        ((AbstractTableModel)this.getModel()).fireTableStructureChanged();
                        if (filters.size() > 0) {
                            if (row > 0) {
                                --row;
                            }
                            this.getSelectionModel().setSelectionInterval(row, row);
                        }
                        this.getColumnModel().getColumn(0).setMaxWidth(10);
                    }
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent ke) {
                    int row = this.getSelectedRow();
                    if (-1 == row) {
                        return;
                    }
                    int selRow = -1;
                    switch (ke.getKeyCode()) {
                        case 33: {
                            if (filters.size() <= 1 || row <= 0) break;
                            filters.add(row - 1, filters.remove(row));
                            selRow = row - 1;
                            ke.consume();
                            break;
                        }
                        case 34: {
                            if (filters.size() <= 1 || row >= filters.size() - 1) break;
                            filters.add(row + 1, filters.remove(row));
                            selRow = row + 1;
                            ke.consume();
                            break;
                        }
                        case 127: {
                            if (filters.size() > 1) {
                                selRow = 0 == row ? 0 : (filters.size() - 1 == row ? filters.size() - 2 : row - 1);
                            }
                            filters.remove(row);
                            ke.consume();
                            break;
                        }
                        case 38: {
                            selRow = row > 0 ? row - 1 : row;
                            ke.consume();
                            break;
                        }
                        case 40: {
                            selRow = row < filters.size() - 1 ? row + 1 : row;
                            ke.consume();
                        }
                    }
                    ((AbstractTableModel)this.getModel()).fireTableStructureChanged();
                    this.getColumnModel().getColumn(0).setMaxWidth(10);
                    if (-1 != selRow) {
                        this.getSelectionModel().setSelectionInterval(selRow, selRow);
                    }
                }
            });
            this.getColumnModel().getColumn(0).setMaxWidth(10);
        }

        final FilterWrapper selected() {
            int row = this.getSelectedRow();
            if (-1 == row) {
                return new FilterWrapper();
            }
            return this.filters.get(row);
        }

        final void add(Class<?> filterClass) {
            this.filters.add(new FilterWrapper(filterClass));
            ((AbstractTableModel)this.getModel()).fireTableStructureChanged();
            this.getSelectionModel().setSelectionInterval(this.filters.size() - 1, this.filters.size() - 1);
        }

        final void setupListener(final TableParameters tp) {
            this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    tp.triggerUpdate();
                }
            });
        }
    }

    private static class FilterWrapper {
        IFilter filter;
        final Field[] fields;

        FilterWrapper(Class<?> filterClass) {
            this.fields = filterClass.getDeclaredFields();
            try {
                this.filter = (IFilter)filterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        FilterWrapper(IFilter filter) {
            this.fields = filter.getClass().getDeclaredFields();
            try {
                this.filter = (IFilter)filter.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                for (Field f : this.fields) {
                    f.set(this.filter, f.get(filter));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        FilterWrapper() {
            this.fields = new Field[0];
        }

        String name(int i) {
            return this.fields[i].getName();
        }

        String value(int i) {
            try {
                return "" + this.fields[i].get(this.filter);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        void set(int i, Object v) {
            Utils.log2("v class: " + v.getClass());
            Field f = this.fields[i];
            f.setAccessible(true);
            Class<?> c = f.getType();
            try {
                String sv = v.toString().trim();
                Utils.log2("sv is: " + sv + ", and f.getDeclaringClass() == " + c);
                if (Double.TYPE == c) {
                    v = Double.parseDouble(sv);
                } else if (Float.TYPE == c) {
                    v = Float.valueOf(Float.parseFloat(sv));
                } else if (Integer.TYPE == c) {
                    v = Integer.parseInt(sv);
                } else if (Boolean.TYPE == c) {
                    v = Boolean.parseBoolean(sv);
                } else if (Long.TYPE == c) {
                    v = Long.parseLong(sv);
                } else if (Short.TYPE == c) {
                    v = Short.parseShort(sv);
                } else if (Byte.TYPE == c) {
                    v = Byte.parseByte(sv);
                } else if (String.class == c) {
                    v = sv;
                }
                f.set(this.filter, v);
            }
            catch (Exception e) {
                Utils.logAll("New value '" + v + "' is invalid; keeping the last value.");
                e.printStackTrace();
            }
        }

        public boolean sameParameterValues(FilterWrapper w) {
            if (this.filter == w.filter) {
                return true;
            }
            if (this.filter.getClass() != w.filter.getClass()) {
                return false;
            }
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.value(i).equals(w.value(i))) continue;
                return false;
            }
            return true;
        }
    }

    private static class TableAvailableFilters
    extends JTable {
        public TableAvailableFilters(final TableChosenFilters tcf) {
            this.setModel(new AbstractTableModel(){

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    return available[rowIndex].getSimpleName();
                }

                @Override
                public int getRowCount() {
                    return available.length;
                }

                @Override
                public int getColumnCount() {
                    return 1;
                }

                @Override
                public String getColumnName(int col) {
                    return "Available Filters";
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent me) {
                    if (2 == me.getClickCount()) {
                        tcf.add(available[this.getSelectedRow()]);
                    }
                }
            });
        }
    }
}

