/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.io;

import ij.measure.Calibration;
import ini.trakem2.display.AreaTree;
import ini.trakem2.display.Connector;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Node;
import ini.trakem2.display.Tree;
import ini.trakem2.display.Treeline;
import ini.trakem2.utils.Utils;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public final class NeuroML {
    private static final <T> List<Node<T>> cable(Node<T> be) {
        Node<T> p2;
        ArrayList<Node<T>> slab = new ArrayList<Node<T>>();
        slab.add(be);
        Node<T> p1 = be.getParent();
        Node<T> node = p2 = null == p1 ? null : p1.getParent();
        while (p2 != null && 1 == p1.getChildrenCount()) {
            slab.add(p1);
            p1 = p2;
            p2 = p2.getParent();
        }
        return slab;
    }

    private static final void writeCellHeader(Writer w, Tree<?> t) throws IOException {
        w.write("<cell name=\"");
        w.write(Long.toString(t.getId()));
        w.write("\">\n");
        w.write(" <meta:notes>");
        w.write(t.getProject().getMeaningfulTitle(t));
        String annotation = t.getAnnotation();
        if (null != annotation) {
            w.write("\n");
            w.write(t.getAnnotation());
        }
        w.write("</meta:notes>\n");
        w.write(" <meta:properties>\n");
        w.write("  <meta:property tag=\"Neuron type\" value=\"manually reconstructed\" />\n");
        w.write(" </meta:properties>\n");
        w.write(" <segments xmlns=\"http://morphml.org/morphml/schema\">\n");
    }

    private static final void toPoint(Node<Float> nd, float[] fp, AffineTransform aff, double zScale) {
        fp[0] = nd.getX();
        fp[1] = nd.getY();
        fp[2] = fp[0] + nd.getData().floatValue();
        fp[3] = fp[1];
        aff.transform(fp, 0, fp, 0, 2);
        fp[3] = (float)Math.sqrt(Math.pow(fp[2] - fp[0], 2.0) + Math.pow(fp[3] - fp[1], 2.0));
        fp[2] = (float)(nd.getLayer().getZ() * zScale);
    }

    private static final void writeSomaSegment(Writer w, float[] root) throws IOException {
        w.write("  <segment id=\"0\" name=\"0\" cable=\"0\">\n");
        String sx = Float.toString(root[0]);
        String sy = Float.toString(root[1]);
        String sz = Float.toString(root[2]);
        String sd = Float.toString(Math.max(1.0f, 2.0f * root[3]));
        w.write("   <proximal x=\"");
        w.write(sx);
        w.write("\" y=\"");
        w.write(sy);
        w.write("\" z=\"");
        w.write(sz);
        w.write("\" diameter=\"");
        w.write(sd);
        w.write("\"/>\n   <distal x=\"");
        w.write(sx);
        w.write("\" y=\"");
        w.write(sy);
        w.write("\" z=\"");
        w.write(sz);
        w.write("\" diameter=\"");
        w.write(sd);
        w.write("\"/>\n  </segment>\n");
    }

    private static final void writeCableSegment(Writer w, float[] seg, long segId, long parentId, float[] parentCoords, String sCableId) throws IOException {
        String sid = Long.toString(segId);
        w.write("  <segment id=\"");
        w.write(sid);
        w.write("\" name=\"");
        w.write(sid);
        w.write("\" parent=\"");
        w.write(Long.toString(parentId));
        w.write("\" cable=\"");
        w.write(sCableId);
        w.write("\">\n");
        if (null != parentCoords) {
            w.write("   <proximal x=\"");
            w.write(Float.toString(parentCoords[0]));
            w.write("\" y=\"");
            w.write(Float.toString(parentCoords[1]));
            w.write("\" z=\"");
            w.write(Float.toString(parentCoords[2]));
            w.write("\" diameter=\"");
            w.write(Float.toString(Math.max(1.0f, parentCoords[3])));
            w.write("\"/>\n");
        }
        w.write("   <distal x=\"");
        w.write(Float.toString(seg[0]));
        w.write("\" y=\"");
        w.write(Float.toString(seg[1]));
        w.write("\" z=\"");
        w.write(Float.toString(seg[2]));
        w.write("\" diameter=\"");
        w.write(Float.toString(Math.max(1.0f, seg[3])));
        w.write("\"/>\n  </segment>\n");
    }

    private static final void collectConnectors(Node<?> node, Tree<?> t, float[] nodeWorldCoords, long segmentId, List<HalfSynapse> pre, List<HalfSynapse> post) {
        for (Displayable d : t.getLayerSet().findZDisplayables(Connector.class, node.getLayer(), (int)nodeWorldCoords[0], (int)nodeWorldCoords[1], false)) {
            Connector c = (Connector)d;
            if (c.intersectsOrigin(nodeWorldCoords[0], nodeWorldCoords[1], node.getLayer())) {
                pre.add(new HalfSynapse(c, t, node, segmentId));
                continue;
            }
            post.add(new HalfSynapse(c, t, node, segmentId));
        }
    }

    private static final double scaleToMicrometers(Calibration cal) {
        double scale;
        String unit = cal.getUnit().trim().toLowerCase();
        if (unit.equals("nanometer") || unit.equals("nm")) {
            scale = 0.001;
        } else if (unit.equals("micrometer") || unit.equals("\u00b5m") || unit.equals("um")) {
            scale = 1.0;
        } else if (unit.equals("milimeter") || unit.equals("mm")) {
            scale = 1000.0;
        } else if (unit.equals("meter") || unit.equals("m")) {
            scale = 1000000.0;
        } else {
            scale = 1.0;
            Utils.logAll("UNKNOWN unit '" + unit + "' -- using scale of 1.");
        }
        return scale;
    }

    public static final void exportMorphML(Collection<Tree<?>> trees, Writer w) throws Exception {
        NeuroML.exportMorphML(new HashSet(trees), w);
    }

    public static final void exportMorphML(Set<Tree<?>> trees, Writer w) throws Exception {
        if (trees.isEmpty()) {
            return;
        }
        w.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        w.write("<!-- Exported from TrakEM2 '" + Utils.version + "' at " + new Date() + "\nTrakEM2 software by Albert Cardona, Institute of Neuroinformatics of the University of Zurich and ETH Zurich -->\n");
        w.write("<morphml xmlns=\"http://morphml.org/morphml/schema\"\n");
        w.write("  xmlns:meta=\"http://morphml.org/metadata/schema\"\n");
        w.write("  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        w.write("  xsi:schemaLocation=\"http://morphml.org/morphml/schema http://www.neuroml.org/NeuroMLValidator/NeuroMLFiles/Schemata/v1.8.1/Level1/MorphML_v1.8.1.xsd\"\n");
        w.write("  length_units=\"micrometer\">\n<cells>\n");
        Calibration cal = trees.iterator().next().getLayerSet().getCalibration();
        double scale = NeuroML.scaleToMicrometers(cal);
        AffineTransform scale2d = new AffineTransform(cal.pixelWidth * scale, 0.0, 0.0, cal.pixelHeight * scale, 0.0, 0.0);
        double zScale = cal.pixelWidth * scale;
        for (Tree<?> t : trees) {
            if (null == t.getRoot()) continue;
            NeuroML.exportMorphMLCell(w, t, trees, null, null, scale2d, zScale);
        }
        w.write("</cells>\n</morphml>\n");
    }

    public static final void exportNeuroML(Collection<Tree<?>> trees, Writer w) throws Exception {
        NeuroML.exportNeuroML(new HashSet(trees), w);
    }

    public static final void exportNeuroML(Set<Tree<?>> trees, Writer w) throws Exception {
        if (trees.isEmpty()) {
            return;
        }
        w.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!-- Exported from TrakEM2 '" + Utils.version + "' at " + new Date() + "\nTrakEM2 software by Albert Cardona, Institute of Neuroinformatics of the University of Zurich and ETH Zurich -->\n<neuroml xmlns=\"http://morphml.org/neuroml/schema\"\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n xmlns:net=\"http://morphml.org/networkml/schema\"\n xmlns:mml=\"http://morphml.org/morphml/schema\"\n xmlns:meta=\"http://morphml.org/metadata/schema\"\n xmlns:bio=\"http://morphml.org/biophysics/schema\"\n xmlns:cml=\"http://morphml.org/channelml/schema\"\n xsi:schemaLocation=\"http://morphml.org/neuroml/schema http://www.neuroml.org/NeuroMLValidator/NeuroMLFiles/Schemata/v1.8.1/Level3/NeuroML_Level3_v1.8.1.xsd\"\n length_units=\"micrometer\">\n");
        ArrayList<HalfSynapse> presynaptic = new ArrayList<HalfSynapse>();
        ArrayList<HalfSynapse> postsynaptic = new ArrayList<HalfSynapse>();
        Calibration cal = trees.iterator().next().getLayerSet().getCalibration();
        double scale = NeuroML.scaleToMicrometers(cal);
        AffineTransform scale2d = new AffineTransform(cal.pixelWidth * scale, 0.0, 0.0, cal.pixelHeight * scale, 0.0, 0.0);
        double zScale = cal.pixelWidth * scale;
        w.write("<cells>\n");
        for (Tree<?> t : trees) {
            if (null == t.getRoot()) continue;
            NeuroML.exportMorphMLCell(w, t, trees, presynaptic, postsynaptic, scale2d, zScale);
        }
        w.write("</cells>\n");
        w.write("<populations xmlns=\"http://morphml.org/networkml/schema\">\n");
        for (Tree<?> t : trees) {
            w.write(" <population name=\"p");
            String sid = Long.toString(t.getId());
            w.write(sid);
            w.write("\" cell_type=\"t");
            w.write(sid);
            w.write("\">\n  <instances size=\"1\">\n   <instance id=\"0\"><location x=\"0\" y=\"0\" z=\"0\"/></instance>\n  </instances>\n </population>\n");
        }
        w.write("</populations>\n");
        w.write("<projections units=\"Physiological Units\" xmlns=\"http://morphml.org/networkml/schema\">\n");
        HashMap<Connector, HalfSynapse> cpre = new HashMap<Connector, HalfSynapse>();
        for (HalfSynapse syn : presynaptic) {
            cpre.put(syn.c, syn);
        }
        HashMap<TreePair, ArrayList<Synapse>> pairs = new HashMap<TreePair, ArrayList<Synapse>>();
        for (HalfSynapse halfSynapse : postsynaptic) {
            HalfSynapse pre = (HalfSynapse)cpre.get(halfSynapse.c);
            if (null == pre) continue;
            TreePair pair = new TreePair(pre.t, halfSynapse.t);
            ArrayList<Synapse> ls = (ArrayList<Synapse>)pairs.get(pair);
            if (null == ls) {
                ls = new ArrayList<Synapse>();
                pairs.put(pair, ls);
            }
            ls.add(new Synapse(pre, halfSynapse));
        }
        for (Map.Entry entry : pairs.entrySet()) {
            TreePair pair = (TreePair)entry.getKey();
            w.write("  <projection name=\"NetworkConnection\" source=\"p");
            w.write(Long.toString(pair.source.getId()));
            w.write("\" target=\"p");
            w.write(Long.toString(pair.target.getId()));
            w.write("\">\n");
            w.write("   <synapse_props synapse_type=\"DoubExpSynA\" internal_delay=\"5\" weight=\"1\" threshold=\"-20\"/>\n");
            w.write("   <connections size=\"");
            List ls = (List)entry.getValue();
            w.write(Integer.toString(ls.size()));
            w.write("\">\n");
            int cid = 0;
            for (Synapse syn : ls) {
                w.write("    <connection id=\"");
                w.write(Integer.toString(cid));
                w.write("\" pre_cell_id=\"0\" pre_segment_id=\"");
                w.write(Long.toString(syn.pre.segmentId));
                w.write("\" pre_fraction_along=\"0.5\" post_cell_id=\"0\" post_segment_id=\"");
                w.write(Long.toString(syn.post.segmentId));
                w.write("\"/>\n");
                ++cid;
            }
            w.write("   </connections>\n");
            w.write("  </projection>\n");
        }
        w.write(" </projections>\n");
        w.write("</neuroml>\n");
    }

    private static final void exportMorphMLCell(Writer w, Tree<?> t, Set<Tree<?>> trees, List<HalfSynapse> pre, List<HalfSynapse> post, AffineTransform scale2d, double zScale) throws Exception {
        if (t instanceof Treeline) {
            NeuroML.exportMorphMLCell(w, (Treeline)t, trees, pre, post, scale2d, zScale);
        } else if (t instanceof AreaTree) {
            NeuroML.exportMorphMLCell(w, Tree.copyAs((AreaTree)t, Treeline.class, Treeline.RadiusNode.class), trees, pre, post, scale2d, zScale);
        }
    }

    private static final void exportMorphMLCell(Writer w, Treeline t, Set<Tree<?>> trees, List<HalfSynapse> pre, List<HalfSynapse> post, AffineTransform scale2d, double zScale) throws IOException {
        float[] fp = new float[4];
        AffineTransform aff = new AffineTransform(t.getAffineTransform());
        aff.preConcatenate(scale2d);
        NeuroML.writeCellHeader(w, t);
        HashMap<Node<Float>, Long> nodeIds = new HashMap<Node<Float>, Long>();
        HashMap<Node<Float>, Object> nodeCoords = new HashMap<Node<Float>, Object>();
        long nextSegmentId = 0L;
        long cableId = 0L;
        Node<Float> root = t.getRoot();
        NeuroML.toPoint(root, fp, aff, zScale);
        NeuroML.writeSomaSegment(w, fp);
        if (null != pre) {
            NeuroML.collectConnectors(root, t, fp, 0L, pre, post);
        }
        nodeIds.put(root, nextSegmentId);
        nodeCoords.put(root, fp.clone());
        ++nextSegmentId;
        ++cableId;
        HashSet<Long> somaCables = new HashSet<Long>();
        for (Node<Float> node : t.getRoot().getBranchAndEndNodes()) {
            List slab = NeuroML.cable(node);
            String sCableId = Long.toString(cableId);
            Node parent = slab.get(slab.size() - 1).getParent();
            long parentId = (Long)nodeIds.get(parent);
            float[] parentCoords = (float[])nodeCoords.get(parent);
            if (0L == parentId) {
                somaCables.add(cableId);
            }
            ListIterator it = slab.listIterator(slab.size());
            while (it.hasPrevious()) {
                Node<Float> seg = it.previous();
                NeuroML.toPoint(seg, fp, aff, zScale);
                NeuroML.writeCableSegment(w, fp, nextSegmentId, parentId, parentCoords, sCableId);
                if (null != pre) {
                    NeuroML.collectConnectors(seg, t, fp, nextSegmentId, pre, post);
                }
                parentId = nextSegmentId++;
                parentCoords = null;
            }
            if (node.getChildrenCount() > 1) {
                nodeIds.put(node, parentId);
                float[] fpCopy = new float[4];
                NeuroML.toPoint(node, fpCopy, aff, zScale);
                nodeCoords.put(node, fpCopy);
            }
            ++cableId;
        }
        w.write(" </segments>\n");
        w.write(" <cables xmlns=\"http://morphml.org/morphml/schema\">\n");
        w.write("  <cable id=\"0\" name=\"Soma\">\n   <meta:group>soma_group</meta:group>\n  </cable>\n");
        for (long i = 1L; i < cableId; ++i) {
            String sid = Long.toString(i);
            w.write("  <cable id=\"");
            w.write(sid);
            w.write("\" name=\"");
            w.write(sid);
            if (somaCables.contains(i)) {
                w.write("\" fract_along_parent=\"0.5");
            } else {
                w.write("\" fract_along_parent=\"1.0");
            }
            w.write("\">\n   <meta:group>arbor_group</meta:group>\n  </cable>\n");
        }
        w.write(" </cables>\n</cell>\n");
    }

    private static final class TreePair {
        final Tree<?> source;
        final Tree<?> target;

        TreePair(Tree<?> source, Tree<?> target) {
            this.source = source;
            this.target = target;
        }

        public final boolean equals(Object ob) {
            TreePair p = (TreePair)ob;
            return this.source == p.source && this.target == p.target;
        }
    }

    private static final class Synapse {
        private final HalfSynapse pre;
        private final HalfSynapse post;

        Synapse(HalfSynapse pre, HalfSynapse post) {
            this.pre = pre;
            this.post = post;
        }
    }

    private static final class HalfSynapse {
        private Connector c;
        private Tree<?> t;
        private Node<?> node;
        private long segmentId;

        HalfSynapse(Connector c, Tree<?> t, Node<?> node, long segmentId) {
            this.c = c;
            this.t = t;
            this.node = node;
            this.segmentId = segmentId;
        }
    }
}

