/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.pixel_feature.calculator;

import java.util.Arrays;
import java.util.List;
import net.imglib2.RandomAccessible;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.Views;
import sc.fiji.labkit.pixel_classification.pixel_feature.calculator.ColorInputPreprocessor;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.GlobalSettings;

public class DeprecatedColorInputPreprocessor
extends ColorInputPreprocessor {
    public DeprecatedColorInputPreprocessor(GlobalSettings globals) {
        super(globals);
    }

    @Override
    protected List<RandomAccessible<FloatType>> processARGBType(RandomAccessible<ARGBType> image) {
        if (image.numDimensions() != this.globals.numDimensions()) {
            throw new IllegalArgumentException("Input image must have " + this.globals.numDimensions() + " dimensions.");
        }
        Converter r = (in, out) -> out.setReal((float)ARGBType.red((int)in.get()) / 255.0f);
        Converter g = (in, out) -> out.setReal((float)ARGBType.green((int)in.get()) / 255.0f);
        Converter b = (in, out) -> out.setReal((float)ARGBType.blue((int)in.get()) / 255.0f);
        return Arrays.asList(Converters.convert(image, (Converter)r, (Type)new FloatType()), Converters.convert(image, (Converter)g, (Type)new FloatType()), Converters.convert(image, (Converter)b, (Type)new FloatType()));
    }

    @Override
    protected List<RandomAccessible<FloatType>> processRealType(RandomAccessible<FloatType> image) {
        int colorAxis = this.globals.numDimensions();
        if (image.numDimensions() != colorAxis + 1) {
            throw new IllegalArgumentException("Input image must have " + this.globals.numDimensions() + " dimensions plus one color channel.");
        }
        return Arrays.asList(this.sliceAndScale(image, colorAxis, 0), this.sliceAndScale(image, colorAxis, 1), this.sliceAndScale(image, colorAxis, 2));
    }

    private RandomAccessible<FloatType> sliceAndScale(RandomAccessible<FloatType> image, int colorAxis, int pos) {
        MixedTransformView slice = Views.hyperSlice(image, (int)colorAxis, (long)pos);
        Converter scale = (in, out) -> out.setReal(in.getRealFloat() / 255.0f);
        return Converters.convert((RandomAccessible)slice, (Converter)scale, (Type)new FloatType());
    }
}

