/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.display;

import net.imagej.Dataset;
import net.imagej.display.ImageCanvas;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ScreenCaptureService;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.display.Display;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.UIService;
import org.scijava.ui.viewer.DisplayViewer;
import org.scijava.ui.viewer.DisplayWindow;

@Plugin(type=Command.class, menu={@Menu(label="Plugins", weight=5.0, mnemonic=117), @Menu(label="Utilities"), @Menu(label="Capture Image", weight=21.0)}, attrs={@Attr(name="no-legacy")})
public class CaptureImage
extends ContextCommand {
    @Parameter
    private ScreenCaptureService captureService;
    @Parameter
    private UIService uiService;
    @Parameter
    private ImageDisplay display;
    @Parameter(type=ItemIO.OUTPUT)
    private Dataset output;

    public void setImageDisplay(ImageDisplay disp) {
        this.display = disp;
    }

    public ImageDisplay getImageDisplay() {
        return this.display;
    }

    public Dataset getOutput() {
        return this.output;
    }

    public void run() {
        DisplayViewer viewer = this.uiService.getDisplayViewer((Display)this.display);
        DisplayWindow window = viewer.getWindow();
        ImageCanvas canvas = this.display.getCanvas();
        int x = window.findDisplayContentScreenX();
        int y = window.findDisplayContentScreenY();
        int width = canvas.getViewportWidth();
        int height = canvas.getViewportHeight();
        this.output = this.captureService.captureScreenRegion(x, y, width, height);
        String name = this.display.getName();
        this.output.setName(name);
    }
}

