/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action.autonaming;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.TrackModel;
import fiji.plugin.trackmate.action.autonaming.AutoNamingRule;
import fiji.plugin.trackmate.graph.ConvexBranchesDecomposition;
import fiji.plugin.trackmate.graph.TimeDirectedNeighborIndex;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.Graphs;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.DepthFirstIterator;

public class AutoNamingPerformer {
    public static void autoNameSpots(Model model, AutoNamingRule rule) {
        TimeDirectedNeighborIndex neighborIndex = model.getTrackModel().getDirectedNeighborIndex();
        for (Integer trackID : model.getTrackModel().unsortedTrackIDs(true)) {
            ConvexBranchesDecomposition.TrackBranchDecomposition branchDecomposition = ConvexBranchesDecomposition.processTrack(trackID, model.getTrackModel(), neighborIndex, true, false);
            SimpleDirectedGraph<List<Spot>, DefaultEdge> branchGraph = ConvexBranchesDecomposition.buildBranchGraph(branchDecomposition);
            AutoNamingPerformer.processTrack(rule, model.getTrackModel(), branchGraph);
        }
    }

    private static void processTrack(AutoNamingRule rule, TrackModel model, SimpleDirectedGraph<List<Spot>, DefaultEdge> graph) {
        List roots = graph.vertexSet().stream().filter(key -> graph.incomingEdgesOf(key).size() == 0).collect(Collectors.toList());
        for (List root : roots) {
            Spot first = (Spot)root.get(0);
            rule.nameRoot(first, model);
            Spot predecessor = first;
            for (int i = 1; i < root.size(); ++i) {
                Spot current = (Spot)root.get(i);
                rule.nameSpot(current, predecessor);
                predecessor = current;
            }
            DepthFirstIterator it = new DepthFirstIterator(graph, (Object)root);
            while (it.hasNext()) {
                List cb;
                Object edge2;
                List currentBranch = (List)it.next();
                ArrayList<List> childrenBranches = new ArrayList<List>();
                Set edges = graph.outgoingEdgesOf((Object)currentBranch);
                for (Object edge2 : edges) {
                    cb = (List)Graphs.getOppositeVertex(graph, (Object)edge2, (Object)currentBranch);
                    childrenBranches.add(cb);
                }
                ArrayList<Spot> siblings = new ArrayList<Spot>(childrenBranches.size());
                edge2 = childrenBranches.iterator();
                while (edge2.hasNext()) {
                    cb = (List)edge2.next();
                    siblings.add((Spot)cb.get(0));
                }
                Spot mother = (Spot)currentBranch.get(currentBranch.size() - 1);
                rule.nameBranches(mother, siblings);
                for (List cb2 : childrenBranches) {
                    Spot parent = (Spot)cb2.get(0);
                    for (int i = 1; i < cb2.size(); ++i) {
                        Spot current = (Spot)cb2.get(i);
                        rule.nameSpot(current, parent);
                        parent = current;
                    }
                }
            }
        }
    }
}

