/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.features.spot;

import fiji.plugin.trackmate.Dimension;
import fiji.plugin.trackmate.features.spot.SpotAnalyzer;
import fiji.plugin.trackmate.features.spot.SpotAnalyzerFactory;
import fiji.plugin.trackmate.features.spot.SpotContrastAndSNRAnalyzer;
import fiji.plugin.trackmate.features.spot.SpotIntensityMultiCAnalyzerFactory;
import fiji.plugin.trackmate.util.TMUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import net.imagej.ImgPlus;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=SpotAnalyzerFactory.class, priority=-100.0)
public class SpotContrastAndSNRAnalyzerFactory<T extends RealType<T> & NativeType<T>>
implements SpotAnalyzerFactory<T> {
    public static final String CONTRAST = "CONTRAST_CH";
    public static final String SNR = "SNR_CH";
    private static final String CONTRAST_NAME = "Contrast ch";
    private static final String SNR_NAME = "Signal/Noise ratio ch";
    private static final String CONTRAST_SHORTNAME = "Ctrst ch";
    private static final String SNR_SHORTNAME = "SNR ch";
    private static final List<String> FEATURES = Arrays.asList("CONTRAST_CH", "SNR_CH");
    private static final List<String> FEATURE_SHORTNAMES = Arrays.asList("Ctrst ch", "SNR ch");
    private static final List<String> FEATURE_NAMES = Arrays.asList("Contrast ch", "Signal/Noise ratio ch");
    public static final String KEY = "Spot contrast and SNR";
    private int nChannels = 1;

    @Override
    public SpotAnalyzer<T> getAnalyzer(ImgPlus<T> img, int frame, int channel) {
        ImgPlus<T> imgTC = TMUtils.hyperSlice(img, channel, frame);
        return new SpotContrastAndSNRAnalyzer<T>(imgTC, channel);
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public List<String> getFeatures() {
        ArrayList<String> features = new ArrayList<String>(this.nChannels * FEATURES.size());
        for (int c = 0; c < this.nChannels; ++c) {
            for (String feature : FEATURES) {
                features.add(SpotIntensityMultiCAnalyzerFactory.makeFeatureKey(feature, c));
            }
        }
        return features;
    }

    @Override
    public Map<String, String> getFeatureShortNames() {
        LinkedHashMap<String, String> names = new LinkedHashMap<String, String>(this.nChannels * FEATURES.size());
        for (int c = 0; c < this.nChannels; ++c) {
            for (int i = 0; i < FEATURES.size(); ++i) {
                String feature = FEATURES.get(i);
                String shortName = FEATURE_SHORTNAMES.get(i);
                names.put(SpotIntensityMultiCAnalyzerFactory.makeFeatureKey(feature, c), SpotIntensityMultiCAnalyzerFactory.makeFeatureKey(shortName, c));
            }
        }
        return names;
    }

    @Override
    public Map<String, String> getFeatureNames() {
        LinkedHashMap<String, String> names = new LinkedHashMap<String, String>(this.nChannels * FEATURES.size());
        for (int c = 0; c < this.nChannels; ++c) {
            for (int i = 0; i < FEATURES.size(); ++i) {
                String feature = FEATURES.get(i);
                String shortName = FEATURE_NAMES.get(i);
                names.put(SpotIntensityMultiCAnalyzerFactory.makeFeatureKey(feature, c), SpotIntensityMultiCAnalyzerFactory.makeFeatureKey(shortName, c));
            }
        }
        return names;
    }

    @Override
    public Map<String, Dimension> getFeatureDimensions() {
        List<String> features = this.getFeatures();
        LinkedHashMap<String, Dimension> dimensions = new LinkedHashMap<String, Dimension>(features.size());
        for (String feature : features) {
            dimensions.put(feature, Dimension.NONE);
        }
        return dimensions;
    }

    @Override
    public Map<String, Boolean> getIsIntFeature() {
        List<String> features = this.getFeatures();
        LinkedHashMap<String, Boolean> isints = new LinkedHashMap<String, Boolean>(features.size());
        for (String feature : features) {
            isints.put(feature, Boolean.FALSE);
        }
        return isints;
    }

    @Override
    public String getInfoText() {
        return null;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getName() {
        return KEY;
    }

    @Override
    public boolean isManualFeature() {
        return false;
    }

    @Override
    public void setNChannels(int nChannels) {
        this.nChannels = nChannels;
    }
}

