/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.editor.labkit.component;

import bdv.ui.keymap.Keymap;
import bdv.ui.splitpanel.SplitPanel;
import bdv.util.BdvHandle;
import bdv.util.BdvHandlePanel;
import bdv.util.BdvOptions;
import bdv.util.BdvSource;
import bdv.util.BdvStackSource;
import bdv.viewer.AbstractViewerPanel;
import bdv.viewer.DisplayMode;
import bdv.viewer.NavigationActions;
import bdv.viewer.ViewerPanel;
import fiji.plugin.trackmate.detection.DetectionUtils;
import fiji.plugin.trackmate.gui.editor.labkit.component.TMBdvLayerLink;
import fiji.plugin.trackmate.gui.editor.labkit.component.TMFloodFillController;
import fiji.plugin.trackmate.gui.editor.labkit.component.TMLabKitFrame;
import fiji.plugin.trackmate.gui.editor.labkit.component.TMLabelBrushController;
import fiji.plugin.trackmate.gui.editor.labkit.component.TMLabelToolsPanel;
import fiji.plugin.trackmate.gui.editor.labkit.component.TMSelectLabelController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import net.imagej.ImgPlus;
import net.miginfocom.swing.MigLayout;
import org.scijava.plugin.Plugin;
import org.scijava.ui.behaviour.KeyStrokeAdder;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.io.gui.CommandDescriptionProvider;
import org.scijava.ui.behaviour.io.gui.CommandDescriptions;
import org.scijava.ui.behaviour.util.AbstractNamedAction;
import org.scijava.ui.behaviour.util.Actions;
import org.scijava.ui.behaviour.util.Behaviours;
import org.scijava.ui.behaviour.util.InputActionBindings;
import sc.fiji.labkit.ui.bdv.BdvAutoContrast;
import sc.fiji.labkit.ui.bdv.BdvLayer;
import sc.fiji.labkit.ui.labeling.Label;
import sc.fiji.labkit.ui.labeling.Labeling;
import sc.fiji.labkit.ui.labeling.LabelsLayer;
import sc.fiji.labkit.ui.models.Holder;
import sc.fiji.labkit.ui.models.ImageLabelingModel;
import sc.fiji.labkit.ui.models.LabelingModel;

public class TMBasicLabelingComponent
extends JPanel
implements AutoCloseable {
    private static final long serialVersionUID = 1L;
    private final Holder<BdvStackSource<?>> imageSource;
    private BdvHandle bdvHandle;
    private final JFrame dialogBoxOwner;
    private final ImageLabelingModel model;
    private JSlider zSlider;
    private TMLabelBrushController brushController;
    private TMFloodFillController floodFillController;
    private TMSelectLabelController selectLabelController;
    private TMLabelToolsPanel toolsPanel;

    public TMBasicLabelingComponent(JFrame dialogBoxOwner, ImageLabelingModel model, BdvOptions options) {
        this.model = model;
        this.dialogBoxOwner = dialogBoxOwner;
        this.initBdv(options);
        this.imageSource = this.initImageLayer();
        this.initLabelsLayer();
        this.initPanel();
        this.model.transformationModel().initialize(this.bdvHandle.getViewerPanel());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    TMBasicLabelingComponent.this.bdvHandle.getViewerPanel().requestFocusInWindow();
                }
            });
        }
    }

    private void initBdv(BdvOptions options) {
        this.bdvHandle = new BdvHandlePanel((Frame)this.dialogBoxOwner, options);
        ViewerPanel viewer = this.bdvHandle.getViewerPanel();
        viewer.setDisplayMode(DisplayMode.FUSED);
        InputTriggerConfig inputTriggerConfig = this.bdvHandle.getViewerPanel().getInputTriggerConfig();
        Actions navigationActions = new Actions((KeyStrokeAdder.Factory)inputTriggerConfig, new String[]{"bdv", "navigation"});
        InputActionBindings keybindings = this.bdvHandle.getKeybindings();
        navigationActions.install(keybindings, "navigation");
        NavigationActions.install((Actions)navigationActions, (AbstractViewerPanel)viewer, (boolean)options.values.is2D());
        Keymap keymap = this.bdvHandle.getKeymapManager().getForwardSelectedKeymap();
        keymap.updateListeners().add(() -> navigationActions.updateKeyConfig(keymap.getConfig()));
    }

    public BdvHandle getBdvHandle() {
        return this.bdvHandle;
    }

    private void initPanel() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][grow]"));
        this.zSlider = new JSlider(1);
        this.zSlider.setFocusable(false);
        this.add((Component)this.initToolsPanel(), "wrap, growx");
        JPanel bdvAndZSlider = new JPanel();
        bdvAndZSlider.setLayout(new BorderLayout());
        bdvAndZSlider.add((Component)this.bdvHandle.getSplitPanel());
        bdvAndZSlider.add((Component)this.zSlider, "After");
        this.add((Component)bdvAndZSlider, "grow");
    }

    private Holder<BdvStackSource<?>> initImageLayer() {
        return this.addBdvLayer((BdvLayer)new BdvLayer.FinalLayer(this.model.showable(), "Image", this.model.imageVisibility()));
    }

    private void initLabelsLayer() {
        this.addBdvLayer((BdvLayer)new LabelsLayer((LabelingModel)this.model));
    }

    public Holder<BdvStackSource<?>> addBdvLayer(BdvLayer layer) {
        return new TMBdvLayerLink(layer, this.bdvHandle);
    }

    private JPanel initToolsPanel() {
        this.brushController = new TMLabelBrushController(this.bdvHandle, (LabelingModel)this.model);
        this.floodFillController = new TMFloodFillController(this.bdvHandle, (LabelingModel)this.model);
        this.selectLabelController = new TMSelectLabelController(this.bdvHandle, this.model);
        this.toolsPanel = new TMLabelToolsPanel(this.brushController, this.floodFillController, this.selectLabelController);
        boolean is2D = DetectionUtils.is2D((ImgPlus)this.model.imageForSegmentation().get());
        if (is2D) {
            this.zSlider.setVisible(false);
        }
        this.floodFillController.setFloodEraseMode(TMFloodFillController.FloodEraseMode.REMOVE_ALL);
        this.floodFillController.setFloodFillMode(TMFloodFillController.FloodFillMode.REPLACE);
        return this.toolsPanel;
    }

    public void install(Actions actions, Behaviours behaviours) {
        this.toolsPanel.install(actions);
        this.brushController.install(actions, behaviours);
        this.floodFillController.install(behaviours);
        this.selectLabelController.install(behaviours);
        MyChangeLabelAction.install(actions, (LabelingModel)this.model);
    }

    @Override
    public void close() {
        this.bdvHandle.close();
    }

    public void autoContrast() {
        BdvAutoContrast.autoContrast((BdvSource)((BdvSource)this.imageSource.get()));
    }

    public void toggleContrastSettings() {
        SplitPanel splitPanel;
        splitPanel.setCollapsed(!(splitPanel = this.bdvHandle.getSplitPanel()).isCollapsed());
    }

    public static class MyChangeLabelAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = 1L;
        private static final String NEXT_LABEL = "next label";
        private static final String PREVIOUS_LABEL = "previous label";
        private static final String[] NEXT_LABEL_KEYS = new String[]{"N"};
        private static final String[] PREVIOUS_LABEL_KEYS = new String[]{"P"};
        private final LabelingModel model;
        private final boolean next;

        public MyChangeLabelAction(LabelingModel model, boolean next) {
            super(next ? NEXT_LABEL : PREVIOUS_LABEL);
            this.model = model;
            this.next = next;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Label nextLabel;
            List labels = ((Labeling)this.model.labeling().get()).getLabels();
            Label label = nextLabel = this.next ? this.next(labels, (Label)this.model.selectedLabel().get()) : this.previous(labels, (Label)this.model.selectedLabel().get());
            if (nextLabel != null) {
                this.model.selectedLabel().set((Object)nextLabel);
            }
        }

        private Label next(List<Label> labels, Label currentLabel) {
            if (labels.isEmpty()) {
                return null;
            }
            int index = labels.indexOf(currentLabel) + 1;
            if (index >= labels.size()) {
                index = 0;
            }
            return labels.get(index);
        }

        private Label previous(List<Label> labels, Label currentLabel) {
            if (labels.isEmpty()) {
                return null;
            }
            int index = labels.indexOf(currentLabel) - 1;
            if (index < 0) {
                index = labels.size() - 1;
            }
            return labels.get(index);
        }

        public static void install(Actions actions, LabelingModel model) {
            actions.namedAction((AbstractNamedAction)new MyChangeLabelAction(model, true), NEXT_LABEL_KEYS);
            actions.namedAction((AbstractNamedAction)new MyChangeLabelAction(model, false), PREVIOUS_LABEL_KEYS);
        }

        @Plugin(type=CommandDescriptionProvider.class)
        public static class Descriptions
        extends CommandDescriptionProvider {
            public Descriptions() {
                super(TMLabKitFrame.KEY_CONFIG_SCOPE, new String[]{"trackmate-labkit"});
            }

            public void getCommandDescriptions(CommandDescriptions descriptions) {
                descriptions.add(MyChangeLabelAction.NEXT_LABEL, NEXT_LABEL_KEYS, "Select the next label in the list.");
                descriptions.add(MyChangeLabelAction.PREVIOUS_LABEL, PREVIOUS_LABEL_KEYS, "Select the previous label in the list.");
            }
        }
    }
}

