/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.wizard.descriptors;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import fiji.plugin.trackmate.gui.wizard.WizardPanelDescriptor;
import fiji.plugin.trackmate.io.SettingsPersistence;
import fiji.plugin.trackmate.util.TMUtils;

public class SpotDetectorDescriptor
extends WizardPanelDescriptor {
    public static final String KEY = "ConfigureDetector";
    private final Settings settings;
    private final Logger logger;

    public SpotDetectorDescriptor(Settings settings, ConfigurationPanel configurationPanel, Logger logger) {
        super(KEY);
        this.settings = settings;
        this.targetPanel = configurationPanel;
        this.logger = logger;
    }

    @Override
    public void aboutToHidePanel() {
        ConfigurationPanel configurationPanel = (ConfigurationPanel)this.targetPanel;
        this.settings.detectorSettings = configurationPanel.getSettings();
        this.logger.log("\nConfigured detector ");
        this.logger.log(this.settings.detectorFactory.getName(), Logger.BLUE_COLOR);
        this.logger.log(" with settings:\n");
        this.logger.log(TMUtils.echoMap(this.settings.detectorSettings, 2) + "\n");
        SettingsPersistence.saveLastUsedSettings(this.settings, this.logger);
    }
}

