/*
 * Decompiled with CFR 0.152.
 */
package vib;

import amira.AmiraParameters;
import amira.AmiraTable;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.text.TextPanel;
import ij.util.Tools;
import java.util.ArrayList;
import math3d.Point3d;
import vib.FastMatrix;

public class Center_Transformation
implements PlugIn {
    public void run(String arg) {
        GenericDialog gd = new GenericDialog("Center Transformation");
        AmiraParameters.addAmiraTableList((GenericDialog)gd, (String)"Model table");
        AmiraParameters.addAmiraTableList((GenericDialog)gd, (String)"Template table");
        gd.addNumericField("radius", 10.0, 2);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String titleM = gd.getNextChoice();
        String titleT = gd.getNextChoice();
        float radius = (float)gd.getNextNumber();
        AmiraTable tableModel = (AmiraTable)WindowManager.getFrame((String)titleM);
        AmiraTable tableTemplate = (AmiraTable)WindowManager.getFrame((String)titleT);
        Center_Transformation.bestRigid(tableModel, tableTemplate);
    }

    public static FastMatrix bestRigid(AmiraTable tModel, AmiraTable tTemplate) {
        Point3d[] setModel = Center_Transformation.getList(tModel);
        Point3d[] setTemplate = Center_Transformation.getList(tTemplate);
        FastMatrix transform = FastMatrix.bestRigid((Point3d[])setModel, (Point3d[])setTemplate, (boolean)false);
        String templName = tTemplate.getTitle();
        templName = templName.substring(0, templName.lastIndexOf(46));
        String key = templName + "SCenterTransformation";
        String value = transform.toStringForAmira();
        tModel.getProperties().put(key, value);
        return transform;
    }

    public static Point3d[] getList(AmiraTable table) {
        TextPanel panel = table.getTextPanel();
        int count = panel.getLineCount();
        ArrayList<Point3d> points = new ArrayList<Point3d>();
        for (int i = 1; i < count; ++i) {
            String[] line = Tools.split((String)panel.getLine(i), (String)"\t");
            int voxelCount = Integer.parseInt(line[2]);
            if (voxelCount == 0) continue;
            points.add(new Point3d(Double.parseDouble(line[4]), Double.parseDouble(line[5]), Double.parseDouble(line[6])));
        }
        return points.toArray(new Point3d[0]);
    }
}

