/*
 * Decompiled with CFR 0.152.
 */
package vib.oldregistration;

import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import vib.transforms.Threshold;

class IntensityMap
implements PlugInFilter {
    private ImagePlus image;
    private String arg;
    private int[] domainToTemplate;
    private int[] templateToDomain;

    IntensityMap() {
    }

    public static int[] histogramToCumulative(int[] valueHistogram) {
        int[] cumulative = new int[valueHistogram.length];
        int acc = 0;
        for (int i = 0; i < valueHistogram.length; ++i) {
            cumulative[i] = acc += valueHistogram[i];
        }
        return cumulative;
    }

    public int setup(String arg, ImagePlus image) {
        this.image = image;
        return 1;
    }

    public void run(ImageProcessor ip) {
        ImageStack stack = this.image.getStack();
        for (int z = 0; z < this.image.getStackSize(); ++z) {
            byte[] pixels = (byte[])stack.getPixels(z + 1);
            for (int i = 0; i < pixels.length; ++i) {
                int v = this.domainToTemplate[pixels[i] & 0xFF];
                pixels[i] = (byte)v;
            }
            stack.setPixels((Object)pixels, z + 1);
        }
    }

    public static IntensityMap fromHistograms(int[] valueHistogramTemplate, int[] valueHistogramDomain) {
        return IntensityMap.fromHistograms(valueHistogramTemplate, valueHistogramDomain, new Threshold(0, 0L), new Threshold(0, 0L));
    }

    public static IntensityMap fromHistograms(int[] valueHistogramTemplateOriginal, int[] valueHistogramDomainOriginal, Threshold thresholdTemplate, Threshold thresholdDomain) {
        int i;
        int i2;
        int i3;
        IntensityMap result = new IntensityMap();
        int[] valueHistogramTemplate = (int[])valueHistogramTemplateOriginal.clone();
        int[] valueHistogramDomain = (int[])valueHistogramDomainOriginal.clone();
        for (i3 = 0; i3 < thresholdTemplate.value; ++i3) {
            valueHistogramTemplate[i3] = 0;
        }
        for (i3 = 0; i3 < thresholdDomain.value; ++i3) {
            valueHistogramDomain[i3] = 0;
        }
        int[] cumulativeTemplate = IntensityMap.histogramToCumulative(valueHistogramTemplate);
        int[] cumulativeDomain = IntensityMap.histogramToCumulative(valueHistogramDomain);
        long pointsInTemplate = cumulativeTemplate[cumulativeTemplate.length - 1];
        long pointsInDomain = cumulativeDomain[cumulativeDomain.length - 1];
        float[] cumulativeProportionsTemplate = new float[cumulativeTemplate.length];
        float[] cumulativeProportionsDomain = new float[cumulativeDomain.length];
        for (i2 = 0; i2 < cumulativeTemplate.length; ++i2) {
            cumulativeProportionsTemplate[i2] = (float)cumulativeTemplate[i2] / (float)pointsInTemplate;
        }
        for (i2 = 0; i2 < cumulativeDomain.length; ++i2) {
            cumulativeProportionsDomain[i2] = (float)cumulativeDomain[i2] / (float)pointsInDomain;
        }
        int[] domainToTemplate = new int[valueHistogramDomain.length];
        int[] templateToDomain = new int[valueHistogramTemplate.length];
        int j = thresholdTemplate.value;
        for (i = thresholdDomain.value; i < valueHistogramDomain.length; ++i) {
            float propGEinDomain = cumulativeProportionsDomain[i];
            while (propGEinDomain > cumulativeProportionsTemplate[j]) {
                ++j;
            }
            domainToTemplate[i] = j;
        }
        j = 0;
        for (i = 1; i < valueHistogramTemplate.length; ++i) {
            float propGEinTemplate = cumulativeProportionsTemplate[i];
            while (propGEinTemplate > cumulativeProportionsDomain[j]) {
                ++j;
            }
            templateToDomain[i] = j;
        }
        result.domainToTemplate = domainToTemplate;
        result.templateToDomain = templateToDomain;
        return result;
    }
}

