/*
 * Decompiled with CFR 0.152.
 */
package org.smurn.jply;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.smurn.jply.Element;
import org.smurn.jply.ElementReader;
import org.smurn.jply.ElementType;
import org.smurn.jply.ListProperty;
import org.smurn.jply.Property;

class AsciiElementReader
implements ElementReader {
    private final ElementType type;
    private final BufferedReader reader;
    private final int count;
    private int nextRow = 0;
    private boolean closed = false;

    AsciiElementReader(ElementType type, int count, BufferedReader reader) {
        if (type == null) {
            throw new NullPointerException("definition must not be null.");
        }
        if (reader == null) {
            throw new NullPointerException("reader must not be null.");
        }
        this.type = type;
        this.count = count;
        this.reader = reader;
    }

    @Override
    public ElementType getElementType() {
        return this.type;
    }

    @Override
    public Element readElement() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Reader is closed.");
        }
        if (this.nextRow >= this.getCount()) {
            return null;
        }
        String line = this.reader.readLine();
        if (line == null) {
            throw new IOException("Unexpected end of file.");
        }
        line = line.trim();
        String[] parts = line.split(" +");
        double[] numbers = new double[parts.length];
        int i = 0;
        while (i < parts.length) {
            numbers[i] = Double.parseDouble(parts[i]);
            ++i;
        }
        int pos = 0;
        List<Property> properties = this.type.getProperties();
        double[][] values = new double[properties.size()][];
        int propI = 0;
        while (propI < properties.size()) {
            Property property = properties.get(propI);
            if (property instanceof ListProperty) {
                if (Math.abs((double)Math.round(numbers[pos]) - numbers[pos]) > 1.0E-6) {
                    throw new IOException("array size is not integer.");
                }
                int valueCount = (int)Math.round(numbers[pos++]);
                values[propI] = Arrays.copyOfRange(numbers, pos, pos + valueCount);
                pos += valueCount;
            } else {
                values[propI] = new double[]{numbers[pos++]};
            }
            ++propI;
        }
        if (pos != numbers.length) {
            throw new IOException("Invalid PLY format. To many values for an element.");
        }
        ++this.nextRow;
        return new Element(values, this.type);
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public void close() throws IOException {
        while (this.nextRow < this.getCount()) {
            String line = this.reader.readLine();
            if (line == null) {
                throw new IOException("Unexpected end of file.");
            }
            ++this.nextRow;
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

