/*
 * Decompiled with CFR 0.152.
 */
package de.biomedical_imaging.ij.steger;

import de.biomedical_imaging.ij.steger.Convol;
import de.biomedical_imaging.ij.steger.Correct;
import de.biomedical_imaging.ij.steger.Line;
import de.biomedical_imaging.ij.steger.LinesUtil;
import de.biomedical_imaging.ij.steger.Offset;
import de.biomedical_imaging.ij.steger.Position;
import java.util.ArrayList;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableInt;

public class Width {
    public static final double LINE_WIDTH_COMPENSATION = 1.05;
    public static final double MIN_LINE_WIDTH = 0.1;
    public static final double MAX_CONTRAST = 275.0;

    public void bresenham(double nx, double ny, double px, double py, double length, Offset[] line, MutableInt num_points) {
        boolean xchg;
        int x = 0;
        int y = 0;
        double dx = Math.abs(nx);
        double dy = Math.abs(ny);
        int s1 = (int)Math.signum(nx);
        int s2 = (int)Math.signum(ny);
        px *= (double)s1;
        py *= (double)s2;
        if (dy > dx) {
            double t = dx;
            dx = dy;
            dy = t;
            t = px;
            px = py;
            py = t;
            xchg = true;
        } else {
            xchg = false;
        }
        int maxit = (int)Math.ceil(length * dx);
        double e = (0.5 - px) * dy / dx - (0.5 - py);
        int n = 0;
        for (int i = 0; i <= maxit; ++i) {
            line[n].x = x;
            line[n].y = y;
            ++n;
            while (e >= -1.0E-8) {
                if (xchg) {
                    x += s1;
                } else {
                    y += s2;
                }
                if (!((e -= 1.0) > -1.0)) continue;
                line[n].x = x;
                line[n].y = y;
                ++n;
            }
            if (xchg) {
                y += s2;
            } else {
                x += s1;
            }
            e += dy / dx;
        }
        num_points.setValue(n);
    }

    private void fill_gaps(double[] master, double[] slave1, double[] slave2, Line cont) {
        int num_points = cont.num;
        for (int i = 0; i < num_points; ++i) {
            double d_c;
            double d_r;
            int k;
            int e;
            int s;
            int j;
            if (master[i] != 0.0) continue;
            for (j = i + 1; j < num_points && !(master[j] > 0.0); ++j) {
            }
            double m_s = 0.0;
            double m_e = 0.0;
            double s1_s = 0.0;
            double s1_e = 0.0;
            double s2_s = 0.0;
            double s2_e = 0.0;
            if (i > 0 && j < num_points - 1) {
                s = i;
                e = j - 1;
                m_s = master[s - 1];
                m_e = master[e + 1];
                if (slave1 != null) {
                    s1_s = slave1[s - 1];
                    s1_e = slave1[e + 1];
                }
                if (slave2 != null) {
                    s2_s = slave2[s - 1];
                    s2_e = slave2[e + 1];
                }
            } else if (i > 0) {
                s = i;
                e = num_points - 2;
                m_s = master[s - 1];
                master[e + 1] = m_e = master[s - 1];
                if (slave1 != null) {
                    s1_s = slave1[s - 1];
                    slave1[e + 1] = s1_e = slave1[s - 1];
                }
                if (slave2 != null) {
                    s2_s = slave2[s - 1];
                    slave2[e + 1] = s2_e = slave2[s - 1];
                }
            } else if (j < num_points - 1) {
                s = 1;
                e = j - 1;
                m_s = master[e + 1];
                m_e = master[e + 1];
                master[s - 1] = m_s;
                if (slave1 != null) {
                    s1_s = slave1[e + 1];
                    s1_e = slave1[e + 1];
                    slave1[s - 1] = s1_s;
                }
                if (slave2 != null) {
                    s2_s = slave2[e + 1];
                    s2_e = slave2[e + 1];
                    slave2[s - 1] = s2_s;
                }
            } else {
                s = 1;
                e = num_points - 2;
                m_s = master[s - 1];
                m_e = master[e + 1];
                if (slave1 != null) {
                    s1_s = slave1[s - 1];
                    s1_e = slave1[e + 1];
                }
                if (slave2 != null) {
                    s2_s = slave2[s - 1];
                    s2_e = slave2[e + 1];
                }
            }
            double arc_len = 0.0;
            for (k = s; k <= e + 1; ++k) {
                d_r = cont.row[k] - cont.row[k - 1];
                d_c = cont.col[k] - cont.col[k - 1];
                arc_len += Math.sqrt(d_r * d_r + d_c * d_c);
            }
            double len = 0.0;
            for (k = s; k <= e; ++k) {
                d_r = cont.row[k] - cont.row[k - 1];
                d_c = cont.col[k] - cont.col[k - 1];
                master[k] = (arc_len - (len += Math.sqrt(d_r * d_r + d_c * d_c))) / arc_len * m_s + len / arc_len * m_e;
                if (slave1 != null) {
                    slave1[k] = (arc_len - len) / arc_len * s1_s + len / arc_len * s1_e;
                }
                if (slave2 == null) continue;
                slave2[k] = (arc_len - len) / arc_len * s2_s + len / arc_len * s2_e;
            }
            i = j;
        }
    }

    private void fix_locations(double[] width_l, double[] width_r, double[] grad_l, double[] grad_r, double[] pos_x, double[] pos_y, double[] correction, double[] contr, double[] asymm, double sigma, int mode, boolean correct_pos, Line cont) {
        int i;
        MutableDouble w_real = new MutableDouble();
        MutableDouble h_real = new MutableDouble();
        MutableDouble corr = new MutableDouble();
        MutableDouble w_strong = new MutableDouble();
        MutableDouble w_weak = new MutableDouble();
        Convol convol = new Convol();
        this.fill_gaps(width_l, grad_l, null, cont);
        this.fill_gaps(width_r, grad_r, null, cont);
        int num_points = cont.num;
        if (correct_pos) {
            boolean correct_start = (cont.getContourClass() == LinesUtil.contour_class.cont_no_junc || cont.getContourClass() == LinesUtil.contour_class.cont_end_junc || cont.getContourClass() == LinesUtil.contour_class.cont_closed) && width_r[0] > 0.0 && width_l[0] > 0.0;
            boolean correct_end = (cont.getContourClass() == LinesUtil.contour_class.cont_no_junc || cont.getContourClass() == LinesUtil.contour_class.cont_start_junc || cont.getContourClass() == LinesUtil.contour_class.cont_closed) && width_r[num_points - 1] > 0.0 && width_l[num_points - 1] > 0.0;
            for (i = 0; i < num_points; ++i) {
                boolean weak_is_r;
                double r_est;
                if (!(width_r[i] > 0.0) || !(width_l[i] > 0.0)) continue;
                double w_est = (width_r[i] + width_l[i]) * 1.05;
                if (grad_r[i] <= grad_l[i]) {
                    r_est = grad_r[i] / grad_l[i];
                    weak_is_r = true;
                } else {
                    r_est = grad_l[i] / grad_r[i];
                    weak_is_r = false;
                }
                Correct.line_corrections(sigma, w_est, r_est, w_real, h_real, corr, w_strong, w_weak);
                w_real.setValue(w_real.getValue() / 1.05);
                corr.setValue(corr.getValue() / 1.05);
                width_r[i] = w_real.getValue();
                width_l[i] = w_real.getValue();
                if (weak_is_r) {
                    asymm[i] = h_real.getValue();
                    correction[i] = -corr.getValue().doubleValue();
                    continue;
                }
                asymm[i] = -h_real.getValue().doubleValue();
                correction[i] = corr.getValue();
            }
            this.fill_gaps(width_l, correction, asymm, cont);
            for (i = 0; i < num_points; ++i) {
                width_r[i] = width_l[i];
            }
            if (!correct_start) {
                correction[0] = 0.0;
            }
            if (!correct_end) {
                correction[num_points - 1] = 0.0;
            }
            for (i = 0; i < num_points; ++i) {
                double px = pos_x[i];
                double py = pos_y[i];
                double nx = Math.cos(cont.angle[i]);
                double ny = Math.sin(cont.angle[i]);
                pos_x[i] = px += correction[i] * nx;
                pos_y[i] = py += correction[i] * ny;
            }
        }
        cont.width_l = new float[num_points];
        cont.width_r = new float[num_points];
        for (i = 0; i < num_points; ++i) {
            cont.width_l[i] = (float)width_l[i];
            cont.width_r[i] = (float)width_r[i];
            cont.row[i] = (float)pos_x[i];
            cont.col[i] = (float)pos_y[i];
        }
        if (correct_pos) {
            cont.asymmetry = new float[num_points];
            cont.intensity = new float[num_points];
            for (i = 0; i < num_points; ++i) {
                double response = cont.response[i];
                double asymmetry = Math.abs(asymm[i]);
                double correct = Math.abs(correction[i]);
                double width = cont.width_l[i];
                double contrast = width < 0.1 ? 0.0 : response / Math.abs(convol.phi2(correct + width, sigma) + (asymmetry - 1.0) * convol.phi2(correct - width, sigma));
                if (contrast > 275.0) {
                    contrast = 0.0;
                }
                contr[i] = contrast;
            }
            this.fill_gaps(contr, null, null, cont);
            for (i = 0; i < num_points; ++i) {
                cont.asymmetry[i] = (float)asymm[i];
                cont.intensity[i] = mode == 1 ? (float)contr[i] : (float)(-contr[i]);
            }
        }
    }

    public void compute_line_width(float[] dx, float[] dy, int width, int height, double sigma, int mode, boolean correct_pos, ArrayList<Line> contours, MutableInt num_contours) {
        int c;
        int r;
        int num_points;
        int i;
        int num_line = 0;
        double[] eigval = new double[2];
        double[][] eigvec = new double[2][2];
        double t = 0.0;
        int num = 0;
        Position p = new Position();
        int max_num_points = 0;
        for (i = 0; i < num_contours.getValue(); ++i) {
            num_points = contours.get((int)i).num;
            if (num_points <= max_num_points) continue;
            max_num_points = num_points;
        }
        double[] width_l = new double[max_num_points];
        double[] width_r = new double[max_num_points];
        double[] grad_l = new double[max_num_points];
        double[] grad_r = new double[max_num_points];
        double[] pos_x = new double[max_num_points];
        double[] pos_y = new double[max_num_points];
        double[] correct = new double[max_num_points];
        double[] contrast = new double[max_num_points];
        double[] asymm = new double[max_num_points];
        float[] grad = new float[width * height];
        double length = 2.5 * sigma;
        int max_line = (int)Math.ceil(length * 3.0);
        Offset[] line = new Offset[max_line];
        for (int o = 0; o < line.length; ++o) {
            line[o] = new Offset();
        }
        for (r = 0; r < height; ++r) {
            for (c = 0; c < width; ++c) {
                int l = LinesUtil.LINCOOR(r, c, width);
                grad[l] = (float)Math.sqrt(dx[l] * dx[l] + dy[l] * dy[l]);
            }
        }
        for (i = 0; i < num_contours.getValue(); ++i) {
            Line cont = contours.get(i);
            num_points = cont.num;
            for (int j = 0; j < num_points; ++j) {
                double px = cont.row[j];
                double py = cont.col[j];
                pos_x[j] = px;
                pos_y[j] = py;
                r = (int)Math.floor(px + 0.5);
                c = (int)Math.floor(py + 0.5);
                double nx = Math.cos(cont.angle[j]);
                double ny = Math.sin(cont.angle[j]);
                MutableInt num_lineh = new MutableInt(num_line);
                this.bresenham(nx, ny, 0.0, 0.0, length, line, num_lineh);
                num_line = num_lineh.intValue();
                width_l[j] = 0.0;
                width_r[j] = 0.0;
                block6: for (int dir = -1; dir <= 1; dir += 2) {
                    for (int k = 0; k < num_line; ++k) {
                        int x = LinesUtil.BR(r + dir * line[k].x, height);
                        int y = LinesUtil.BC(c + dir * line[k].y, width);
                        double i1 = grad[LinesUtil.LINCOOR(LinesUtil.BR(x - 1, height), LinesUtil.BC(y - 1, width), width)];
                        double i2 = grad[LinesUtil.LINCOOR(LinesUtil.BR(x - 1, height), y, width)];
                        double i3 = grad[LinesUtil.LINCOOR(LinesUtil.BR(x - 1, height), LinesUtil.BC(y + 1, width), width)];
                        double i4 = grad[LinesUtil.LINCOOR(x, LinesUtil.BC(y - 1, width), width)];
                        double i5 = grad[LinesUtil.LINCOOR(x, y, width)];
                        double i6 = grad[LinesUtil.LINCOOR(x, LinesUtil.BC(y + 1, width), width)];
                        double i7 = grad[LinesUtil.LINCOOR(LinesUtil.BR(x + 1, height), LinesUtil.BC(y - 1, width), width)];
                        double i8 = grad[LinesUtil.LINCOOR(LinesUtil.BR(x + 1, height), y, width)];
                        double i9 = grad[LinesUtil.LINCOOR(LinesUtil.BR(x + 1, height), LinesUtil.BC(y + 1, width), width)];
                        double t1 = i1 + i2 + i3;
                        double t2 = i4 + i5 + i6;
                        double t3 = i7 + i8 + i9;
                        double t4 = i1 + i4 + i7;
                        double t5 = i2 + i5 + i8;
                        double t6 = i3 + i6 + i9;
                        double dr = (t3 - t1) / 6.0;
                        double dc = (t6 - t4) / 6.0;
                        double drr = (t1 - 2.0 * t2 + t3) / 6.0;
                        double dcc = (t4 - 2.0 * t5 + t6) / 6.0;
                        double drc = (i1 - i3 - i7 + i9) / 4.0;
                        p.compute_eigenvals(2.0 * drr, drc, 2.0 * dcc, eigval, eigvec);
                        double val = -eigval[0];
                        if (!(val > 0.0)) continue;
                        double n1 = eigvec[0][0];
                        double n2 = eigvec[0][1];
                        double a = 2.0 * (drr * n1 * n1 + drc * n1 * n2 + dcc * n2 * n2);
                        double b = dr * n1 + dc * n2;
                        MutableDouble th = new MutableDouble(t);
                        MutableInt numh = new MutableInt(num);
                        p.solve_linear(a, b, th, numh);
                        t = th.getValue();
                        num = numh.getValue();
                        if (num == 0) continue;
                        double p1 = t * n1;
                        double p2 = t * n2;
                        if (!(Math.abs(p1) <= 0.5) || !(Math.abs(p2) <= 0.5)) continue;
                        a = 1.0;
                        b = nx * (px - ((double)(r + dir * line[k].x) + p1)) + ny * (py - ((double)(c + dir * line[k].y) + p2));
                        th = new MutableDouble(t);
                        numh = new MutableInt(num);
                        p.solve_linear(a, b, th, numh);
                        t = th.getValue();
                        num = numh.getValue();
                        double d = (-i1 + 2.0 * i2 - i3 + 2.0 * i4 + 5.0 * i5 + 2.0 * i6 - i7 + 2.0 * i8 - i9) / 9.0;
                        if (dir == 1) {
                            grad_r[j] = d + p1 * dr + p2 * dc + p1 * p1 * drr + p1 * p2 * drc + p2 * p2 * dcc;
                            width_r[j] = Math.abs(t);
                            continue block6;
                        }
                        grad_l[j] = d + p1 * dr + p2 * dc + p1 * p1 * drr + p1 * p2 * drc + p2 * p2 * dcc;
                        width_l[j] = Math.abs(t);
                        continue block6;
                    }
                }
            }
            this.fix_locations(width_l, width_r, grad_l, grad_r, pos_x, pos_y, correct, contrast, asymm, sigma, mode, correct_pos, cont);
        }
    }
}

