/*
 * Decompiled with CFR 0.152.
 */
package fiji.util;

import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.OvalRoi;
import ij.gui.Roi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;

public class Circle_Fitter
implements PlugInFilter {
    ImagePlus image;
    ImageProcessor ip;
    float threshold = Float.NaN;
    int w;
    int h;

    public int setup(String arg, ImagePlus image) {
        this.image = image;
        return 159;
    }

    public void run(ImageProcessor ip) {
        this.ip = ip;
        this.w = ip.getWidth();
        this.h = ip.getHeight();
        this.threshold = this.getDefaultThreshold();
        GenericDialog gd = new GenericDialog("Fit Circle");
        gd.addNumericField("threshold", (double)this.threshold, 2);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.threshold = (float)gd.getNextNumber();
        OvalRoi roi = this.calculateRoi();
        this.image.setRoi((Roi)roi);
    }

    public OvalRoi calculateRoi() {
        if (this.ip == null || Float.isNaN(this.threshold)) {
            return null;
        }
        float total = 0.0f;
        float y = 0.0f;
        float x = 0.0f;
        for (int j = 0; j < this.h; ++j) {
            for (int i = 0; i < this.w; ++i) {
                float value = this.getValue(i, j);
                x += (float)i * value;
                y += (float)j * value;
                total += value;
            }
        }
        x /= total;
        y /= total;
        float vvv = 0.0f;
        float uvv = 0.0f;
        float uuv = 0.0f;
        float uuu = 0.0f;
        float vv = 0.0f;
        float uv = 0.0f;
        float uu = 0.0f;
        for (int j = 0; j < this.h; ++j) {
            for (int i = 0; i < this.w; ++i) {
                float value = this.getValue(i, j);
                float u = (float)i - x;
                float v = (float)j - y;
                uu += u * u * value;
                uv += u * v * value;
                vv += v * v * value;
                uuu += u * u * u * value;
                uuv += u * u * v * value;
                uvv += u * v * v * value;
                vvv += v * v * v * value;
            }
        }
        float f = 0.5f / (uu * vv - uv * uv);
        float centerU = (vv * (uuu + uvv) - uv * (uuv + vvv)) * f;
        float centerV = (-uv * (uuu + uvv) + uu * (uuv + vvv)) * f;
        float radius = (float)Math.sqrt(centerU * centerU + centerV * centerV + (uu + vv) / total);
        int x0 = (int)Math.max(0.0f, x + centerU - radius);
        int y0 = (int)Math.max(0.0f, y + centerV - radius);
        int x1 = (int)Math.min((float)this.w, x + centerU + radius);
        int y1 = (int)Math.min((float)this.h, y + centerV + radius);
        return new OvalRoi(x0, y0, x1 - x0, y1 - y0);
    }

    float getValue(int i, int j) {
        return Math.max(0.0f, this.ip.getf(i, j) - this.threshold);
    }

    public float getDefaultThreshold() {
        int i;
        float max;
        if (this.ip == null) {
            return Float.NaN;
        }
        int w = this.ip.getWidth();
        int h = this.ip.getHeight();
        float min = max = this.ip.getf(0, 0);
        for (int j = 0; j < h; ++j) {
            for (int i2 = 0; i2 < w; ++i2) {
                float v = this.ip.getf(i2, j);
                if (min > v) {
                    min = v;
                    continue;
                }
                if (!(max < v)) continue;
                max = v;
            }
        }
        float[] histogram = new float[256];
        for (int j = 0; j < h; ++j) {
            for (int i3 = 0; i3 < w; ++i3) {
                int n = (int)((this.ip.getf(i3, j) - min) * 255.99f / (max - min));
                histogram[n] = histogram[n] + 1.0f;
            }
        }
        int total = 0;
        int want = (int)Math.sqrt(w * h);
        for (i = 255; i > 0 && total < want; --i) {
            total = (int)((float)total + histogram[i]);
        }
        return min + (float)i * (max - min) / 255.99f;
    }

    public float getThreshold() {
        return this.threshold;
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    public void setAutoThreshold() {
        this.threshold = this.getDefaultThreshold();
    }

    public void setImageProcessor(ImageProcessor ip) {
        this.ip = ip;
        this.w = ip.getWidth();
        this.h = ip.getHeight();
    }
}

