/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.interp;

import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.interp.Gridder3;

public class SimpleGridder3
implements Gridder3 {
    private int _n;
    private float _fnull;
    private float[] _f;
    private float[] _x1;
    private float[] _x2;
    private float[] _x3;

    public SimpleGridder3(float[] f, float[] x1, float[] x2, float[] x3) {
        this.setScattered(f, x1, x2, x3);
    }

    public void setNullValue(float fnull) {
        this._fnull = fnull;
    }

    public static float[][] getGriddedSamples(float fnull, Sampling s1, Sampling s2, Sampling s3, float[][][] g) {
        int n1 = s1.getCount();
        int n2 = s2.getCount();
        int n3 = s3.getCount();
        int n = 0;
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    if (g[i3][i2][i1] == fnull) continue;
                    ++n;
                }
            }
        }
        float[] f = new float[n];
        float[] x1 = new float[n];
        float[] x2 = new float[n];
        float[] x3 = new float[n];
        int i = 0;
        for (int i3 = 0; i3 < n3; ++i3) {
            float x3i = (float)s3.getValue(i3);
            for (int i2 = 0; i2 < n2; ++i2) {
                float x2i = (float)s2.getValue(i2);
                for (int i1 = 0; i1 < n1; ++i1) {
                    float x1i;
                    if (g[i3][i2][i1] == fnull) continue;
                    x1[i] = x1i = (float)s1.getValue(i1);
                    x2[i] = x2i;
                    x3[i] = x3i;
                    f[i] = g[i3][i2][i1];
                    ++i;
                }
            }
        }
        return new float[][]{f, x1, x2, x3};
    }

    @Override
    public void setScattered(float[] f, float[] x1, float[] x2, float[] x3) {
        this._n = f.length;
        this._f = f;
        this._x1 = x1;
        this._x2 = x2;
        this._x3 = x3;
    }

    @Override
    public float[][][] grid(Sampling s1, Sampling s2, Sampling s3) {
        int n1 = s1.getCount();
        int n2 = s2.getCount();
        int n3 = s3.getCount();
        double d1 = s1.getDelta();
        double d2 = s2.getDelta();
        double d3 = s3.getDelta();
        double f1 = s1.getFirst();
        double f2 = s2.getFirst();
        double f3 = s3.getFirst();
        double l1 = s1.getLast();
        double l2 = s2.getLast();
        double l3 = s3.getLast();
        f1 -= 0.5 * d1;
        l1 += 0.5 * d1;
        f2 -= 0.5 * d2;
        l2 += 0.5 * d2;
        f3 -= 0.5 * d3;
        l3 += 0.5 * d3;
        float[][][] g = new float[n3][n2][n1];
        float[][][] c = new float[n3][n2][n1];
        for (int i = 0; i < this._n; ++i) {
            double x1 = this._x1[i];
            double x2 = this._x2[i];
            double x3 = this._x3[i];
            if (!(f1 <= x1) || !(x1 <= l1) || !(f2 <= x2) || !(x2 <= l2) || !(f3 <= x3) || !(x3 <= l3)) continue;
            int i1 = s1.indexOfNearest(x1);
            int i2 = s2.indexOfNearest(x2);
            int i3 = s3.indexOfNearest(x3);
            float[] fArray = g[i3][i2];
            int n = i1;
            fArray[n] = fArray[n] + this._f[i];
            float[] fArray2 = c[i3][i2];
            int n4 = i1;
            fArray2[n4] = fArray2[n4] + 1.0f;
        }
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    g[i3][i2][i1] = c[i3][i2][i1] > 0.0f ? g[i3][i2][i1] / c[i3][i2][i1] : this._fnull;
                }
            }
        }
        return g;
    }
}

