/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.coloc.algorithms;

import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.TwinCursor;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import sc.fiji.coloc.algorithms.Algorithm;
import sc.fiji.coloc.algorithms.BisectionStepper;
import sc.fiji.coloc.algorithms.ChannelMapper;
import sc.fiji.coloc.algorithms.MissingPreconditionException;
import sc.fiji.coloc.algorithms.PearsonsCorrelation;
import sc.fiji.coloc.algorithms.SimpleStepper;
import sc.fiji.coloc.algorithms.Stepper;
import sc.fiji.coloc.gadgets.DataContainer;
import sc.fiji.coloc.gadgets.ThresholdMode;
import sc.fiji.coloc.results.ResultHandler;

public class AutoThresholdRegression<T extends RealType<T>>
extends Algorithm<T> {
    Implementation implementation = Implementation.Bisection;
    final double warnYInterceptToYMeanRatioThreshold = 0.01;
    double autoThresholdSlope = 0.0;
    double autoThresholdIntercept = 0.0;
    T ch1MinThreshold;
    T ch1MaxThreshold;
    T ch2MinThreshold;
    T ch2MaxThreshold;
    double bToYMeanRatio = 0.0;
    PearsonsCorrelation<T> pearsonsCorrellation;

    public AutoThresholdRegression(PearsonsCorrelation<T> pc) {
        this(pc, Implementation.Costes);
    }

    public AutoThresholdRegression(PearsonsCorrelation<T> pc, Implementation impl) {
        super("auto threshold regression");
        this.pearsonsCorrellation = pc;
        this.implementation = impl;
    }

    @Override
    public void execute(DataContainer<T> container) throws MissingPreconditionException {
        Stepper stepper;
        ChannelMapper mapper;
        RandomAccessibleInterval<T> img1 = container.getSourceImage1();
        RandomAccessibleInterval<T> img2 = container.getSourceImage2();
        RandomAccessibleInterval<BitType> mask = container.getMask();
        double ch1Mean = container.getMeanCh1();
        double ch2Mean = container.getMeanCh2();
        double combinedMean = ch1Mean + ch2Mean;
        TwinCursor cursor = new TwinCursor(img1.randomAccess(), img2.randomAccess(), (Cursor<BitType>)Views.iterable(mask).localizingCursor());
        double ch1MeanDiffSum = 0.0;
        double ch2MeanDiffSum = 0.0;
        double combinedMeanDiffSum = 0.0;
        double combinedSum = 0.0;
        int N = 0;
        int NZero = 0;
        RealType type = (RealType)cursor.getFirst();
        while (cursor.hasNext()) {
            cursor.fwd();
            double ch1 = ((RealType)cursor.getFirst()).getRealDouble();
            double ch2 = ((RealType)cursor.getSecond()).getRealDouble();
            combinedSum = ch1 + ch2;
            ch1MeanDiffSum += (ch1 - ch1Mean) * (ch1 - ch1Mean);
            ch2MeanDiffSum += (ch2 - ch2Mean) * (ch2 - ch2Mean);
            combinedMeanDiffSum += (combinedSum - combinedMean) * (combinedSum - combinedMean);
            if (ch1 + ch2 > 1.0E-5) {
                ++NZero;
            }
            ++N;
        }
        double ch1Variance = ch1MeanDiffSum / (double)(N - 1);
        double ch2Variance = ch2MeanDiffSum / (double)(N - 1);
        double combinedVariance = combinedMeanDiffSum / ((double)N - 1.0);
        double ch1ch2Covariance = 0.5 * (combinedVariance - (ch1Variance + ch2Variance));
        double denom = 2.0 * ch1ch2Covariance;
        double num = ch2Variance - ch1Variance + Math.sqrt((ch2Variance - ch1Variance) * (ch2Variance - ch1Variance) + 4.0 * ch1ch2Covariance * ch1ch2Covariance);
        final double m = num / denom;
        final double b = ch2Mean - m * ch1Mean;
        if (m > -1.0 && m < 1.0) {
            mapper = new ChannelMapper(){

                @Override
                public double getCh1Threshold(double t) {
                    return t;
                }

                @Override
                public double getCh2Threshold(double t) {
                    return t * m + b;
                }
            };
            stepper = this.implementation == Implementation.Bisection ? new BisectionStepper(Math.abs(container.getMaxCh1() + container.getMinCh1()) * 0.5, container.getMaxCh1()) : new SimpleStepper(container.getMaxCh1());
        } else {
            mapper = new ChannelMapper(){

                @Override
                public double getCh1Threshold(double t) {
                    return (t - b) / m;
                }

                @Override
                public double getCh2Threshold(double t) {
                    return t;
                }
            };
            stepper = this.implementation == Implementation.Bisection ? new BisectionStepper(Math.abs(container.getMaxCh2() + container.getMinCh2()) * 0.5, container.getMaxCh2()) : new SimpleStepper(container.getMaxCh2());
        }
        double ch1ThreshMax = container.getMaxCh1();
        double ch2ThreshMax = container.getMaxCh2();
        RealType thresholdCh1 = (RealType)type.createVariable();
        RealType thresholdCh2 = (RealType)type.createVariable();
        cursor.reset();
        RealType dummyT = (RealType)type.createVariable();
        double minVal = dummyT.getMinValue();
        double maxVal = dummyT.getMaxValue();
        while (!stepper.isFinished()) {
            ch1ThreshMax = Math.round(mapper.getCh1Threshold(stepper.getValue()));
            ch2ThreshMax = Math.round(mapper.getCh2Threshold(stepper.getValue()));
            thresholdCh1.setReal(AutoThresholdRegression.clamp(ch1ThreshMax, minVal, maxVal));
            thresholdCh2.setReal(AutoThresholdRegression.clamp(ch2ThreshMax, minVal, maxVal));
            try {
                double currentPersonsR = this.pearsonsCorrellation.calculatePearsons(cursor, ch1Mean, ch2Mean, thresholdCh1, thresholdCh2, ThresholdMode.Below);
                stepper.update(currentPersonsR);
            }
            catch (MissingPreconditionException e) {
                stepper.update(Double.NaN);
            }
            cursor.reset();
        }
        this.ch1MinThreshold = (RealType)type.createVariable();
        this.ch1MinThreshold.setReal(minVal);
        this.ch1MaxThreshold = (RealType)type.createVariable();
        this.ch1MaxThreshold.setReal(AutoThresholdRegression.clamp(ch1ThreshMax, minVal, maxVal));
        this.ch2MinThreshold = (RealType)type.createVariable();
        this.ch2MinThreshold.setReal(minVal);
        this.ch2MaxThreshold = (RealType)type.createVariable();
        this.ch2MaxThreshold.setReal(AutoThresholdRegression.clamp(ch2ThreshMax, minVal, maxVal));
        this.autoThresholdSlope = m;
        this.autoThresholdIntercept = b;
        this.bToYMeanRatio = b / container.getMeanCh2();
        if (Math.abs(this.bToYMeanRatio) > 0.01) {
            this.addWarning("y-intercept far from zero", "The ratio of the y-intercept of the auto threshold regression line to the mean value of Channel 2 is high. This means the y-intercept is far from zero, implying a significant positive or negative zero offset in the image data intensities. Maybe you should use a ROI. Maybe do a background subtraction in both channels. Make sure you didn't clip off the low intensities to zero. This might not affect Pearson's correlation values very much, but might harm other results.");
        }
        if (ch1ThreshMax > ch1Mean) {
            this.addWarning("Threshold of ch. 1 too high", "Too few pixels are taken into account for above-threshold calculations. The threshold is above the channel's mean.");
        }
        if (ch2ThreshMax > ch2Mean) {
            this.addWarning("Threshold of ch. 2 too high", "Too few pixels are taken into account for above-threshold calculations. The threshold is above the channel's mean.");
        }
        if (ch1ThreshMax < container.getMinCh1() || ch2ThreshMax < container.getMinCh2()) {
            String msg = "The auto threshold method could not find a positive threshold, so thresholded results are meaningless.";
            msg = msg + (this.implementation == Implementation.Costes ? "" : " Maybe you should try classic thresholding.");
            this.addWarning("thresholds too low", msg);
        }
    }

    public static double clamp(double val, double min, double max) {
        return min > val ? min : (max < val ? max : val);
    }

    @Override
    public void processResults(ResultHandler<T> handler) {
        super.processResults(handler);
        handler.handleValue("m (slope)", this.autoThresholdSlope, 2);
        handler.handleValue("b (y-intercept)", this.autoThresholdIntercept, 2);
        handler.handleValue("b to y-mean ratio", this.bToYMeanRatio, 2);
        handler.handleValue("Ch1 Max Threshold", this.ch1MaxThreshold.getRealDouble(), 2);
        handler.handleValue("Ch2 Max Threshold", this.ch2MaxThreshold.getRealDouble(), 2);
        handler.handleValue("Threshold regression", this.implementation.toString());
    }

    public double getBToYMeanRatio() {
        return this.bToYMeanRatio;
    }

    public double getWarnYInterceptToYMaxRatioThreshold() {
        return 0.01;
    }

    public double getAutoThresholdSlope() {
        return this.autoThresholdSlope;
    }

    public double getAutoThresholdIntercept() {
        return this.autoThresholdIntercept;
    }

    public T getCh1MinThreshold() {
        return this.ch1MinThreshold;
    }

    public T getCh1MaxThreshold() {
        return this.ch1MaxThreshold;
    }

    public T getCh2MinThreshold() {
        return this.ch2MinThreshold;
    }

    public T getCh2MaxThreshold() {
        return this.ch2MaxThreshold;
    }

    public static enum Implementation {
        Costes,
        Bisection;

    }
}

