/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.clahe;

import ij.process.ByteProcessor;
import mpicbg.ij.clahe.Apply;
import mpicbg.util.Util;

final class FastByteApply
extends Apply<ByteProcessor> {
    protected final byte[] ipPixels;

    public FastByteApply(ByteProcessor ip, ByteProcessor src, ByteProcessor dst, ByteProcessor mask, int boxXMin, int boxYMin, int boxXMax, int boxYMax) throws Exception {
        super(ip, src, dst, mask, boxXMin, boxYMin, boxXMax, boxYMax);
        this.ipPixels = (byte[])ip.getPixels();
    }

    @Override
    public final void apply(int cellXMin, int cellYMin, int cellXMax, int cellYMax) {
        int xMin = Math.max(this.boxXMin, cellXMin);
        int yMin = Math.max(this.boxYMin, cellYMin);
        int xMax = Math.min(this.boxXMax, cellXMax);
        int yMax = Math.min(this.boxYMax, cellYMax);
        for (int y = yMin; y < yMax; ++y) {
            int i = y * this.width + xMin;
            for (int x = xMin; x < xMax; ++x) {
                float m = (float)(this.maskPixels[i] & 0xFF) / 255.0f;
                float v = this.srcPixels[i] & 0xFF;
                float a = this.dstPixels[i] & 0xFF;
                float b = m * a + (1.0f - m) * v;
                this.ipPixels[i] = (byte)Util.roundPos(b);
                ++i;
            }
        }
    }
}

