/*
 * Decompiled with CFR 0.152.
 */
package bdv.ij.export;

import bdv.export.ExportMipmapInfo;
import bdv.export.WriteSequenceToHdf5;
import bdv.ij.export.FusionResult;
import bdv.ij.export.SetupAggregator;
import bdv.ij.export.SpimRegistrationSequence;
import bdv.ij.util.PluginHelper;
import bdv.img.hdf5.Hdf5ImageLoader;
import bdv.img.hdf5.Partition;
import bdv.spimdata.SequenceDescriptionMinimal;
import bdv.spimdata.SpimDataMinimal;
import bdv.spimdata.XmlIoSpimDataMinimal;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.io.ConfigurationParserException;
import net.imglib2.realtransform.AffineTransform3D;

@Deprecated
public class Scripting {
    @Deprecated
    public static SpimRegistrationSequence createSpimRegistrationSequence(String huiskenExperimentXmlFile, String channels, String angles, String timepoints, int referenceTimePoint) throws ConfigurationParserException {
        return new SpimRegistrationSequence(huiskenExperimentXmlFile, channels, angles, timepoints, referenceTimePoint);
    }

    @Deprecated
    public static SpimRegistrationSequence createSpimRegistrationSequence(String inputDirectory, String inputFilePattern, String channels, String angles, String timepoints, int referenceTimePoint, boolean overrideImageZStretching, double zStretching) throws ConfigurationParserException {
        return new SpimRegistrationSequence(inputDirectory, inputFilePattern, channels, angles, timepoints, referenceTimePoint, overrideImageZStretching, zStretching);
    }

    @Deprecated
    public static Map<Integer, AffineTransform3D> getFusionTransforms(SpimRegistrationSequence spimseq, int scale, int cropOffsetX, int cropOffsetY, int cropOffsetZ) {
        return spimseq.getFusionTransforms(cropOffsetX, cropOffsetY, cropOffsetZ, scale);
    }

    @Deprecated
    public static FusionResult createFusionResult(SpimRegistrationSequence spimseq, String filepath, String filepattern, int numSlices, double sliceValueMin, double sliceValueMax, Map<Integer, AffineTransform3D> fusionTransforms) {
        return FusionResult.create(spimseq, filepath, filepattern, numSlices, sliceValueMin, sliceValueMax, fusionTransforms);
    }

    @Deprecated
    public static ArrayList<Partition> split(SetupAggregator aggregator, int timepointsPerPartition, int setupsPerPartition, String xmlFilename) {
        String basename = xmlFilename.endsWith(".xml") ? xmlFilename.substring(0, xmlFilename.length() - 4) : xmlFilename;
        return Partition.split((List)aggregator.timepoints.getTimePointsOrdered(), aggregator.setups, (int)timepointsPerPartition, (int)setupsPerPartition, (String)basename);
    }

    public static void example_main(String[] args) throws Exception {
        SetupAggregator aggregator = new SetupAggregator();
        String huiskenExperimentXmlFile = "/Users/pietzsch/workspace/data/fast fly/111010_weber/e012.xml";
        String angles = "0,120,240";
        String timepoints = "1-5";
        int referenceTimePoint = 50;
        SpimRegistrationSequence spimseq = Scripting.createSpimRegistrationSequence("/Users/pietzsch/workspace/data/fast fly/111010_weber/e012.xml", null, "0,120,240", "1-5", 50);
        String filepath = "/Users/pietzsch/workspace/data/fast fly/111010_weber/e012/output/";
        String filepattern = "img_tl%1$d_ch%2$d_z%3$03d.tif";
        int numSlices = 387;
        double sliceValueMin = 0.0;
        double sliceValueMax = 8000.0;
        int cropOffsetX = 58;
        int cropOffsetY = 74;
        int cropOffsetZ = 6;
        boolean scale = true;
        Map<Integer, AffineTransform3D> fusionTransforms = Scripting.getFusionTransforms(spimseq, 1, 58, 74, 6);
        FusionResult fusion = Scripting.createFusionResult(spimseq, "/Users/pietzsch/workspace/data/fast fly/111010_weber/e012/output/", "img_tl%1$d_ch%2$d_z%3$03d.tif", 387, 0.0, 8000.0, fusionTransforms);
        int[][] spimresolutions = new int[][]{{1, 1, 1}, {2, 2, 1}, {4, 4, 2}};
        int[][] spimsubdivisions = new int[][]{{32, 32, 4}, {16, 16, 8}, {8, 8, 8}};
        String fusionresolutions = "{ 1, 1, 1 }, { 2, 2, 2 }, { 4, 4, 4 }";
        String fusionsubdivisions = "{ 16, 16, 16 }, { 16, 16, 16 }, { 8, 8, 8 }";
        aggregator.addSetups(spimseq, (int[][])spimresolutions, (int[][])spimsubdivisions);
        aggregator.addSetups(fusion, "{ 1, 1, 1 }, { 2, 2, 2 }, { 4, 4, 4 }", "{ 16, 16, 16 }, { 16, 16, 16 }, { 8, 8, 8 }");
        String xmlFilename = "/Users/pietzsch/Desktop/everything.xml";
        int timepointsPerPartition = 3;
        int setupsPerPartition = 2;
        ArrayList<Partition> partitions = Scripting.split(aggregator, 3, 2, "/Users/pietzsch/Desktop/everything.xml");
        PartitionedSequenceWriter writer = new PartitionedSequenceWriter(aggregator, "/Users/pietzsch/Desktop/everything.xml", true, partitions);
        System.out.println(writer.numPartitions());
        for (int i = 0; i < writer.numPartitions(); ++i) {
            writer.writePartition(i);
        }
        writer.writeXmlAndLinks();
    }

    public static class PartitionedSequenceWriter {
        protected final SpimDataMinimal spimData;
        protected final Map<Integer, ExportMipmapInfo> perSetupMipmapInfo;
        protected final boolean deflate;
        protected final ArrayList<Partition> partitions;
        protected final File seqFile;
        protected final File hdf5File;

        public PartitionedSequenceWriter(SetupAggregator aggregator, String xmlFilename, boolean deflate, List<Partition> partitions) {
            this.seqFile = new File(xmlFilename);
            String hdf5Filename = (xmlFilename.endsWith(".xml") ? xmlFilename.substring(0, xmlFilename.length() - 4) : xmlFilename) + ".h5";
            this.hdf5File = new File(hdf5Filename);
            this.spimData = aggregator.createSpimData(this.seqFile);
            this.perSetupMipmapInfo = aggregator.getPerSetupMipmapInfo();
            this.deflate = deflate;
            this.partitions = new ArrayList<Partition>(partitions);
        }

        public int numPartitions() {
            return this.partitions.size();
        }

        public void writePartition(int index) {
            if (index >= 0 && index < this.partitions.size()) {
                int numCellCreatorThreads = Math.max(1, PluginHelper.numThreads() - 1);
                WriteSequenceToHdf5.writeHdf5PartitionFile((AbstractSequenceDescription)this.spimData.getSequenceDescription(), this.perSetupMipmapInfo, (boolean)this.deflate, (Partition)this.partitions.get(index), null, null, (int)numCellCreatorThreads, null);
            }
        }

        public void writeXmlAndLinks() throws SpimDataException {
            SequenceDescriptionMinimal seq = (SequenceDescriptionMinimal)this.spimData.getSequenceDescription();
            WriteSequenceToHdf5.writeHdf5PartitionLinkFile((AbstractSequenceDescription)seq, this.perSetupMipmapInfo, this.partitions, (File)this.hdf5File);
            Hdf5ImageLoader loader = new Hdf5ImageLoader(this.hdf5File, this.partitions, null, false);
            new XmlIoSpimDataMinimal().save((AbstractSpimData)new SpimDataMinimal(this.spimData, (BasicImgLoader)loader), this.seqFile.getAbsolutePath());
        }
    }
}

