/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import ij.IJ;
import ij.ImagePlus;
import ij3d.Content;
import ij3d.IJAdapter;
import ij3d.ImageCanvas3D;
import ij3d.ImageWindow3D;
import ij3d.NoopAdapter;
import ij3d.UIAdapter;
import ij3d.UniverseListener;
import ij3d.UniverseSettings;
import ij3d.behaviors.BehaviorCallback;
import ij3d.behaviors.ContentTransformer;
import ij3d.behaviors.InteractiveBehavior;
import ij3d.behaviors.InteractiveViewPlatformTransformer;
import ij3d.behaviors.Picker;
import ij3d.behaviors.WaitForNextFrameBehavior;
import ij3d.shapes.CoordinateSystem;
import ij3d.shapes.Scalebar;
import java.awt.Dimension;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import org.jogamp.java3d.AmbientLight;
import org.jogamp.java3d.Background;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.DirectionalLight;
import org.jogamp.java3d.GraphicsConfigTemplate3D;
import org.jogamp.java3d.ImageComponent2D;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.PointLight;
import org.jogamp.java3d.Screen3D;
import org.jogamp.java3d.Switch;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.utils.universe.MultiTransformGroup;
import org.jogamp.java3d.utils.universe.SimpleUniverse;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point3d;

public abstract class DefaultUniverse
extends SimpleUniverse
implements BehaviorCallback {
    public static final int CENTER_TG = 0;
    public static final int ZOOM_TG = 4;
    public static final int TRANSLATE_TG = 1;
    public static final int ANIMATE_TG = 3;
    public static final int ROTATION_TG = 2;
    public static final int ATTRIBUTE_SCALEBAR = 0;
    public static final int ATTRIBUTE_COORD_SYSTEM = 1;
    protected BranchGroup scene;
    protected Scalebar scalebar;
    protected CoordinateSystem globalCoord;
    protected BoundingSphere bounds;
    protected ImageWindow3D win;
    protected final Point3d globalMin = new Point3d();
    protected final Point3d globalMax = new Point3d();
    protected final Point3d globalCenter = new Point3d();
    protected InteractiveBehavior mouseBehavior;
    protected final ContentTransformer contentTransformer;
    protected final Picker picker;
    protected final InteractiveViewPlatformTransformer viewTransformer;
    protected final WaitForNextFrameBehavior frameBehavior;
    protected final PointLight light;
    public final UIAdapter ui;
    protected final Switch attributesSwitch;
    private final BitSet attributesMask = new BitSet(2);
    private final List listeners = new ArrayList();
    private boolean transformed = false;
    protected boolean useToFront = true;
    Canvas3D offCanvas = null;

    public abstract Content getSelected();

    public abstract Iterator contents();

    public DefaultUniverse(int width, int height) {
        this(width, height, DefaultUniverse.getDefaultUIAdapter());
    }

    private static UIAdapter getDefaultUIAdapter() {
        if (IJ.getInstance() == null) {
            return new NoopAdapter();
        }
        return new IJAdapter();
    }

    public DefaultUniverse(int width, int height, UIAdapter uia) {
        super((Canvas3D)new ImageCanvas3D(width, height, uia), 5);
        this.ui = uia;
        this.getViewer().getView().setProjectionPolicy(UniverseSettings.projection);
        this.bounds = new BoundingSphere();
        this.bounds.setRadius(Double.POSITIVE_INFINITY);
        this.scene = new BranchGroup();
        this.scene.setCapability(14);
        this.scene.setCapability(12);
        this.scene.setCapability(13);
        Background bg = ((ImageCanvas3D)this.getCanvas()).getBG();
        bg.setApplicationBounds((Bounds)this.bounds);
        this.scene.addChild((Node)bg);
        this.attributesSwitch = new Switch();
        this.attributesSwitch.setWhichChild(-3);
        this.attributesSwitch.setCapability(17);
        this.attributesSwitch.setCapability(18);
        this.scene.addChild((Node)this.attributesSwitch);
        this.scalebar = new Scalebar();
        this.attributesSwitch.addChild((Node)this.scalebar);
        this.attributesMask.set(0, UniverseSettings.showScalebar);
        this.globalCoord = new CoordinateSystem(100.0f, new Color3f(1.0f, 0.0f, 0.0f));
        this.attributesSwitch.addChild((Node)this.globalCoord);
        this.attributesMask.set(1, UniverseSettings.showGlobalCoordinateSystem);
        this.attributesSwitch.setChildMask(this.attributesMask);
        BranchGroup lightBG = new BranchGroup();
        AmbientLight lightA = new AmbientLight();
        lightA.setInfluencingBounds((Bounds)this.bounds);
        lightA.setEnable(false);
        lightBG.addChild((Node)lightA);
        DirectionalLight lightD1 = new DirectionalLight();
        lightD1.setInfluencingBounds((Bounds)this.bounds);
        lightD1.setEnable(false);
        lightBG.addChild((Node)lightD1);
        this.light = new PointLight();
        this.light.setCapability(18);
        this.light.setCapability(19);
        this.light.setCapability(14);
        this.light.setCapability(15);
        this.light.setPosition(-2.0f, 0.0f, -3.0f);
        this.light.setInfluencingBounds((Bounds)this.bounds);
        lightBG.addChild((Node)this.light);
        this.getZoomTG().addChild((Node)lightBG);
        this.viewTransformer = new InteractiveViewPlatformTransformer(this, this);
        this.contentTransformer = new ContentTransformer(this, this);
        this.picker = new Picker(this);
        this.setInteractiveBehavior(new InteractiveBehavior(this));
        this.frameBehavior = new WaitForNextFrameBehavior();
        this.frameBehavior.setSchedulingBounds((Bounds)this.bounds);
        this.frameBehavior.setEnable(true);
        this.scene.addChild((Node)this.frameBehavior);
        this.scene.compile();
        this.addBranchGraph(this.scene);
        this.getCanvas().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (DefaultUniverse.this.ui.isHandTool() || DefaultUniverse.this.ui.isMagnifierTool()) {
                    if (DefaultUniverse.this.transformed) {
                        DefaultUniverse.this.fireTransformationFinished();
                    }
                    DefaultUniverse.this.transformed = false;
                }
            }
        });
        this.getCanvas().addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (DefaultUniverse.this.ui.isHandTool() || DefaultUniverse.this.ui.isMagnifierTool()) {
                    if (!DefaultUniverse.this.transformed) {
                        DefaultUniverse.this.fireTransformationStarted();
                    }
                    DefaultUniverse.this.transformed = true;
                }
            }
        });
        this.getCanvas().addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                DefaultUniverse.this.fireCanvasResized();
            }
        });
        this.fireTransformationUpdated();
    }

    @Deprecated
    public void setInteractiveBehavior(InteractiveBehavior b) {
        if (this.mouseBehavior != null) {
            this.scene.removeChild(this.mouseBehavior.getParent());
        }
        this.mouseBehavior = b;
        this.mouseBehavior.setSchedulingBounds((Bounds)this.bounds);
        BranchGroup bg = new BranchGroup();
        bg.setCapability(17);
        bg.addChild((Node)this.mouseBehavior);
        this.scene.addChild((Node)bg);
    }

    public void addInteractiveBehavior(InteractiveBehavior b) {
        if (null == this.mouseBehavior) {
            this.setInteractiveBehavior(b);
            return;
        }
        List<InteractiveBehavior> ls = this.mouseBehavior.getExternalBehaviors();
        if (null == ls) {
            ls = new ArrayList<InteractiveBehavior>();
            this.mouseBehavior.setExternalBehaviours(ls);
        }
        ls.add(b);
    }

    public void getVworldToCamera(Transform3D transform) {
        Transform3D tmp = new Transform3D();
        this.getCenterTG().getTransform(transform);
        this.getTranslateTG().getTransform(tmp);
        transform.mul(tmp);
        this.getRotationTG().getTransform(tmp);
        transform.mul(tmp);
        this.getZoomTG().getTransform(tmp);
        transform.mul(tmp);
        transform.invert();
    }

    public void getVworldToCameraInverse(Transform3D transform) {
        Transform3D tmp = new Transform3D();
        this.getCenterTG().getTransform(transform);
        this.getTranslateTG().getTransform(tmp);
        transform.mul(tmp);
        this.getRotationTG().getTransform(tmp);
        transform.mul(tmp);
        this.getZoomTG().getTransform(tmp);
        transform.mul(tmp);
    }

    public TransformGroup getZoomTG() {
        return this.getViewingPlatform().getMultiTransformGroup().getTransformGroup(4);
    }

    public TransformGroup getCenterTG() {
        return this.getViewingPlatform().getMultiTransformGroup().getTransformGroup(0);
    }

    public TransformGroup getRotationTG() {
        return this.getViewingPlatform().getMultiTransformGroup().getTransformGroup(2);
    }

    public TransformGroup getTranslateTG() {
        return this.getViewingPlatform().getMultiTransformGroup().getTransformGroup(1);
    }

    public TransformGroup getAnimationTG() {
        return this.getViewingPlatform().getMultiTransformGroup().getTransformGroup(3);
    }

    public void getGlobalTransform(GlobalTransform transform) {
        int i;
        MultiTransformGroup group = this.getViewingPlatform().getMultiTransformGroup();
        int num = group.getNumTransforms();
        if (transform.transforms == null || transform.transforms.length != num) {
            transform.transforms = new Transform3D[num];
            for (i = 0; i < num; ++i) {
                transform.transforms[i] = new Transform3D();
            }
        }
        for (i = 0; i < num; ++i) {
            group.getTransformGroup(i).getTransform(transform.transforms[i]);
        }
    }

    public void setGlobalTransform(GlobalTransform transform) {
        MultiTransformGroup group = this.getViewingPlatform().getMultiTransformGroup();
        int num = group.getNumTransforms();
        if (transform.transforms == null || transform.transforms.length != num) {
            throw new RuntimeException("Internal 3D Viewer error");
        }
        for (int i = 0; i < num; ++i) {
            group.getTransformGroup(i).setTransform(transform.transforms[i]);
        }
        this.waitForNextFrame();
        this.fireTransformationUpdated();
    }

    public PointLight getLight() {
        return this.light;
    }

    public Scalebar getScalebar() {
        return this.scalebar;
    }

    public ContentTransformer getContentTransformer() {
        return this.contentTransformer;
    }

    public Picker getPicker() {
        return this.picker;
    }

    public InteractiveViewPlatformTransformer getViewPlatformTransformer() {
        return this.viewTransformer;
    }

    public void showAttribute(int attribute, boolean flag) {
        this.attributesMask.set(attribute, flag);
        this.attributesSwitch.setChildMask(this.attributesMask);
    }

    public boolean isAttributeVisible(int attribute) {
        return this.attributesMask.get(attribute);
    }

    public BranchGroup getScene() {
        return this.scene;
    }

    @Override
    public void transformChanged(int type, Transform3D xf) {
        this.fireTransformationUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForNextFrame() {
        if (this.win == null) {
            return;
        }
        this.frameBehavior.postId(1);
        WaitForNextFrameBehavior waitForNextFrameBehavior = this.frameBehavior;
        synchronized (waitForNextFrameBehavior) {
            try {
                ((Object)((Object)this.frameBehavior)).wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setUseToFront(boolean useToFront) {
        this.useToFront = useToFront;
    }

    public boolean getUseToFront() {
        return this.useToFront;
    }

    public Dimension getSize() {
        if (this.win != null) {
            return this.win.getSize();
        }
        return null;
    }

    public void setSize(int w, int h) {
        if (this.win != null) {
            this.win.setSize(w, h);
        }
    }

    public void show() {
        this.win = new ImageWindow3D("ImageJ 3D Viewer", this);
    }

    public void close() {
        this.win.close();
    }

    public void cleanup() {
        UniverseSettings.save();
        if (this.win != null) {
            this.fireUniverseClosed();
            while (!this.listeners.isEmpty()) {
                this.listeners.remove(0);
            }
            ImageWindow3D win2 = this.win;
            this.win = null;
            if (null != this.mouseBehavior) {
                this.mouseBehavior.setExternalBehaviours(null);
            }
        }
        super.removeAllLocales();
        super.cleanup();
    }

    public ImageWindow3D getWindow() {
        return this.win;
    }

    public ImagePlus takeSnapshot() {
        this.win.updateImagePlusAndWait();
        return this.win.getImagePlus();
    }

    public ImagePlus takeSnapshot(int w, int h) {
        GraphicsConfigTemplate3D templ = new GraphicsConfigTemplate3D();
        templ.setDoubleBuffer(3);
        Canvas3D onCanvas = this.getCanvas();
        if (this.offCanvas == null) {
            GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)templ);
            this.offCanvas = new Canvas3D(gc, true);
            System.out.println("construct canvas");
        }
        Screen3D sOn = onCanvas.getScreen3D();
        Screen3D sOff = this.offCanvas.getScreen3D();
        sOff.setSize(sOn.getSize());
        sOff.setPhysicalScreenWidth(sOn.getPhysicalScreenWidth());
        sOff.setPhysicalScreenHeight(sOn.getPhysicalScreenHeight());
        this.getViewer().getView().addCanvas3D(this.offCanvas);
        Color3f bg = new Color3f();
        ((ImageCanvas3D)onCanvas).getBG().getColor(bg);
        BufferedImage bImage = new BufferedImage(w, h, 2);
        ImageComponent2D ic2d = new ImageComponent2D(2, bImage);
        this.offCanvas.setOffScreenBuffer(ic2d);
        this.offCanvas.renderOffScreenBuffer();
        this.offCanvas.waitForOffScreenRendering();
        bImage = this.offCanvas.getOffScreenBuffer().getImage();
        this.getViewer().getView().removeCanvas3D(this.offCanvas);
        return new ImagePlus("Snapshot", (Image)bImage);
    }

    public void addUniverseListener(UniverseListener l) {
        this.listeners.add(l);
    }

    public void removeUniverseListener(UniverseListener l) {
        this.listeners.remove(l);
    }

    public void fireUniverseClosed() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            UniverseListener l = (UniverseListener)this.listeners.get(i);
            l.universeClosed();
        }
    }

    public void fireTransformationStarted() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            UniverseListener l = (UniverseListener)this.listeners.get(i);
            l.transformationStarted(this.getCanvas().getView());
        }
    }

    public void fireTransformationUpdated() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            UniverseListener l = (UniverseListener)this.listeners.get(i);
            l.transformationUpdated(this.getCanvas().getView());
        }
    }

    public void fireTransformationFinished() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            UniverseListener l = (UniverseListener)this.listeners.get(i);
            l.transformationFinished(this.getCanvas().getView());
        }
    }

    public void fireContentAdded(Content c) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            UniverseListener l = (UniverseListener)this.listeners.get(i);
            l.contentAdded(c);
        }
    }

    public void fireContentChanged(Content c) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            UniverseListener l = (UniverseListener)this.listeners.get(i);
            l.contentChanged(c);
        }
    }

    public void fireContentRemoved(Content c) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            UniverseListener l = (UniverseListener)this.listeners.get(i);
            l.contentRemoved(c);
        }
    }

    public void fireContentSelected(Content c) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            UniverseListener l = (UniverseListener)this.listeners.get(i);
            l.contentSelected(c);
        }
    }

    public void fireCanvasResized() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            UniverseListener l = (UniverseListener)this.listeners.get(i);
            l.canvasResized();
        }
    }

    public static class GlobalTransform {
        Transform3D[] transforms;
    }
}

