/*
 * Decompiled with CFR 0.152.
 */
package ij3d.pointlist;

import ij3d.pointlist.PointListPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.ScrollPane;

public class PointListDialog
extends Dialog {
    private final GridBagConstraints c;
    private final GridBagLayout gridbag;
    private final Panel panel = new Panel();
    private Panel extraPanel;

    public PointListDialog(Frame owner) {
        super(owner, "Point list");
        this.gridbag = new GridBagLayout();
        this.panel.setLayout(this.gridbag);
        this.panel.setBackground(Color.WHITE);
        this.c = new GridBagConstraints();
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.anchor = 18;
        this.c.weighty = 0.1f;
        this.c.fill = 0;
        ScrollPane scroll = new ScrollPane();
        scroll.add(this.panel);
        this.add(scroll);
    }

    public void addPointList(String name, PointListPanel plp) {
        if (!this.containsPointList(plp)) {
            plp.setName(name);
            this.gridbag.setConstraints(plp, this.c);
            this.panel.add(plp);
            ++this.c.gridx;
            if (!this.isVisible()) {
                this.setSize(250, 200);
                this.setVisible(true);
            }
        }
    }

    public void removePointList(PointListPanel plp) {
        if (this.containsPointList(plp)) {
            this.panel.remove(plp);
            --this.c.gridx;
            if (this.panel.getComponentCount() == 0) {
                this.setVisible(false);
            }
        }
    }

    public boolean containsPointList(PointListPanel plp) {
        Component[] c = this.panel.getComponents();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] != plp) continue;
            return true;
        }
        return false;
    }

    public void addPanel(Panel p) {
        if (this.extraPanel != null) {
            this.remove(this.extraPanel);
        }
        this.extraPanel = p;
        this.add((Component)p, "South");
        this.update();
    }

    public void removeExtraPanel() {
        if (this.extraPanel != null) {
            this.remove(this.extraPanel);
            this.extraPanel = null;
            this.update();
        }
    }

    public void update() {
        this.validateTree();
    }
}

